/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceTable;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.resource.java.PrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.UniqueConstraintImpl;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestablePrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.java.NestableSecondaryTable;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraint;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryTableImpl
extends AbstractResourceTable
implements NestableSecondaryTable {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SecondaryTable");
    private final List<NestablePrimaryKeyJoinColumn> pkJoinColumns = new ArrayList<NestablePrimaryKeyJoinColumn>();
    private final PkJoinColumnsContainerAnnotation pkJoinColumnsContainerAnnotation = new PkJoinColumnsContainerAnnotation();

    protected SecondaryTableImpl(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.pkJoinColumnsContainerAnnotation);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> catalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "catalog");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> schemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "schema");
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.SecondaryTable";
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        SecondaryTableAnnotation oldSecondaryTable = (SecondaryTableAnnotation)((Object)oldAnnotation);
        this.setName(oldSecondaryTable.getName());
        this.setCatalog(oldSecondaryTable.getCatalog());
        this.setSchema(oldSecondaryTable.getSchema());
        for (UniqueConstraintAnnotation uniqueConstraint : CollectionTools.iterable(oldSecondaryTable.uniqueConstraints())) {
            NestableUniqueConstraint newUniqueConstraint = this.addUniqueConstraint(oldSecondaryTable.indexOfUniqueConstraint(uniqueConstraint));
            newUniqueConstraint.initializeFrom((NestableAnnotation)((Object)uniqueConstraint));
        }
        for (PrimaryKeyJoinColumnAnnotation pkJoinColumn : CollectionTools.iterable(oldSecondaryTable.pkJoinColumns())) {
            NestablePrimaryKeyJoinColumn newPkJoinColumn = this.addPkJoinColumn(oldSecondaryTable.indexOfPkJoinColumn(pkJoinColumn));
            newPkJoinColumn.initializeFrom((NestableAnnotation)((Object)pkJoinColumn));
        }
    }

    @Override
    protected NestableUniqueConstraint createUniqueConstraint(int index) {
        return UniqueConstraintImpl.createSecondaryTableUniqueConstraint(this, this.getMember(), this.getDeclarationAnnotationAdapter(), index);
    }

    @Override
    public ListIterator<PrimaryKeyJoinColumnAnnotation> pkJoinColumns() {
        return new CloneListIterator(this.pkJoinColumns);
    }

    @Override
    public int pkJoinColumnsSize() {
        return this.pkJoinColumns.size();
    }

    @Override
    public NestablePrimaryKeyJoinColumn pkJoinColumnAt(int index) {
        return this.pkJoinColumns.get(index);
    }

    @Override
    public int indexOfPkJoinColumn(PrimaryKeyJoinColumnAnnotation joinColumn) {
        return this.pkJoinColumns.indexOf(joinColumn);
    }

    @Override
    public NestablePrimaryKeyJoinColumn addPkJoinColumn(int index) {
        NestablePrimaryKeyJoinColumn pkJoinColumn = (NestablePrimaryKeyJoinColumn)ContainerAnnotationTools.addNestedAnnotation(index, this.pkJoinColumnsContainerAnnotation);
        this.fireItemAdded("pkJoinColumnsList", index, pkJoinColumn);
        return pkJoinColumn;
    }

    protected void addPkJoinColumn(int index, NestablePrimaryKeyJoinColumn pkJoinColumn) {
        this.addItemToList(index, pkJoinColumn, this.pkJoinColumns, "pkJoinColumnsList");
    }

    @Override
    public void removePkJoinColumn(int index) {
        NestablePrimaryKeyJoinColumn pkJoinColumn = this.pkJoinColumns.get(index);
        this.removePkJoinColumn(pkJoinColumn);
        pkJoinColumn.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.pkJoinColumnsContainerAnnotation);
    }

    protected void removePkJoinColumn(NestablePrimaryKeyJoinColumn pkJoinColumn) {
        this.removeItemFromList(pkJoinColumn, this.pkJoinColumns, "pkJoinColumnsList");
    }

    @Override
    public void movePkJoinColumn(int targetIndex, int sourceIndex) {
        this.movePkJoinColumnInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.pkJoinColumnsContainerAnnotation);
        this.fireItemMoved("pkJoinColumnsList", targetIndex, sourceIndex);
    }

    protected void movePkJoinColumnInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.pkJoinColumns, (int)targetIndex, (int)sourceIndex);
    }

    protected NestablePrimaryKeyJoinColumn createPrimaryKeyJoinColumn(int index) {
        return PrimaryKeyJoinColumnImpl.createSecondaryTablePrimaryKeyJoinColumn(this.getDeclarationAnnotationAdapter(), this, this.getMember(), index);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updatePkJoinColumnsFromJava(astRoot);
    }

    private void updatePkJoinColumnsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.pkJoinColumnsContainerAnnotation);
    }

    static SecondaryTableImpl createSecondaryTable(JavaResourceNode parent, Member member) {
        return new SecondaryTableImpl(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SecondaryTableImpl createNestedSecondaryTable(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SecondaryTableImpl.buildNestedDeclarationAnnotationAdapter(index, secondaryTablesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SecondaryTableImpl(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter secondaryTablesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(secondaryTablesAdapter, index, "javax.persistence.SecondaryTable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PkJoinColumnsContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestablePrimaryKeyJoinColumn> {
        public PkJoinColumnsContainerAnnotation() {
            super(SecondaryTableImpl.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public NestablePrimaryKeyJoinColumn addInternal(int index) {
            NestablePrimaryKeyJoinColumn pKJoinColumn = SecondaryTableImpl.this.createPrimaryKeyJoinColumn(index);
            SecondaryTableImpl.this.pkJoinColumns.add(index, pKJoinColumn);
            return pKJoinColumn;
        }

        @Override
        public NestablePrimaryKeyJoinColumn add(int index) {
            NestablePrimaryKeyJoinColumn pKJoinColumn = SecondaryTableImpl.this.createPrimaryKeyJoinColumn(index);
            SecondaryTableImpl.this.addPkJoinColumn(index, pKJoinColumn);
            return pKJoinColumn;
        }

        @Override
        public int indexOf(NestablePrimaryKeyJoinColumn pkJoinColumn) {
            return SecondaryTableImpl.this.indexOfPkJoinColumn(pkJoinColumn);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            SecondaryTableImpl.this.movePkJoinColumn(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            SecondaryTableImpl.this.movePkJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestablePrimaryKeyJoinColumn nestedAnnotationAt(int index) {
            return SecondaryTableImpl.this.pkJoinColumnAt(index);
        }

        @Override
        public ListIterator<NestablePrimaryKeyJoinColumn> nestedAnnotations() {
            return new CloneListIterator(SecondaryTableImpl.this.pkJoinColumns);
        }

        @Override
        public int nestedAnnotationsSize() {
            return SecondaryTableImpl.this.pkJoinColumnsSize();
        }

        @Override
        public String getAnnotationName() {
            return SecondaryTableImpl.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.PrimaryKeyJoinColumn";
        }

        @Override
        public NestablePrimaryKeyJoinColumn nestedAnnotationFor(org.eclipse.jdt.core.dom.Annotation jdtAnnotation) {
            for (NestablePrimaryKeyJoinColumn pkJoinColumn : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != pkJoinColumn.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return pkJoinColumn;
            }
            return null;
        }

        @Override
        public void remove(int index) {
            this.remove(this.nestedAnnotationAt(index));
        }

        @Override
        public void remove(NestablePrimaryKeyJoinColumn pkJoinColumn) {
            SecondaryTableImpl.this.removePkJoinColumn(pkJoinColumn);
        }

        @Override
        public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return SecondaryTableImpl.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            SecondaryTableImpl.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            SecondaryTableImpl.this.removeAnnotation();
        }

        @Override
        public void updateFromJava(CompilationUnit astRoot) {
            SecondaryTableImpl.this.updateFromJava(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return SecondaryTableImpl.this.getTextRange(astRoot);
        }

        @Override
        public String getElementName() {
            return "pkJoinColumns";
        }
    }

    public static class SecondaryTableAnnotationDefinition
    implements AnnotationDefinition {
        private static final SecondaryTableAnnotationDefinition INSTANCE = new SecondaryTableAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private SecondaryTableAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return SecondaryTableImpl.createSecondaryTable(parent, member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.SecondaryTable";
        }
    }
}

