/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullTemporal;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalImpl
extends AbstractResourceAnnotation<Attribute>
implements TemporalAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Temporal");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = TemporalImpl.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private TemporalType value;

    protected TemporalImpl(JavaResourceNode parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, VALUE_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Temporal";
    }

    @Override
    public TemporalType getValue() {
        return this.value;
    }

    @Override
    public void setValue(TemporalType newValue) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)newValue)) {
            return;
        }
        TemporalType oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(TemporalType.toJavaAnnotationValue(newValue));
        this.firePropertyChanged("valueProperty", (Object)oldValue, (Object)newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected TemporalType value(CompilationUnit astRoot) {
        return TemporalType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    }

    public static class TemporalAnnotationDefinition
    implements AnnotationDefinition {
        private static final TemporalAnnotationDefinition INSTANCE = new TemporalAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private TemporalAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new TemporalImpl(parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullTemporal(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.Temporal";
        }
    }
}

