/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;

public class JPTTools {
    public static boolean fieldIsPersistable(IVariableBinding field) {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic((int)modifiers)) {
            return false;
        }
        return !Modifier.isTransient((int)modifiers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean methodIsPersistablePropertyGetter(IMethodBinding methodBinding) {
        IMethodBinding setMethod;
        if (JPTTools.methodHasBadModifiers(methodBinding)) {
            return false;
        }
        ITypeBinding returnType = methodBinding.getReturnType();
        if (returnType == null) {
            return false;
        }
        String returnTypeName = returnType.getQualifiedName();
        if (returnTypeName.equals("void")) {
            return false;
        }
        if (methodBinding.getParameterTypes().length != 0) {
            return false;
        }
        String methodName = methodBinding.getName();
        int beginIndex = 0;
        boolean booleanGetter = false;
        if (methodName.startsWith("is")) {
            if (!returnTypeName.equals("boolean")) return false;
            beginIndex = 2;
        } else {
            if (!methodName.startsWith("get")) return false;
            beginIndex = 3;
            if (returnTypeName.equals("boolean")) {
                booleanGetter = true;
            }
        }
        String capitalizedAttributeName = methodName.substring(beginIndex);
        if (booleanGetter) {
            IMethodBinding isMethod = JPTTools.methodBindingNoParameters(methodBinding.getDeclaringClass(), "is" + capitalizedAttributeName);
            if (isMethod == null) {
                return false;
            }
            if (isMethod.getReturnType().getName().equals("boolean")) {
                return false;
            }
        }
        if ((setMethod = JPTTools.methodBindingOneParameter(methodBinding.getDeclaringClass(), "set" + capitalizedAttributeName, returnTypeName)) == null) {
            return false;
        }
        if (!JPTTools.methodHasBadModifiers(setMethod)) return setMethod.getReturnType().getName().equals("void");
        return false;
    }

    private static IMethodBinding methodBindingNoParameters(ITypeBinding typeBinding, String methodName) {
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static IMethodBinding methodBindingOneParameter(ITypeBinding typeBinding, String methodName, String parameterTypeName) {
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getQualifiedName().equals(parameterTypeName)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean methodHasBadModifiers(IMethodBinding methodBinding) {
        if (methodBinding.isConstructor()) {
            return true;
        }
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isStatic((int)modifiers)) {
            return true;
        }
        if (Modifier.isFinal((int)modifiers)) {
            return true;
        }
        return !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers);
    }

    public static boolean typeIsPersistable(ITypeBinding typeBinding) {
        if (typeBinding.isInterface()) {
            return false;
        }
        if (typeBinding.isAnnotation()) {
            return false;
        }
        if (typeBinding.isEnum()) {
            return false;
        }
        if (typeBinding.isLocal()) {
            return false;
        }
        if (typeBinding.isAnonymous()) {
            return false;
        }
        int modifiers = typeBinding.getModifiers();
        if (Modifier.isFinal((int)modifiers)) {
            return false;
        }
        return !typeBinding.isMember() || Modifier.isStatic((int)modifiers);
    }
}

