/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.common;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.resource.common.JpaEObject;
import org.eclipse.jpt.core.resource.common.JpaXmlResource;
import org.eclipse.jpt.core.utility.AbstractTextRange;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaEObject
extends EObjectImpl
implements JpaEObject {
    protected IDOMNode node;
    private static final Map<Class<? extends AbstractJpaEObject>, Set<Integer>> insignificantFeatureIdSets = new Hashtable<Class<? extends AbstractJpaEObject>, Set<Integer>>();

    protected AbstractJpaEObject() {
    }

    @Override
    public IResource getPlatformResource() {
        return this.getResource().getFile();
    }

    @Override
    public JpaXmlResource getResource() {
        return (JpaXmlResource)this.eResource();
    }

    @Override
    public JpaEObject getRoot() {
        return ((JpaEObject)this.eContainer()).getRoot();
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch()) {
            super.eNotify(notification);
            this.featureChanged(notification.getFeatureID(this.getClass()));
        }
    }

    protected void featureChanged(int featureId) {
        if (this.featureIsSignificant(featureId)) {
            this.getResource().resourceChanged();
        }
    }

    protected boolean featureIsSignificant(int featureId) {
        return !this.featureIsInsignificant(featureId);
    }

    protected boolean featureIsInsignificant(int featureId) {
        return this.insignificantFeatureIds().contains(new Integer(featureId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> insignificantFeatureIds() {
        Map<Class<? extends AbstractJpaEObject>, Set<Integer>> map = insignificantFeatureIdSets;
        synchronized (map) {
            Set<Integer> insignificantXmlFeatureIds = insignificantFeatureIdSets.get(this.getClass());
            if (insignificantXmlFeatureIds == null) {
                insignificantXmlFeatureIds = new HashSet<Integer>();
                this.addInsignificantXmlFeatureIdsTo(insignificantXmlFeatureIds);
                insignificantFeatureIdSets.put(this.getClass(), insignificantXmlFeatureIds);
            }
            return insignificantXmlFeatureIds;
        }
    }

    protected void addInsignificantXmlFeatureIdsTo(Set<Integer> insignificantXmlFeatureIds) {
    }

    @Override
    public boolean isAllFeaturesUnset() {
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (!this.eIsSet(feature)) continue;
            return false;
        }
        return true;
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new XmlEAdapterList((Notifier)this);
        }
        return this.eAdapters;
    }

    public IDOMNode getNode() {
        return this.node;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getFullTextRange();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getFullTextRange();
    }

    public TextRange getFullTextRange() {
        return this.buildTextRange(this.node);
    }

    protected TextRange buildTextRange(IDOMNode domNode) {
        if (domNode == null) {
            return null;
        }
        return new DOMNodeTextRange(domNode);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.node == null) {
            return false;
        }
        return this.node.contains(textOffset);
    }

    private static class DOMNodeTextRange
    extends AbstractTextRange {
        private final IDOMNode node;

        DOMNodeTextRange(IDOMNode node) {
            this.node = node;
        }

        public int getOffset() {
            return this.node.getStartOffset();
        }

        public int getLength() {
            if (this.node.getNodeType() == 1) {
                return ((IDOMElement)this.node).getStartEndOffset() - this.node.getStartOffset();
            }
            return this.node.getLength();
        }

        public int getLineNumber() {
            return this.node.getStructuredDocument().getLineOfOffset(this.getOffset()) + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlEAdapterList<E>
    extends BasicNotifierImpl.EAdapterList<E> {
        public XmlEAdapterList(Notifier notifier) {
            super(notifier);
        }

        protected void didAdd(int index, E newObject) {
            super.didAdd(index, newObject);
            try {
                AbstractJpaEObject.this.node = (IDOMNode)ClassTools.executeMethod(newObject, (String)"getNode");
            }
            catch (RuntimeException runtimeException) {}
        }

        protected void didRemove(int index, E oldObject) {
            super.didRemove(index, oldObject);
            if (oldObject instanceof EMF2DOMAdapter && ((EMF2DOMAdapter)oldObject).getNode() == AbstractJpaEObject.this.node) {
                AbstractJpaEObject.this.node = null;
            }
        }
    }
}

