/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CascadeType {
    ALL("javax.persistence.CascadeType.ALL"),
    PERSIST("javax.persistence.CascadeType.PERSIST"),
    MERGE("javax.persistence.CascadeType.MERGE"),
    REMOVE("javax.persistence.CascadeType.REMOVE"),
    REFRESH("javax.persistence.CascadeType.REFRESH");

    private String javaAnnotationValue;

    private CascadeType(String javaAnnotationValue) {
        this.javaAnnotationValue = javaAnnotationValue;
    }

    public String getJavaAnnotationValue() {
        return this.javaAnnotationValue;
    }

    public static CascadeType[] fromJavaAnnotationValue(String[] javaAnnotationValues) {
        if (javaAnnotationValues == null) {
            return new CascadeType[0];
        }
        CascadeType[] cascadeTypes = new CascadeType[javaAnnotationValues.length];
        int i = 0;
        while (i < javaAnnotationValues.length) {
            String javaAnnotationValue = javaAnnotationValues[i];
            if (javaAnnotationValue != null) {
                cascadeTypes[i] = CascadeType.cascadeType(javaAnnotationValue);
            }
            ++i;
        }
        return cascadeTypes;
    }

    private static CascadeType cascadeType(String javaAnnotationValue) {
        if (javaAnnotationValue.equals(ALL.getJavaAnnotationValue())) {
            return ALL;
        }
        if (javaAnnotationValue.equals(PERSIST.getJavaAnnotationValue())) {
            return PERSIST;
        }
        if (javaAnnotationValue.equals(MERGE.getJavaAnnotationValue())) {
            return MERGE;
        }
        if (javaAnnotationValue.equals(REMOVE.getJavaAnnotationValue())) {
            return REMOVE;
        }
        if (javaAnnotationValue.equals(REFRESH.getJavaAnnotationValue())) {
            return REFRESH;
        }
        throw new IllegalArgumentException("Unknown cascade type: " + javaAnnotationValue);
    }

    public static String[] toJavaAnnotationValue(CascadeType[] cascadeTypes) {
        String[] javaAnnotationValues = new String[cascadeTypes.length];
        int i = 0;
        while (i < cascadeTypes.length) {
            CascadeType cascadeType = cascadeTypes[i];
            javaAnnotationValues[i] = cascadeType.javaAnnotationValue;
            ++i;
        }
        return javaAnnotationValues;
    }
}

