/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.persistence;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.resource.common.JpaArtifactEdit;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class PersistenceArtifactEdit
extends JpaArtifactEdit {
    public static PersistenceArtifactEdit getArtifactEditForRead(IProject aProject) {
        PersistenceArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new PersistenceArtifactEdit(aProject, true);
        }
        catch (IllegalArgumentException iae) {
            JptCorePlugin.log(iae);
        }
        return artifactEdit;
    }

    public static PersistenceArtifactEdit getArtifactEditForWrite(IProject aProject) {
        PersistenceArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new PersistenceArtifactEdit(aProject, false);
        }
        catch (IllegalArgumentException iae) {
            JptCorePlugin.log(iae);
        }
        return artifactEdit;
    }

    public PersistenceArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public PersistenceResource getResource(IFile file) {
        try {
            PersistenceResource resource = (PersistenceResource)this.getArtifactEditModel().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            if (!resource.isLoaded()) {
                resource.load(this.getArtifactEditModel().getResourceSet().getLoadOptions());
            }
            return resource;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (IOException ioe) {
            JptCorePlugin.log(ioe);
            return null;
        }
    }

    public PersistenceResource getResource(String fileURI) {
        try {
            return (PersistenceResource)this.getArtifactEditModel().getResource(URI.createURI((String)fileURI));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public PersistenceResource getResource() {
        return this.getResource(JptCorePlugin.getPersistenceXmlDeploymentURI(this.getProject()));
    }

    public PersistenceResource createDefaultResource() {
        PersistenceResource resource = this.getResource();
        XmlPersistence persistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        persistence.setVersion("1.0");
        XmlPersistenceUnit pUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        pUnit.setName(this.getProject().getName());
        persistence.getPersistenceUnits().add((Object)pUnit);
        resource.getContents().add((Object)persistence);
        this.save(null);
        return resource;
    }

    public static /* bridge */ /* synthetic */ ArtifactEdit getArtifactEditForRead(IProject iProject) {
        return PersistenceArtifactEdit.getArtifactEditForRead(iProject);
    }

    public static /* bridge */ /* synthetic */ ArtifactEdit getArtifactEditForWrite(IProject iProject) {
        return PersistenceArtifactEdit.getArtifactEditForWrite(iProject);
    }
}

