/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.utility;

public interface TextRange {
    public int getOffset();

    public int getLength();

    public boolean includes(int var1);

    public boolean touches(int var1);

    public int getLineNumber();

    public boolean equals(Object var1);

    public int hashCode();

    public static final class Empty
    implements TextRange {
        public static final TextRange INSTANCE = new Empty();

        public static TextRange instance() {
            return INSTANCE;
        }

        private Empty() {
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public boolean includes(int index) {
            return false;
        }

        public boolean touches(int index) {
            return index == 0;
        }

        public int getLineNumber() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextRange)) {
                return false;
            }
            TextRange r = (TextRange)o;
            return r.getOffset() == 0 && r.getLength() == 0;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "TextRange.Empty";
        }
    }
}

