/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class EntityDialog
extends Dialog {
    private Entity entity;
    private JpaProject jpaProject;
    protected Combo nameCombo;
    private String selectedName;

    public EntityDialog(Shell parent, JpaProject jpaProject) {
        super(parent);
        this.jpaProject = jpaProject;
    }

    public EntityDialog(Shell parent, Entity entity, JpaProject jpaProject) {
        super(parent);
        this.entity = entity;
        this.jpaProject = jpaProject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return EclipseLinkUiMessages.EntityDialog_selectEntity;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label nameLabel = new Label(composite, 16384);
        nameLabel.setText(EclipseLinkUiMessages.EntityDialog_name);
        GridData gridData = new GridData();
        nameLabel.setLayoutData((Object)gridData);
        this.nameCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameCombo.setLayoutData((Object)gridData);
        this.populateNameCombo();
        return composite;
    }

    protected void populateNameCombo() {
        if (this.selectedName != null) {
            this.nameCombo.setText(this.selectedName);
        }
    }

    protected Combo getNameCombo() {
        return this.nameCombo;
    }

    protected Entity getEntity() {
        return this.entity;
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public void setSelectedName(String selectedName) {
        this.selectedName = selectedName;
    }

    public boolean close() {
        this.selectedName = this.nameCombo.getText();
        return super.close();
    }
}

