/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.connection;

import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.Connection;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.connection.JdbcBindParametersComposite;
import org.eclipse.jpt.eclipselink.ui.internal.connection.JdbcDriverComposite;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnectionPropertiesComposite
extends AbstractPane<Connection> {
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.eclipselink.ui.dialogs.ConnectionDialog";

    public JdbcConnectionPropertiesComposite(AbstractPane<Connection> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private WritablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"passwordProperty"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setPassword(value);
            }
        };
    }

    private Runnable buildPopulateFromConnectionAction() {
        return new Runnable(){

            public void run() {
                JdbcConnectionPropertiesComposite.this.promptConnection();
            }
        };
    }

    private WritablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"urlProperty"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setUrl(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildUserHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"userProperty"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getUser();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setUser(value);
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.buildHyperLink(container, "Populate from Connection...", this.buildPopulateFromConnectionAction());
        new JdbcDriverComposite(this, container);
        this.buildLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_urlLabel, this.buildUrlHolder());
        this.buildLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_userLabel, this.buildUserHolder());
        this.buildLabeledPasswordText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_passwordLabel, this.buildPasswordHolder());
        new JdbcBindParametersComposite(this, container);
    }

    private void promptConnection() {
        ConnecionSelectionDialog dialog = new ConnecionSelectionDialog();
        if (dialog.open() == 0) {
            String name = (String)dialog.getResult()[0];
            ConnectionProfile profile = JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(name);
            Connection connection = (Connection)this.subject();
            connection.setUrl(profile.getUrl());
            connection.setUser(profile.getUserName());
            connection.setPassword(profile.getUserPassword());
            connection.setDriver(profile.getDriverClassName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConnecionSelectionDialog
    extends FilteredItemsSelectionDialog {
        private ConnecionSelectionDialog() {
            super(JdbcConnectionPropertiesComposite.this.shell(), false);
            this.setMessage(EclipseLinkUiMessages.JdbcConnectionPropertiesComposite_ConnectionDialog_Message);
            this.setTitle(EclipseLinkUiMessages.JdbcConnectionPropertiesComposite_ConnectionDialog_Title);
            this.setListLabelProvider(this.buildLabelProvider());
            this.setDetailsLabelProvider(this.buildLabelProvider());
        }

        private ILabelProvider buildLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new ConnectionItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(null, -1);
            try {
                Iterator names = JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNames();
                while (names.hasNext()) {
                    provider.add(names.next(), itemsFilter);
                }
            }
            finally {
                monitor.done();
            }
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings dialogSettings = JptUiPlugin.getPlugin().getDialogSettings();
            IDialogSettings settings = dialogSettings.getSection(JdbcConnectionPropertiesComposite.DIALOG_SETTINGS);
            if (settings == null) {
                settings = dialogSettings.addNewSection(JdbcConnectionPropertiesComposite.DIALOG_SETTINGS);
            }
            return settings;
        }

        public String getElementName(Object object) {
            return object.toString();
        }

        protected Comparator<String> getItemsComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    return item1.compareTo(item2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            if (item == null) {
                return new Status(4, "org.eclipse.jpt.ui", 4, "", null);
            }
            return Status.OK_STATUS;
        }

        private class ConnectionItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            ConnectionItemsFilter() {
                super((FilteredItemsSelectionDialog)ConnecionSelectionDialog.this);
                if (StringTools.stringIsEmpty((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                return this.matches(item.toString());
            }
        }
    }
}

