/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.customization;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.eclipselink.core.internal.context.customization.Customization;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.eclipselink.ui.internal.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.customization.EntityCustomizationPropertyComposite;
import org.eclipse.jpt.eclipselink.ui.internal.customization.EntityCustomizerProperties;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite
extends AbstractPane<Customization> {
    private WritablePropertyValueModel<EntityCustomizerProperties> entityHolder;

    public EntityListComposite(AbstractPane<Customization> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.entityHolder = this.buildEntityHolder();
    }

    protected void initializeLayout(Composite container) {
        container = this.buildTitledPane(container, EclipseLinkUiMessages.CustomizationEntityListComposite_groupTitle);
        new AddRemoveListPane((AbstractPane)this, container, this.buildEntitiesAdapter(), this.buildEntityCustomizationListHolder(), this.entityHolder, this.buildEntityLabelProvider(), null);
        EntityCustomizationPropertyComposite pane = new EntityCustomizationPropertyComposite(this, (PropertyValueModel<EntityCustomizerProperties>)this.entityHolder, container);
        this.installPaneEnabler(this.entityHolder, pane);
    }

    private AddRemovePane.Adapter buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityListComposite.this.addEntities(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Customization customization = (Customization)EntityListComposite.this.subject();
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    EntityCustomizerProperties entityCustomization = (EntityCustomizerProperties)((Object)item);
                    customization.removeEntity(entityCustomization.getEntityName());
                    ++n2;
                }
            }
        };
    }

    private void addEntities(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Customization)this.subject()).entityExists(entityName)) {
                ((Customization)this.subject()).addEntity(entityName);
                int index = CollectionTools.indexOf((Iterator)((Customization)this.subject()).entities(), (Object)entityName);
                EntityCustomizerProperties item = (EntityCustomizerProperties)((Object)listSelectionModel.getListModel().getElementAt(index));
                this.entityHolder.setValue((Object)item);
            }
        }
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        TypeMapping mapping;
        PersistentType persistentType = ((Customization)this.subject()).persistenceUnit().getPersistentType(fullyQualifiedTypeName);
        if (persistentType != null && persistentType.getMappingKey() == "entity" && (mapping = persistentType.getMapping()) instanceof Entity) {
            return ((Entity)mapping).getName();
        }
        return null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.packageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.shell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CustomizationEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IPackageFragmentRoot packageFragmentRoot() {
        IProject project = ((Customization)this.subject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                EntityCustomizerProperties entityCustomization = (EntityCustomizerProperties)((Object)element);
                return entityCustomization.getEntityName();
            }
        };
    }

    private WritablePropertyValueModel<EntityCustomizerProperties> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<EntityCustomizerProperties> buildEntityCustomizationListHolder() {
        return new TransformationListValueModelAdapter<String, EntityCustomizerProperties>(this.buildEntitiesListHolder()){

            protected EntityCustomizerProperties transformItem(String item) {
                return new EntityCustomizerProperties((Customization)EntityListComposite.this.subject(), item);
            }
        };
    }

    private ListValueModel<String> buildEntitiesListHolder() {
        return new ListAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{"entitiesListProperty"}){

            protected ListIterator<String> listIterator_() {
                return ((Customization)this.subject).entities();
            }

            protected int size_() {
                return ((Customization)this.subject).entitiesSize();
            }
        };
    }

    private void installPaneEnabler(WritablePropertyValueModel<EntityCustomizerProperties> entityHolder, EntityCustomizationPropertyComposite pane) {
        new PaneEnabler(this.buildPaneEnablerHolder(entityHolder), (AbstractPane)pane);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(WritablePropertyValueModel<EntityCustomizerProperties> entityHolder) {
        return new TransformationPropertyValueModel<EntityCustomizerProperties, Boolean>(entityHolder){

            protected Boolean transform_(EntityCustomizerProperties value) {
                return value.entityNameIsValid();
            }
        };
    }
}

