/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsValidator
implements IValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsvalidator"));
    private IValidator fMessageOriginator;
    private static String[] jsdtValidator = new String[]{"org.eclipse.wst.jsdt.web.core.internal.validation.JsBatchValidator"};
    static /* synthetic */ Class class$0;

    public JsValidator() {
        this.fMessageOriginator = this;
    }

    public JsValidator(IValidator validator) {
        this.fMessageOriginator = validator;
    }

    private IMessage createMessageFromProblem(IProblem problem, IFile f, IJsTranslation translation, IStructuredDocument structuredDoc) {
        int sourceStart = problem.getSourceStart();
        int sourceEnd = problem.getSourceEnd();
        if (sourceStart == -1) {
            return null;
        }
        int lineNo = structuredDoc.getLineOfOffset(sourceStart) + 1;
        int sev = problem.isError() ? 1 : 2;
        LocalizedMessage m = new LocalizedMessage(sev, problem.getMessage(), (IResource)f);
        m.setLineNo(lineNo);
        m.setOffset(sourceStart);
        m.setLength(sourceEnd - sourceStart + 1);
        return m;
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model, boolean inBatch) {
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            this.setupAdapterFactory((IStructuredModel)domModel);
            IDOMDocument xmlDoc = domModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JsTranslationAdapter translationAdapter = (JsTranslationAdapter)xmlDoc.getAdapterFor((Object)clazz);
            IJsTranslation translation = translationAdapter.getJSPTranslation(false);
            if (!reporter.isCancelled()) {
                translation.setProblemCollectingActive(true);
                translation.reconcileCompilationUnit();
                List problems = translation.getProblems();
                if (!inBatch) {
                    reporter.removeAllMessages((IValidator)this, (Object)f);
                }
                int i = 0;
                while (i < problems.size() && !reporter.isCancelled()) {
                    IMessage m = this.createMessageFromProblem((IProblem)problems.get(i), f, translation, domModel.getStructuredDocument());
                    if (m != null) {
                        reporter.addMessage(this.fMessageOriginator, m);
                    }
                    ++i;
                }
            }
        }
    }

    private void setupAdapterFactory(IStructuredModel sm) {
        FactoryRegistry factoryRegistry = sm.getFactoryRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (factoryRegistry.getFactoryFor((Object)clazz) == null) {
            JsTranslationAdapterFactory factory = new JsTranslationAdapterFactory();
            sm.getFactoryRegistry().addFactory((INodeAdapterFactory)factory);
        }
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (uris.length <= 0) break block10;
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        reporter.removeAllMessages((IValidator)this, (Object)currentFile);
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile)) {
                                int percent = i * 100 / uris.length + 1;
                                LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + uris[i]);
                                reporter.displaySubtask((IValidator)this, (IMessage)message);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i])) {
                    int percent = i * 100 / files.length + 1;
                    LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + files[i].getFullPath().toString());
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    public void cleanup(IReporter reporter) {
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 139->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class JSPFileVisitor
    implements IResourceProxyVisitor {
        private IContentType[] fContentTypes = null;
        private List fFiles = new ArrayList();
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (proxy.getType() == 1 && Util.isJsType(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }
    }
}

