/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.xsd.ui.internal.actions.MoveXSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ConnectableEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.xsd.XSDConcreteComponent;

public abstract class BaseDragAndDropCommand
extends BaseCommand {
    protected static int ABOVE_IS_CLOSER = 0;
    protected static int BELOW_IS_CLOSER = 1;
    protected EditPartViewer viewer;
    protected ChangeBoundsRequest request;
    protected boolean canExecute;
    protected GraphicalEditPart target;
    protected GraphicalEditPart leftSiblingEditPart;
    protected GraphicalEditPart rightSiblingEditPart;
    protected Point location;
    protected ConnectableEditPart parentEditPart;
    protected XSDConcreteComponent previousRefComponent = null;
    protected XSDConcreteComponent nextRefComponent = null;
    protected XSDConcreteComponent xsdComponentToDrag;
    protected XSDBaseFieldEditPart itemToDrag;
    protected Rectangle originalLocation;
    protected Polyline polyLine;
    protected MoveXSDBaseAction action;
    protected List targetSpacesList = new ArrayList();
    protected int closerSibling;

    public BaseDragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request) {
        this.viewer = viewer;
        this.request = request;
    }

    protected abstract void setup();

    public PointList getConnectionPoints(Rectangle draggedFigureBounds) {
        PointList pointList = null;
        if (this.target != null && this.itemToDrag != null && this.parentEditPart != null) {
            pointList = this.getConnectionPoints(this.parentEditPart, this.itemToDrag, draggedFigureBounds);
        }
        return pointList != null ? pointList : new PointList();
    }

    public PointList getConnectionPoints(ConnectableEditPart parentEditPart, BaseFieldEditPart childRefEditPart, Rectangle draggedFigureBounds) {
        PointList pointList = new PointList();
        int[] data = new int[1];
        Point a = this.getConnectionPoint(parentEditPart, childRefEditPart, data);
        if (a != null) {
            int draggedFigureBoundsY = draggedFigureBounds.y + draggedFigureBounds.height / 2;
            pointList.addPoint(a);
            if (data[0] == 0) {
                int x = a.x + 5;
                pointList.addPoint(new Point(x, a.y));
                pointList.addPoint(new Point(x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            } else {
                pointList.addPoint(new Point(a.x, draggedFigureBoundsY));
                pointList.addPoint(new Point(draggedFigureBounds.x, draggedFigureBoundsY));
            }
        }
        return pointList;
    }

    protected Point getConnectionPoint(ConnectableEditPart parentEditPart, BaseFieldEditPart childRefEditPart, int[] data) {
        Point point = null;
        List childList = parentEditPart.getChildren();
        if (parentEditPart.getFigure() instanceof GenericGroupFigure && childList.size() > 0) {
            point = new Point();
            Rectangle r = this.getConnectedEditPartConnectionBounds(parentEditPart);
            point.x = r.x + r.width;
            point.y = r.y + r.height / 2;
        }
        return point;
    }

    protected Rectangle getConnectedEditPartConnectionBounds(ConnectableEditPart editPart) {
        return this.getZoomedBounds(((GenericGroupFigure)editPart.getFigure()).getIconFigure().getBounds());
    }

    public void redo() {
    }

    public void undo() {
    }

    public void execute() {
        if (this.canExecute) {
            this.action.run();
        }
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    protected void commonSetup(List siblings, GraphicalEditPart movingEditPart) {
        boolean isHandled;
        this.closerSibling = ABOVE_IS_CLOSER;
        int pointerYLocation = this.location.y;
        int index = 0;
        while (index < siblings.size()) {
            int siblingYLocation;
            GraphicalEditPart sibling = (GraphicalEditPart)siblings.get(index);
            if (sibling instanceof BaseFieldEditPart && (siblingYLocation = this.getZoomedBounds((Rectangle)sibling.getFigure().getBounds()).getCenter().y) > pointerYLocation) {
                this.rightSiblingEditPart = sibling;
                if (index > 0) {
                    this.leftSiblingEditPart = (GraphicalEditPart)siblings.get(index - 1);
                }
                if (this.leftSiblingEditPart == null || Math.abs(this.getZoomedBounds((Rectangle)this.leftSiblingEditPart.getFigure().getBounds()).getCenter().y - pointerYLocation) <= Math.abs(siblingYLocation - pointerYLocation)) break;
                this.closerSibling = BELOW_IS_CLOSER;
                break;
            }
            ++index;
        }
        if (!(isHandled = this.handleFirstAndLastDropTargets(index, siblings))) {
            this.handleOtherTargets(index);
        }
        this.calculateLeftAndRightXSDComponents();
        this.xsdComponentToDrag = (XSDConcreteComponent)((XSDBaseAdapter)this.itemToDrag.getModel()).getTarget();
    }

    protected void calculateLeftAndRightXSDComponents() {
        if (this.leftSiblingEditPart instanceof XSDBaseFieldEditPart) {
            Object leftModel = ((XSDBaseFieldEditPart)this.leftSiblingEditPart).getModel();
            this.previousRefComponent = null;
            if (leftModel instanceof XSDBaseAdapter) {
                XSDBaseAdapter leftAdapter = (XSDBaseAdapter)leftModel;
                this.previousRefComponent = (XSDConcreteComponent)leftAdapter.getTarget();
            }
        }
        if (this.rightSiblingEditPart instanceof XSDBaseFieldEditPart) {
            Object rightModel = ((XSDBaseFieldEditPart)this.rightSiblingEditPart).getModel();
            this.nextRefComponent = null;
            if (rightModel instanceof XSDBaseAdapter) {
                XSDBaseAdapter rightAdapter = (XSDBaseAdapter)rightModel;
                this.nextRefComponent = (XSDConcreteComponent)rightAdapter.getTarget();
            }
        }
    }

    protected boolean handleFirstAndLastDropTargets(int index, List siblings) {
        if (index == 0 && siblings.size() > 0) {
            this.leftSiblingEditPart = null;
            this.rightSiblingEditPart = (GraphicalEditPart)siblings.get(0);
            this.closerSibling = BELOW_IS_CLOSER;
        } else if (index > 0 && index == siblings.size()) {
            this.leftSiblingEditPart = (GraphicalEditPart)siblings.get(index - 1);
            this.rightSiblingEditPart = null;
        }
        return false;
    }

    protected void handleOtherTargets(int index) {
        int in = 0;
        ConnectableEditPart previousModelEditPart = null;
        Iterator i = this.targetSpacesList.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            previousModelEditPart = this.parentEditPart;
            TargetConnectionSpacingFigureEditPart sp = (TargetConnectionSpacingFigureEditPart)o;
            this.parentEditPart = sp.getParent() instanceof ConnectableEditPart ? (ConnectableEditPart)sp.getParent() : null;
            if (++in <= index) continue;
            if (this.closerSibling != ABOVE_IS_CLOSER) break;
            this.parentEditPart = previousModelEditPart;
            break;
        }
    }

    protected List calculateFieldEditParts() {
        List list = this.target.getParent().getChildren();
        ArrayList listOfFields = new ArrayList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof BaseFieldEditPart)) continue;
            listOfFields.add(o);
        }
        return listOfFields;
    }

    protected PointList drawLines(Polyline polyLine) {
        PointList pointList = new PointList();
        if (this.leftSiblingEditPart != null) {
            Rectangle leftRectangle = this.getZoomedBounds(this.leftSiblingEditPart.getFigure().getBounds());
            int xCoord = leftRectangle.x;
            int yCoord = leftRectangle.y;
            int height = leftRectangle.height;
            int width = leftRectangle.width;
            this.addLineToPolyline(polyLine, xCoord, yCoord + height + 3, xCoord, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height - 3, xCoord, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord, yCoord + height, xCoord + width, yCoord + height);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord + height, xCoord + width, yCoord + height + 3);
        } else if (this.rightSiblingEditPart != null) {
            Rectangle rightRectangle = this.getZoomedBounds(this.rightSiblingEditPart.getFigure().getBounds());
            int xCoord = rightRectangle.x;
            int yCoord = rightRectangle.y;
            int width = rightRectangle.width;
            this.addLineToPolyline(polyLine, xCoord, yCoord + 3, xCoord, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord, yCoord - 3, xCoord, yCoord);
            this.addLineToPolyline(polyLine, xCoord, yCoord, xCoord + width, yCoord);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord - 3);
            this.addLineToPolyline(polyLine, xCoord + width, yCoord, xCoord + width, yCoord + 3);
        }
        return pointList;
    }

    protected Polyline addLineToPolyline(Polyline polyline, int x1, int y1, int x2, int y2) {
        polyline.addPoint(new Point(x1, y1));
        polyline.addPoint(new Point(x2, y2));
        return polyline;
    }

    public IFigure getFeedbackFigure() {
        Figure panel = new Figure();
        panel.setLayoutManager((LayoutManager)new FreeformLayout());
        panel.setOpaque(false);
        Polyline feedbackFigure = new Polyline();
        feedbackFigure.setLineWidth(2);
        this.drawLines(feedbackFigure);
        this.originalLocation = new Rectangle(feedbackFigure.getBounds());
        panel.add((IFigure)feedbackFigure);
        this.polyLine = new Polyline();
        this.polyLine.setLineStyle(4);
        this.polyLine.setLineWidth(1);
        panel.add((IFigure)this.polyLine);
        panel.setBounds(this.originalLocation);
        this.addConnectorToParent((IFigure)panel);
        if (this.parentEditPart != null && this.parentEditPart.getFigure() instanceof GenericGroupFigure) {
            GenericGroupFigure fig = (GenericGroupFigure)this.parentEditPart.getFigure();
            Rectangle iconBounds = this.getZoomedBounds(fig.getIconFigure().getBounds());
            RoundedRectangle roundedRectangle = new RoundedRectangle();
            roundedRectangle.setFill(false);
            roundedRectangle.setOpaque(true);
            roundedRectangle.setBounds(iconBounds);
            panel.add((IFigure)roundedRectangle);
        }
        return panel;
    }

    protected void addConnectorToParent(IFigure p) {
        Rectangle r = this.originalLocation.getCopy();
        Rectangle pBounds = r.getCopy();
        PointList pointList = this.getConnectionPoints(r);
        if (pointList != null && pointList.size() > 0) {
            this.polyLine.setPoints(pointList);
            Point firstPoint = pointList.getFirstPoint();
            if (firstPoint != null) {
                pBounds = pBounds.getUnion(new Rectangle(firstPoint.x, firstPoint.y, 1, 1));
            }
        }
        if (this.parentEditPart != null && this.parentEditPart.getFigure() instanceof GenericGroupFigure) {
            GenericGroupFigure fig = (GenericGroupFigure)this.parentEditPart.getFigure();
            Rectangle iconBounds = this.getZoomedBounds(fig.getIconFigure().getBounds());
            pBounds = pBounds.getUnion(iconBounds);
        }
        p.setBounds(pBounds);
        p.validate();
    }

    public Point getZoomedPoint(Point p) {
        double factor = ((ScalableRootEditPart)this.viewer.getRootEditPart()).getZoomManager().getZoom();
        int x = (int)Math.round((double)p.x * factor);
        int y = (int)Math.round((double)p.y * factor);
        return new Point(x, y);
    }

    public Rectangle getZoomedBounds(Rectangle r) {
        double factor = ((ScalableRootEditPart)this.viewer.getRootEditPart()).getZoomManager().getZoom();
        int x = (int)Math.round((double)r.x * factor);
        int y = (int)Math.round((double)r.y * factor);
        int width = (int)Math.round((double)r.width * factor);
        int height = (int)Math.round((double)r.height * factor);
        return new Rectangle(x, y, width, height);
    }

    protected void handleKeyboardDragAndDrop(XSDBaseFieldEditPart leftField, XSDBaseFieldEditPart rightField, int direction) {
        this.target = leftField;
        if (direction == 4) {
            if (this.itemToDrag == this.target) {
                return;
            }
            this.target = rightField;
        }
        this.location = null;
        if (this.target != null) {
            this.location = this.target.getFigure().getBounds().getCenter();
        }
    }
}

