/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionDetailsContentProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionItem;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.DialogNodeEditorConfiguration;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.ListNodeEditorConfiguration;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeEditorConfiguration;

public class ExtensionDetailsViewer
extends Viewer {
    private static final String ITEM_DATA = "ITEM_DATA";
    private static final String EDITOR_CONFIGURATION_DATA = "EDITOR_CONFIGURATION_DATA";
    Composite control;
    Composite composite;
    ExtensionDetailsContentProvider contentProvider;
    TabbedPropertySheetWidgetFactory widgetFactory;
    InternalControlListener internalControlListener;
    CommandStack commandStack;

    public ExtensionDetailsViewer(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.control = widgetFactory.createComposite(parent);
        this.internalControlListener = new InternalControlListener();
        this.control.setLayout((Layout)new GridLayout());
    }

    public Control getControl() {
        return this.control;
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        Control[] children = this.composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (control instanceof Text) {
                ExtensionItem item = (ExtensionItem)control.getData(ITEM_DATA);
                String value = this.contentProvider.getValue(item);
                ((Text)control).setText(value);
            }
            ++i;
        }
    }

    private void createTextOrComboControl(ExtensionItem item, Composite composite) {
        Text control = null;
        String value = this.contentProvider.getValue(item);
        NodeEditorConfiguration editorConfiguration = item.getPropertyEditorConfiguration();
        if (editorConfiguration != null && this.hasStyle(editorConfiguration, 2)) {
            ListNodeEditorConfiguration configuration = (ListNodeEditorConfiguration)editorConfiguration;
            CCombo combo = this.widgetFactory.createCCombo(composite);
            combo.setText(value);
            Object[] values = configuration.getValues(item);
            LabelProvider labelProvider = configuration.getLabelProvider();
            int j = 0;
            while (j < values.length) {
                Object o = values[j];
                String displayName = labelProvider != null ? labelProvider.getText(o) : o.toString();
                combo.add(displayName);
                ++j;
            }
            combo.addSelectionListener((SelectionListener)this.internalControlListener);
            control = combo;
        }
        if (control == null) {
            Text text = this.widgetFactory.createText(composite, value);
            text.addKeyListener((KeyListener)this.internalControlListener);
            control = text;
        }
        control.setData(ITEM_DATA, (Object)item);
        control.setLayoutData((Object)new GridData(768));
        control.addFocusListener((FocusListener)this.internalControlListener);
    }

    private void createButtonControl(ExtensionItem item, Composite composite) {
        NodeEditorConfiguration editorConfiguration = item.getPropertyEditorConfiguration();
        if (editorConfiguration != null && this.hasStyle(editorConfiguration, 4)) {
            DialogNodeEditorConfiguration configuration = (DialogNodeEditorConfiguration)editorConfiguration;
            Button button = new Button(composite, 0);
            GridData gridData = new GridData();
            gridData.heightHint = 17;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)this.internalControlListener);
            button.setData(ITEM_DATA, (Object)item);
            button.setData(EDITOR_CONFIGURATION_DATA, (Object)configuration);
            String text = configuration.getButonText();
            if (text != null) {
                button.setText(text);
            }
            button.setImage(configuration.getButtonImage());
        } else {
            Label placeHolder = new Label(composite, 0);
            placeHolder.setVisible(false);
            placeHolder.setEnabled(false);
            placeHolder.setLayoutData((Object)new GridData());
        }
    }

    public void setInput(Object input) {
        if (this.contentProvider == null) {
            return;
        }
        if (this.composite != null) {
            this.removeListeners();
            this.composite.dispose();
        }
        this.composite = this.widgetFactory.createComposite(this.control);
        this.composite.setBackground(ColorConstants.white);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(1808));
        Object[] items = this.contentProvider.getItems(input);
        int i = 0;
        while (i < items.length) {
            ExtensionItem item = (ExtensionItem)items[i];
            String name = this.contentProvider.getName(item);
            Label label = this.widgetFactory.createLabel(this.composite, String.valueOf(name) + ":");
            label.setLayoutData((Object)new GridData());
            this.createTextOrComboControl(item, this.composite);
            this.createButtonControl(item, this.composite);
            ++i;
        }
        this.control.layout(true);
    }

    private boolean hasStyle(NodeEditorConfiguration configuration, int style) {
        return (configuration.getStyle() & style) != 0;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public ExtensionDetailsContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ExtensionDetailsContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    private void applyEdit(ExtensionItem item, Widget widget) {
        if (item != null) {
            Command command;
            CCombo combo;
            int index;
            String value = null;
            if (widget instanceof Text) {
                Text text = (Text)widget;
                value = text.getText();
            } else if (widget instanceof CCombo && (index = (combo = (CCombo)widget).getSelectionIndex()) != -1) {
                value = combo.getItem(index);
            }
            if (value != null && (command = item.getUpdateValueCommand(value)) != null) {
                if (this.commandStack != null) {
                    this.commandStack.execute(command);
                } else {
                    command.execute();
                }
            }
        }
    }

    public void removeListeners() {
        if (this.composite != null && !this.composite.isDisposed()) {
            Control[] children = this.composite.getChildren();
            int length = children.length;
            int i = 0;
            while (i < length) {
                Control o = children[i];
                if (o instanceof CCombo) {
                    ((CCombo)o).removeSelectionListener((SelectionListener)this.internalControlListener);
                    o.removeFocusListener((FocusListener)this.internalControlListener);
                } else if (o instanceof Text) {
                    ((Text)o).removeKeyListener((KeyListener)this.internalControlListener);
                    o.removeFocusListener((FocusListener)this.internalControlListener);
                }
                ++i;
            }
        }
    }

    class InternalControlListener
    implements FocusListener,
    SelectionListener,
    KeyListener {
        InternalControlListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object item = e.widget.getData(ExtensionDetailsViewer.EDITOR_CONFIGURATION_DATA);
            if (item == null) {
                item = e.widget.getData(ExtensionDetailsViewer.ITEM_DATA);
            }
            if (item instanceof DialogNodeEditorConfiguration) {
                DialogNodeEditorConfiguration dialogNodeEditorConfiguration = (DialogNodeEditorConfiguration)item;
                dialogNodeEditorConfiguration.invokeDialog();
            } else if (item instanceof ExtensionItem) {
                ExtensionDetailsViewer.this.applyEdit((ExtensionItem)item, e.widget);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Object item = e.widget.getData(ExtensionDetailsViewer.ITEM_DATA);
            if (item instanceof ExtensionItem) {
                ExtensionDetailsViewer.this.applyEdit((ExtensionItem)item, e.widget);
            }
        }

        public void keyPressed(KeyEvent e) {
            Object item = e.widget.getData(ExtensionDetailsViewer.ITEM_DATA);
            if (item instanceof ExtensionItem && e.character == '\r') {
                ExtensionDetailsViewer.this.applyEdit((ExtensionItem)item, e.widget);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

