/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.Trace;
import org.eclipse.swt.graphics.Image;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_WIZ_RUNTIME_TYPE = "wiz_runtimeType";
    public static final String IMG_WIZ_CACTUS_TEST = "wiz_cactus_test";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = JavaServerUIPlugin.getInstance().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not set icon base URL", e);
        }
    }

    private ImageResource() {
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageDescriptors.get(key);
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_WIZ_RUNTIME_TYPE, "wizban/new_runtime_wiz.png");
        ImageResource.registerImage(IMG_WIZ_CACTUS_TEST, "wizban/new_test_wiz.png");
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

