/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.preference.BaseFigureDecorator;
import org.eclipse.jst.jsf.facesconfig.ui.preference.CompoundNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.IContainerFigure;
import org.eclipse.jst.jsf.facesconfig.ui.preference.PrintedPageLayer;
import org.eclipse.jst.jsf.facesconfig.ui.preference.TabbedTitleBarBorder;
import org.eclipse.jst.jsf.facesconfig.ui.preference.TabbedWindowBorder;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFigureListener;
import org.eclipse.jst.jsf.facesconfig.ui.preference.WindowFreeformHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

class WindowFigure
extends ScrollPane
implements IContainerFigure,
LayerConstants,
FreeformFigure {
    private TabbedWindowBorder windowBorder;
    private TabbedTitleBarBorder titleBarBorder;
    private FreeformViewport myViewport;
    private ScalableFreeformLayeredPane scaledLayers;
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;
    private FreeformLayer primaryLayer;
    private static final Font defaultFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    private static final Color defaultForegroundColor = ColorConstants.black;
    private static final Color defaultBackgroundColor = ColorConstants.white;
    private static final Color defaultGridColor = ColorConstants.lightGray;
    private static final Dimension defaultGridSpacing = null;
    private static final boolean defaultGridEnabled = false;
    private static final int LINE_ROUTING_MANUAL = 0;
    private static int defaultLineRoutingStyle = 0;
    private WindowFreeformHelper helper = new WindowFreeformHelper(this);

    public WindowFigure() {
        this.windowBorder = new TabbedWindowBorder(this);
        this.titleBarBorder = (TabbedTitleBarBorder)this.windowBorder.getInnerBorder();
        this.setBorder((Border)this.windowBorder);
        this.setFont(defaultFont);
        this.setForegroundColor(defaultForegroundColor);
        this.setBackgroundColor(defaultBackgroundColor);
        this.innerLayers = new FreeformLayeredPane();
        this.createLayers(this.innerLayers);
        this.myViewport = new FreeformViewport();
        this.myViewport.setContents((IFigure)this.innerLayers);
        this.setViewport((Viewport)this.myViewport);
        this.getGridLayer().setVisible(false);
        this.getGridLayer().setSpacing(defaultGridSpacing);
        this.getGridLayer().setForegroundColor(defaultGridColor);
        this.setText("Window");
        this.addTabbedWindowListener(new WindowFigureListener(){

            public void tabChanged(int oldIndex, int newIndex) {
                WindowFigure.this.internalSetCurrentTab(newIndex);
                WindowFigure.this.validate();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(IFigure ancestor) {
                WindowFigure.this.setVisible(true);
            }

            public void ancestorMoved(IFigure ancestor) {
            }

            public void ancestorRemoved(IFigure ancestor) {
                WindowFigure.this.setVisible(false);
            }
        });
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected ScalableFreeformLayeredPane createScaledLayers() {
        ScalableFreeformLayeredPane layers = new ScalableFreeformLayeredPane();
        layers.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layers.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        return layers;
    }

    protected LayeredPane getScaledLayers() {
        if (this.scaledLayers == null) {
            this.scaledLayers = this.createScaledLayers();
        }
        return this.scaledLayers;
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        PrintedPageLayer pageTileLayer = new PrintedPageLayer(this);
        pageTileLayer.setPageSize(new Dimension(0, 0));
        layeredPane.add((IFigure)pageTileLayer, (Object)"Printed Page", -1);
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer", -1);
        this.primaryLayer = new FreeformLayer();
        layeredPane.add((IFigure)this.primaryLayer, (Object)"Primary Layer", -1);
        this.primaryLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        layeredPane.add((IFigure)new MyFeedbackLayer(), (Object)"Feedback Layer");
        return layeredPane;
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected GridLayer createGridLayer() {
        return new MyGridLayer();
    }

    public GridLayer getGridLayer() {
        return (GridLayer)this.getLayer("Grid Layer");
    }

    public Layer getLayer(Object key) {
        Layer layer = null;
        if (this.scaledLayers != null) {
            layer = this.scaledLayers.getLayer(key);
        }
        if (layer != null) {
            return layer;
        }
        if (this.innerLayers == null) {
            return null;
        }
        layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    public Point getScrollPosition() {
        int x = this.getHorizontalScrollBar().getRangeModel().getValue();
        int y = this.getVerticalScrollBar().getRangeModel().getValue();
        return new Point(x, y);
    }

    public TabbedTitleBarBorder getTabbedTitleBarBorder() {
        return this.titleBarBorder;
    }

    public TabbedWindowBorder getTabbedWindowBorder() {
        return this.windowBorder;
    }

    public void addTabbedWindowListener(WindowFigureListener listener) {
        this.titleBarBorder.addTabbedWindowListener(listener);
    }

    public void removeTabbedWindowListener(WindowFigureListener listener) {
        this.titleBarBorder.removeTabbedWindowListener(listener);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension d = this.titleBarBorder.getMinimumSize(wHint, hHint);
        d.expand(this.getInsets().getWidth(), this.getInsets().getHeight());
        return d;
    }

    public int addTab(String s) {
        return this.titleBarBorder.addTab(s);
    }

    public void removeTab(int index) {
        this.titleBarBorder.removeTab(index);
        this.internalSetCurrentTab(this.titleBarBorder.getCurrentTab());
    }

    private void internalSetCurrentTab(int index) {
    }

    public void setCurrentTab(int index) {
        this.internalSetCurrentTab(index);
        this.titleBarBorder.setCurrentTab(index);
    }

    public int getCurrentTab() {
        return this.titleBarBorder.getCurrentTab();
    }

    public void setContents(IFigure figure) {
        this.titleBarBorder.setContents(0, figure);
        super.setContents(figure);
    }

    public void setContents(int index, Object contents) {
        if (contents instanceof IFigure) {
            this.setContents((IFigure)contents);
        }
        this.titleBarBorder.setContents(index, contents);
    }

    public Object getContents(int index) {
        return this.titleBarBorder.getContents(index);
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.windowBorder.setVisible(flag);
        IFigure contents = this.getContents();
        if (contents instanceof Composite) {
            ((Composite)contents).setVisible(flag);
        }
    }

    public void setHighlight(boolean flag) {
        this.windowBorder.setHighlight(flag);
    }

    public void setFont(Font f) {
        this.titleBarBorder.setFont(f);
    }

    public void setForegroundColor(Color c) {
        this.titleBarBorder.setTextColor(c);
    }

    public void setLineRoutingStyle(int style) {
        defaultLineRoutingStyle = style;
        this.revalidate();
    }

    public int getLineRoutingStyle() {
        return defaultLineRoutingStyle;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            IFigure parent = this.getParent();
            this.prefSize = parent.getSize();
            this.getLayoutManager().invalidate();
            Dimension m = super.getPreferredSize(wHint, hHint);
            if (this.getParent() instanceof CompoundNodeFigure) {
                if (((CompoundNodeFigure)parent).getState() == 2) {
                    Insets in = ((CompoundNodeFigure)this.getParent()).getAnchorInsets();
                    this.prefSize.width -= in.getWidth();
                    this.prefSize.height -= in.getHeight();
                }
            } else {
                if (m.width > this.prefSize.width) {
                    this.prefSize.width = m.width;
                }
                if (m.height > this.prefSize.height) {
                    this.prefSize.height = m.height;
                }
            }
        }
        return this.prefSize;
    }

    protected boolean isValidationRoot() {
        return true;
    }

    public void invalidate() {
        this.prefSize = null;
        super.invalidate();
    }

    public void setText(String name) {
        this.titleBarBorder.setLabel(name);
    }

    public String getText() {
        if (this.titleBarBorder == null) {
            return "??";
        }
        return this.titleBarBorder.getLabel();
    }

    public Rectangle getTextBounds() {
        Rectangle r = this.getClientArea().getCopy();
        r.height = this.titleBarBorder.getTextExtents((IFigure)this).height;
        r.x += this.getInsets().left;
        r.y -= this.getInsets().top;
        return r;
    }

    public Image getIcon() {
        return null;
    }

    public void setIcon(Image image) {
    }

    public void setToolTipText(String text) {
    }

    public String getToolTipText() {
        return null;
    }

    public void addDecorator(BaseFigureDecorator decorator) {
    }

    public void removeDecorator() {
    }

    public void removeDecorator(int position) {
    }

    public List getDecorators() {
        return null;
    }

    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    public Rectangle getFreeformExtent() {
        Rectangle r = this.helper.getFreeformExtent();
        r.x = 0;
        r.y = 0;
        return r;
    }

    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.helper.setFreeformBounds(bounds);
    }

    private class MyFeedbackLayer
    extends FreeformLayer {
        MyFeedbackLayer() {
            this.setEnabled(false);
        }
    }

    private class MyGridLayer
    extends GridLayer {
        private MyGridLayer() {
        }

        Point getOrigin() {
            return this.origin.getCopy();
        }
    }
}

