/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.util.HashMap;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Statement;
import org.eclipse.jem.internal.proxy.initParser.Static;

public class Cast
extends Expression {
    protected static final int BYTE_TYPE = 0;
    protected static final int SHORT_TYPE = 1;
    protected static final int INT_TYPE = 2;
    protected static final int LONG_TYPE = 3;
    protected static final int FLOAT_TYPE = 4;
    protected static final int DOUBLE_TYPE = 5;
    protected static final HashMap sTypeLookup = new HashMap(6);
    protected Static fCastType;
    protected boolean fIsClosed = false;

    static {
        sTypeLookup.put(Byte.TYPE, new Integer(0));
        sTypeLookup.put(Short.TYPE, new Integer(1));
        sTypeLookup.put(Integer.TYPE, new Integer(2));
        sTypeLookup.put(Long.TYPE, new Integer(3));
        sTypeLookup.put(Float.TYPE, new Integer(4));
        sTypeLookup.put(Double.TYPE, new Integer(5));
    }

    public Cast(Static castType, ClassLoader aClassLoader) {
        this.fCastType = castType;
        this.fClassLoader = aClassLoader;
    }

    public boolean isPrimitive() throws Exception {
        return this.getTypeClass().isPrimitive();
    }

    public Class getTypeClass() throws Exception {
        return this.fCastType.getTypeClass();
    }

    public boolean isComplete() {
        return this.currentExpression != null && this.currentExpression.isComplete();
    }

    public Object evaluate() throws Exception {
        if (this.getTypeClass() == this.currentExpression.getTypeClass()) {
            return this.currentExpression.evaluate();
        }
        if (this.getTypeClass().isPrimitive()) {
            if (!this.currentExpression.getTypeClass().isPrimitive() || this.currentExpression.getTypeClass() == Void.TYPE) {
                throw new EvaluationException(new ClassCastException(this.currentExpression.getTypeClass().getName()));
            }
            if (this.fCastType.getTypeClass() == Boolean.TYPE || this.currentExpression.getTypeClass() == Boolean.TYPE) {
                throw new EvaluationException(new ClassCastException(this.currentExpression.getTypeClass().getName()));
            }
            if (this.fCastType.getTypeClass() == Character.TYPE) {
                return new Character((char)((Number)this.currentExpression.evaluate()).intValue());
            }
            Number value = null;
            value = this.currentExpression.getTypeClass() == Character.TYPE ? (Number)new Integer(((Character)this.currentExpression.evaluate()).charValue()) : (Number)((Number)this.currentExpression.evaluate());
            switch ((Integer)sTypeLookup.get(this.fCastType.getTypeClass())) {
                case 0: {
                    return new Byte(value.byteValue());
                }
                case 1: {
                    return new Short(value.shortValue());
                }
                case 2: {
                    return new Integer(value.intValue());
                }
                case 3: {
                    return new Long(value.longValue());
                }
                case 4: {
                    return new Float(value.floatValue());
                }
                case 5: {
                    return new Double(value.doubleValue());
                }
            }
            return null;
        }
        return this.currentExpression.evaluate();
    }

    public Expression push(char[] token, char tokenDelimiter) {
        if (this.fCastType.getPrimitiveTypeClass() == null && !this.fIsClosed) {
            this.fCastType.push(token, tokenDelimiter);
            if (this.fCastType.getPrimitiveTypeClass() != null && tokenDelimiter == ')') {
                this.fIsClosed = true;
            }
            return this;
        }
        if (!this.fIsClosed) {
            Expression result = this.fCastType.push(token, tokenDelimiter);
            ++result.parenthesisLevel;
            return result;
        }
        if (this.currentExpression == null) {
            this.currentExpression = new Statement(this.fClassLoader);
            this.currentExpression = this.currentExpression.push(token, tokenDelimiter);
            return this;
        }
        Expression result = this.currentExpression.push(token, tokenDelimiter);
        if (result.isComplete()) {
            this.popExpressionStack();
        } else if (result != this.currentExpression) {
            this.pushExpressionStack(result);
        }
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Cast(");
        if (this.fCastType != null) {
            buffer.append(this.fCastType.toString());
        } else {
            buffer.append("???");
        }
        buffer.append(") ");
        if (this.currentExpression != null) {
            buffer.append(this.currentExpression.toString());
        } else {
            buffer.append("???");
        }
        return buffer.toString();
    }

    protected String getTypeClassName() {
        return this.fCastType.getTypeClassName();
    }
}

