/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValOperationJob;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.model.IValidatorVisitor;

public class ValOperationManager
implements IResourceChangeListener {
    private ValOperation _operation;
    private int _discardAutoPost;

    public static ValOperationManager getDefault() {
        return Singleton.valOperationManager;
    }

    private ValOperationManager() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        int kind = event.getBuildKind();
        if (kind == 15 && (type & 8) != 0) {
            this.processClean(event);
        }
        if (this.isBuildStarting(event)) {
            this._operation = new ValOperation();
            this._operation.setMultiProject(true);
            IValidatorVisitor visitor = new IValidatorVisitor(){

                public void visit(Validator validator, IProject project, ValType valType, ValOperation operation, IProgressMonitor monitor) {
                    validator.validationStarting(project, operation.getState(), monitor);
                }
            };
            ValManager.getDefault().accept(visitor, null, ValType.Build, this._operation, (IProgressMonitor)new NullProgressMonitor());
        }
        if (this.isBuildFinished(event)) {
            ValOperationJob finished = new ValOperationJob(this.getOperation());
            finished.schedule();
            this._operation = null;
        }
        if (Tracing.isLogging()) {
            String kindName = null;
            kindName = kind == 9 ? "Auto" : (kind == 15 ? "Clean" : (kind == 6 ? "Full" : (kind == 10 ? "Incremental" : String.valueOf(kind))));
            StringBuffer b = new StringBuffer(100);
            String sourceName = "unknown";
            if (event.getSource() instanceof IResource) {
                IResource res = (IResource)event.getSource();
                sourceName = res.getName();
            } else if (event.getSource() instanceof IWorkspace) {
                sourceName = "Workspace";
            }
            b.append("ValOperationManager-01: A resource has changed, source=" + sourceName + ", kind=" + kindName + ", event type=(" + type);
            if ((type & 0x10) != 0) {
                b.append(", post build");
            }
            if ((type & 8) != 0) {
                b.append(", pre build");
            }
            b.append(')');
            IResourceDelta rd = event.getDelta();
            if (rd == null) {
                b.append(", there was no resource delta");
            }
            Tracing.log(b);
        }
    }

    private boolean isBuildStarting(IResourceChangeEvent event) {
        boolean preBuild;
        int type = event.getType();
        int kind = event.getBuildKind();
        boolean isWorkspace = event.getSource() instanceof IWorkspace;
        boolean bl = preBuild = (type & 8) != 0;
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            if (isWorkspace && preBuild && kind == 15) {
                this._discardAutoPost = 1;
                return true;
            }
            if (isWorkspace && preBuild && kind == 9) {
                return true;
            }
        } else if (isWorkspace && preBuild && kind == 10) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBuildFinished(IResourceChangeEvent event) {
        boolean postBuild;
        if (this._operation == null) {
            return false;
        }
        int type = event.getType();
        int kind = event.getBuildKind();
        boolean isWorkspace = event.getSource() instanceof IWorkspace;
        boolean bl = postBuild = (type & 0x10) != 0;
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            if (!isWorkspace || !postBuild || kind != 9) return false;
            if (this._discardAutoPost != 1) return true;
            this._discardAutoPost = 0;
            return false;
        } else {
            if (!isWorkspace || !postBuild || kind != 10) return false;
            return true;
        }
    }

    private void processClean(IResourceChangeEvent event) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Object source = event.getSource();
        if (source instanceof IWorkspace) {
            ValManager.getDefault().clean(null, this.getOperation(), (IProgressMonitor)monitor);
        }
    }

    public ValOperation getOperation() {
        if (this._operation == null) {
            return new ValOperation();
        }
        return this._operation;
    }

    /* synthetic */ ValOperationManager(ValOperationManager valOperationManager) {
        this();
    }

    private static class Singleton {
        static ValOperationManager valOperationManager = new ValOperationManager(null);

        private Singleton() {
        }
    }
}

