/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements IDOMAttr {
    private ITextRegion equalRegion = null;
    private String name = null;
    private ITextRegion nameRegion = null;
    private String namespaceURI = null;
    private ElementImpl ownerElement = null;
    private ITextRegion valueRegion = null;
    private String valueSource = null;

    protected AttrImpl() {
    }

    protected AttrImpl(AttrImpl that) {
        super(that);
        if (that != null) {
            this.name = that.name;
            this.valueSource = that.getValueSource();
        }
    }

    public Node cloneNode(boolean deep) {
        AttrImpl cloned = new AttrImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    protected CMAttributeDeclaration getDeclaration() {
        ElementImpl element = (ElementImpl)this.getOwnerElement();
        if (element == null) {
            return null;
        }
        CMElementDeclaration elementDecl = element.getDeclaration();
        if (elementDecl == null) {
            return null;
        }
        List nodes = ModelQueryUtil.getModelQuery(this.getOwnerDocument()).getAvailableContent(this.getOwnerElement(), elementDecl, 1);
        String name = this.getName();
        int k = 0;
        while (k < nodes.size()) {
            CMNode cmnode = (CMNode)nodes.get(k);
            if (cmnode.getNodeType() == 2 && name.equals(cmnode.getNodeName())) {
                return (CMAttributeDeclaration)cmnode;
            }
            ++k;
        }
        return null;
    }

    public int getEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        int offset = this.ownerElement.getStartOffset();
        if (this.valueRegion != null) {
            return offset + this.valueRegion.getEnd();
        }
        if (this.equalRegion != null) {
            return offset + this.equalRegion.getEnd();
        }
        if (this.nameRegion != null) {
            return offset + this.nameRegion.getEnd();
        }
        return 0;
    }

    public ITextRegion getEqualRegion() {
        return this.equalRegion;
    }

    public String getLocalName() {
        if (this.name == null) {
            return null;
        }
        int index = this.name.indexOf(58);
        if (index < 0) {
            return this.name;
        }
        return this.name.substring(index + 1);
    }

    public String getName() {
        if (this.name == null) {
            return new String();
        }
        return this.name;
    }

    public ITextRegion getNameRegion() {
        return this.nameRegion;
    }

    public int getNameRegionEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getEndOffset(this.nameRegion);
    }

    public int getNameRegionStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getStartOffset(this.nameRegion);
    }

    public String getNameRegionText() {
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        return flatNode.getText(this.nameRegion);
    }

    public int getNameRegionTextEndOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return 0;
        }
        return flatNode.getTextEndOffset(this.nameRegion);
    }

    public String getNamespaceURI() {
        String nsAttrName = null;
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
        } else {
            String name = this.getName();
            if (name != null && name.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return this.namespaceURI;
        }
        nsAttrName = "xmlns:" + prefix;
        Node node = this.ownerElement;
        while (node != null) {
            if (node.getNodeType() != 1) break;
            Element element = node;
            Attr attr = element.getAttributeNode(nsAttrName);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return this.namespaceURI;
    }

    public String getNodeName() {
        return this.getName();
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    public String getPrefix() {
        if (this.name == null) {
            return null;
        }
        int index = this.name.indexOf(58);
        if (index <= 0) {
            return null;
        }
        if (this.name.charAt(0) == '<') {
            return null;
        }
        return this.name.substring(0, index);
    }

    public boolean getSpecified() {
        return this.valueRegion != null;
    }

    public int getStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        int offset = this.ownerElement.getStartOffset();
        if (this.nameRegion != null) {
            return offset + this.nameRegion.getStart();
        }
        if (this.equalRegion != null) {
            return offset + this.equalRegion.getStart();
        }
        if (this.valueRegion != null) {
            return offset + this.valueRegion.getStart();
        }
        return 0;
    }

    public String getValue() {
        return this.getValue(this.getValueSource());
    }

    private String getValue(String source) {
        if (source == null) {
            return new String();
        }
        if (source.length() == 0) {
            return source;
        }
        StringBuffer buffer = null;
        int offset = 0;
        int length = source.length();
        int ref = source.indexOf(38);
        while (ref >= 0) {
            String name;
            String value;
            int end = source.indexOf(59, ref + 1);
            if (end > ref + 1 && (value = this.getCharValue(name = source.substring(ref + 1, end))) != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                }
                if (ref > offset) {
                    buffer.append(source.substring(offset, ref));
                }
                buffer.append(value);
                offset = end + 1;
                ref = end;
            }
            ref = source.indexOf(38, ref + 1);
        }
        if (buffer == null) {
            return source;
        }
        if (length > offset) {
            buffer.append(source.substring(offset));
        }
        return buffer.toString();
    }

    public ITextRegion getValueRegion() {
        return this.valueRegion;
    }

    public int getValueRegionStartOffset() {
        if (this.ownerElement == null) {
            return 0;
        }
        IStructuredDocumentRegion structuredDocumentRegion = this.ownerElement.getFirstStructuredDocumentRegion();
        if (structuredDocumentRegion == null) {
            return 0;
        }
        if (this.valueRegion == null) {
            return 0;
        }
        return structuredDocumentRegion.getStartOffset(this.valueRegion);
    }

    public String getValueRegionText() {
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.ownerElement.getFirstStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (this.valueRegion == null) {
            return null;
        }
        return flatNode.getText(this.valueRegion);
    }

    public String getValueSource() {
        if (this.valueSource != null) {
            return this.valueSource;
        }
        if (this.ownerElement == null) {
            return null;
        }
        IStructuredDocumentRegion ownerRegion = this.ownerElement.getFirstStructuredDocumentRegion();
        if (ownerRegion == null) {
            return null;
        }
        if (this.valueRegion != null) {
            return StructuredDocumentRegionUtil.getAttrValue(ownerRegion, this.valueRegion);
        }
        return new String();
    }

    private String getValueSource(ElementImpl ownerElement) {
        if (this.valueSource != null) {
            return this.valueSource;
        }
        if (this.valueRegion != null) {
            return StructuredDocumentRegionUtil.getAttrValue(ownerElement.getStructuredDocumentRegion(), this.valueRegion);
        }
        return new String();
    }

    private String getValueSource(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        StringBuffer buffer = null;
        int offset = 0;
        int length = value.length();
        int amp = value.indexOf(38);
        while (amp >= 0) {
            if (buffer == null) {
                buffer = new StringBuffer(length + 4);
            }
            if (amp > offset) {
                buffer.append(value.substring(offset, amp));
            }
            buffer.append("&amp;");
            offset = amp + 1;
            amp = value.indexOf(38, offset);
        }
        if (buffer == null) {
            return value;
        }
        if (length > offset) {
            buffer.append(value.substring(offset));
        }
        return buffer.toString();
    }

    public boolean hasNestedValue() {
        if (this.valueRegion == null) {
            return false;
        }
        if (!(this.valueRegion instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)this.valueRegion).getRegions();
        if (regions == null) {
            return false;
        }
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            String regionType;
            ITextRegion region = (ITextRegion)e.next();
            if (region == null || (regionType = region.getType()) != "XML_TAG_OPEN" && !this.isNestedLanguageOpening(regionType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOnly() {
        return this.nameRegion != null && this.equalRegion == null && this.valueRegion == null;
    }

    protected final boolean hasPrefix() {
        if (this.name == null) {
            return false;
        }
        if (this.name.indexOf(58) <= 0) {
            return false;
        }
        return this.name.charAt(0) != '<';
    }

    protected final boolean ignoreCase() {
        DocumentImpl document;
        if (this.ownerElement != null ? this.ownerElement.ignoreCase() : (document = (DocumentImpl)this.getOwnerDocument()) != null && document.ignoreCase()) {
            return !this.hasPrefix();
        }
        return false;
    }

    public boolean isGlobalAttr() {
        if (this.hasPrefix()) {
            return false;
        }
        if (this.ownerElement == null) {
            return false;
        }
        return this.ownerElement.isGlobalTag();
    }

    public final boolean isXMLAttr() {
        DocumentImpl document;
        if (this.ownerElement != null ? !this.ownerElement.isXMLTag() : (document = (DocumentImpl)this.getOwnerDocument()) != null && !document.isXMLType()) {
            return this.hasPrefix();
        }
        return true;
    }

    protected boolean matchName(String name) {
        if (name == null) {
            return this.name == null;
        }
        if (this.name == null) {
            return false;
        }
        if (this.name.length() != name.length()) {
            return false;
        }
        if (this.name.equals(name)) {
            return true;
        }
        return this.name.equalsIgnoreCase(name) && this.ignoreCase();
    }

    protected void notifyNameChanged() {
        if (this.ownerElement == null) {
            return;
        }
        DocumentImpl document = (DocumentImpl)this.ownerElement.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.nameChanged(this);
    }

    protected void notifyValueChanged() {
        if (this.ownerElement == null) {
            return;
        }
        DocumentImpl document = (DocumentImpl)this.ownerElement.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this);
    }

    void removeRegions() {
        this.nameRegion = null;
        this.valueRegion = null;
        this.equalRegion = null;
    }

    void resetRegions() {
        this.valueSource = this.getValueSource();
        this.removeRegions();
    }

    void resetRegions(ElementImpl ownerElement) {
        this.valueSource = this.getValueSource(ownerElement);
        this.removeRegions();
    }

    void setEqualRegion(ITextRegion equalRegion) {
        this.equalRegion = equalRegion;
    }

    protected void setName(String name) {
        String value = null;
        int startOffset = 0;
        if (this.ownerElement != null) {
            value = this.getValue();
            startOffset = this.ownerElement.getStartOffset();
            this.ownerElement.notify(1, this, value, null, startOffset);
        }
        this.name = name;
        if (this.ownerElement != null) {
            this.ownerElement.notify(1, this, null, value, startOffset);
        }
    }

    void setNameRegion(ITextRegion nameRegion) {
        this.nameRegion = nameRegion;
    }

    protected void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    protected void setOwnerElement(Element ownerElement) {
        this.ownerElement = (ElementImpl)ownerElement;
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.ownerElement != null && !this.ownerElement.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        int prefixLength = prefix != null ? prefix.length() : 0;
        String localName = this.getLocalName();
        if (prefixLength == 0) {
            this.setName(localName);
            return;
        }
        if (localName == null) {
            localName = new String();
        }
        int localLength = localName.length();
        StringBuffer buffer = new StringBuffer(prefixLength + 1 + localLength);
        buffer.append(prefix);
        buffer.append(':');
        buffer.append(localName);
        this.setName(buffer.toString());
        this.notifyNameChanged();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String value) {
        try {
            this.getModel().aboutToChangeModel();
            this.setValueSource(this.getValueSource(value));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getModel().changedModel();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.getModel().changedModel();
    }

    void setValueRegion(ITextRegion valueRegion) {
        this.valueRegion = valueRegion;
        if (valueRegion != null) {
            this.valueSource = null;
        }
    }

    public void setValueSource(String source) {
        if (this.ownerElement != null && !this.ownerElement.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        this.valueSource = source;
        this.notifyValueChanged();
    }

    protected boolean isNestedLanguageOpening(String regionType) {
        boolean result = false;
        return result;
    }
}

