/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<E1, E2>
implements Iterator<E2> {
    private final Iterator<? extends E1> nestedIterator;
    private final Filter<E1> filter;
    private E2 next;
    private boolean done;

    public FilteringIterator(Iterator<? extends E1> nestedIterator) {
        this(nestedIterator, Filter.Disabled.instance());
    }

    public FilteringIterator(Iterator<? extends E1> nestedIterator, Filter<E1> filter) {
        this.nestedIterator = nestedIterator;
        this.filter = filter;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E2 next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E2 result = this.next;
        this.loadNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.done = true;
        while (this.nestedIterator.hasNext() && this.done) {
            E1 temp = this.nestedIterator.next();
            if (this.accept(temp)) {
                this.next = this.cast(temp);
                this.done = false;
                continue;
            }
            this.next = null;
            this.done = true;
        }
    }

    private E2 cast(E1 o) {
        return (E2)o;
    }

    protected boolean accept(E1 o) {
        return this.filter.accept(o);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nestedIterator);
    }
}

