/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeekableIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> nestedIterator;
    private E next;
    private boolean done;

    public PeekableIterator(Iterator<? extends E> nestedIterator) {
        this.nestedIterator = nestedIterator;
        this.done = false;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.loadNext();
        return result;
    }

    public E peek() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        if (this.nestedIterator.hasNext()) {
            this.next = this.nestedIterator.next();
        } else {
            this.next = null;
            this.done = true;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nestedIterator);
    }
}

