/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.TreeNodeValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNodeValueModel<T>
extends AbstractModel
implements TreeNodeValueModel<T> {
    protected AbstractTreeNodeValueModel() {
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return super.buildChangeSupport();
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoStateChangeListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(listener);
    }

    protected abstract void engageValue();

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoStateChangeListeners()) {
            this.disengageValue();
        }
    }

    protected abstract void disengageValue();

    @Override
    public void setValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TreeNodeValueModel<T>[] path() {
        List<TreeNodeValueModel<TreeNodeValueModel>> path = CollectionTools.reverseList(this.backPath());
        return path.toArray(new TreeNodeValueModel[path.size()]);
    }

    protected Iterator<TreeNodeValueModel<T>> backPath() {
        return new ChainIterator<TreeNodeValueModel<T>>(this){

            @Override
            protected TreeNodeValueModel<T> nextLink(TreeNodeValueModel<T> currentLink) {
                return currentLink.parent();
            }
        };
    }

    @Override
    public TreeNodeValueModel<T> child(int index) {
        return this.childrenModel().get(index);
    }

    @Override
    public int childrenSize() {
        return this.childrenModel().size();
    }

    @Override
    public int indexOfChild(TreeNodeValueModel<T> child) {
        ListValueModel children = this.childrenModel();
        int size = children.size();
        int i = 0;
        while (i < size) {
            if (children.get(i) == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.childrenModel().size() == 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeNodeValueModel other = (AbstractTreeNodeValueModel)o;
        return this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

