/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberSpinnerModelAdapter
extends SpinnerNumberModel {
    private final Number defaultValue;
    private final WritablePropertyValueModel<Number> numberHolder;
    private final PropertyChangeListener numberChangeListener;

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder) {
        this(numberHolder, 0);
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, int defaultValue) {
        this(numberHolder, null, null, new Integer(1), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, int minimum, int maximum, int stepSize) {
        this(numberHolder, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, int minimum, int maximum, int stepSize, int defaultValue) {
        this(numberHolder, new Integer(minimum), new Integer(maximum), new Integer(stepSize), new Integer(defaultValue));
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, double value, double minimum, double maximum, double stepSize) {
        this(numberHolder, value, minimum, maximum, stepSize, minimum);
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, double value, double minimum, double maximum, double stepSize, double defaultValue) {
        this(numberHolder, new Double(minimum), new Double(maximum), new Double(stepSize), new Double(defaultValue));
    }

    public NumberSpinnerModelAdapter(WritablePropertyValueModel<Number> numberHolder, Comparable<?> minimum, Comparable<?> maximum, Number stepSize, Number defaultValue) {
        super(numberHolder.getValue() == null ? (Number)defaultValue : (Number)((Number)numberHolder.getValue()), minimum, maximum, stepSize);
        this.numberHolder = numberHolder;
        this.numberChangeListener = this.buildNumberChangeListener();
        this.defaultValue = defaultValue;
    }

    protected PropertyChangeListener buildNumberChangeListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildNumberChangeListener_());
    }

    protected PropertyChangeListener buildNumberChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                NumberSpinnerModelAdapter.this.synchronize(event.getNewValue());
            }

            public String toString() {
                return "number listener";
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.numberHolder.getValue()));
        }
        return super.getValue();
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.numberHolder.setValue((Number)value);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.addPropertyChangeListener("value", this.numberChangeListener);
            this.synchronize(this.numberHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.removePropertyChangeListener("value", this.numberChangeListener);
        }
    }

    protected Number getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.numberHolder);
    }
}

