/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.ResourceModelListener;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JpaCompilationUnit;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaProject
extends AbstractJpaNode
implements JpaProject {
    protected final IProject project;
    protected final JpaPlatform jpaPlatform;
    protected final JpaDataSource dataSource;
    protected String userOverrideDefaultSchemaName;
    protected boolean discoversAnnotatedClasses;
    protected final Vector<JpaFile> jpaFiles;
    protected JpaRootContextNode rootContextNode;
    protected final ThreadLocal<CommandExecutor> threadLocalModifySharedDocumentCommandExecutor;
    protected final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    protected JpaProject.Updater updater;
    protected ResourceModelListener resourceModelListener;
    private boolean okToContinueValidation = true;
    protected boolean okToProceedForConnectionValidation = true;
    protected static final String WEB_PROJECT_ROOT_DEPLOY_LOCATION = "WEB-INF/classes";
    protected static final String JST_WEB_MODULE = "jst.web";

    public GenericJpaProject(JpaProject.Config config) throws CoreException {
        super(null);
        if (config.getProject() == null || config.getJpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.project = config.getProject();
        this.jpaPlatform = config.getJpaPlatform();
        this.dataSource = this.getJpaFactory().buildJpaDataSource(this, config.getConnectionProfileName());
        this.userOverrideDefaultSchemaName = config.getUserOverrideDefaultSchemaName();
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.jpaFiles = this.buildEmptyJpaFiles();
        this.threadLocalModifySharedDocumentCommandExecutor = this.buildThreadLocalModifySharedDocumentCommandExecutor();
        this.modifySharedDocumentCommandExecutorProvider = this.buildModifySharedDocumentCommandExecutorProvider();
        this.resourceModelListener = this.buildResourceModelListener();
        this.project.accept(this.buildInitialResourceProxyVisitor(), 0);
        this.rootContextNode = this.buildRootContextNode();
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected Vector<JpaFile> buildEmptyJpaFiles() {
        return new Vector<JpaFile>();
    }

    protected ResourceDeltaVisitor buildResourceDeltaVisitor() {
        return new ResourceDeltaVisitor();
    }

    protected ThreadLocal<CommandExecutor> buildThreadLocalModifySharedDocumentCommandExecutor() {
        return new ThreadLocal<CommandExecutor>();
    }

    protected CommandExecutorProvider buildModifySharedDocumentCommandExecutorProvider() {
        return new ModifySharedDocumentCommandExecutorProvider();
    }

    protected ResourceModelListener buildResourceModelListener() {
        return new DefaultResourceModelListener();
    }

    protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected JpaRootContextNode buildRootContextNode() {
        return this.getJpaFactory().buildRootContext(this);
    }

    @Override
    public JpaProject getJpaProject() {
        return this;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public JpaPlatform getJpaPlatform() {
        return this.jpaPlatform;
    }

    @Override
    public JpaDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    @Override
    public Schema getDefaultSchema() {
        Schema defaultSchema = this.getUserOverrideDefaultSchema();
        if (defaultSchema != null) {
            return defaultSchema;
        }
        return this.getConnectionProfile().getDefaultSchema();
    }

    @Override
    public Schema getUserOverrideDefaultSchema() {
        if (this.userOverrideDefaultSchemaName == null) {
            return null;
        }
        return this.getConnectionProfile().getDatabase().schemaNamed(this.userOverrideDefaultSchemaName);
    }

    @Override
    public String getUserOverrideDefaultSchemaName() {
        return this.userOverrideDefaultSchemaName;
    }

    @Override
    public void setUserOverrideDefaultSchemaName(String newDefaultSchemaName) {
        String oldDefaultSchemaName = this.userOverrideDefaultSchemaName;
        this.userOverrideDefaultSchemaName = newDefaultSchemaName;
        this.firePropertyChanged("userOverrideDefaultSchemaName", oldDefaultSchemaName, newDefaultSchemaName);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public Iterator<JpaFile> jpaFiles() {
        return new CloneIterator(this.jpaFiles);
    }

    @Override
    public int jpaFilesSize() {
        return this.jpaFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JpaFile getJpaFile(IFile file) {
        Vector<JpaFile> vector = this.jpaFiles;
        synchronized (vector) {
            for (JpaFile jpaFile : this.jpaFiles) {
                if (!jpaFile.getFile().equals((Object)file)) continue;
                return jpaFile;
            }
        }
        return null;
    }

    @Override
    public Iterator<JpaFile> jpaFiles(final String resourceType) {
        return new FilteringIterator<JpaFile, JpaFile>(this.jpaFiles()){

            protected boolean accept(JpaFile o) {
                return o.getResourceType().equals(resourceType);
            }
        };
    }

    protected boolean addJpaFile(IFile file) {
        JpaFile jpaFile = this.addJpaFileInternal(file);
        if (jpaFile != null) {
            this.fireItemAdded("jpaFiles", jpaFile);
            return true;
        }
        return false;
    }

    protected JpaFile addJpaFileInternal(IFile file) {
        JpaFile jpaFile = this.jpaPlatform.buildJpaFile(this, file);
        if (jpaFile == null) {
            return null;
        }
        this.jpaFiles.add(jpaFile);
        jpaFile.getResourceModel().addResourceModelChangeListener(this.resourceModelListener);
        return jpaFile;
    }

    protected boolean removeJpaFile(IFile file) {
        JpaFile jpaFile = this.getJpaFile(file);
        if (jpaFile != null) {
            this.removeJpaFile(jpaFile);
            return true;
        }
        return false;
    }

    protected void removeJpaFile(JpaFile jpaFile) {
        jpaFile.getResourceModel().removeResourceModelChangeListener(this.resourceModelListener);
        jpaFile.dispose();
        if (!this.removeItemFromCollection(jpaFile, this.jpaFiles, "jpaFiles")) {
            throw new IllegalArgumentException("JPA file: " + jpaFile.getFile().getName());
        }
    }

    protected boolean containsJpaFile(IFile file) {
        return this.getJpaFile(file) != null;
    }

    @Override
    public JpaRootContextNode getRootContext() {
        return this.rootContextNode;
    }

    @Override
    public Iterator<String> annotatedClassNames() {
        return new TransformationIterator<JavaResourcePersistentType, String>(this.annotatedJavaPersistentTypes()){

            protected String transform(JavaResourcePersistentType next) {
                return next.getQualifiedName();
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> annotatedJavaPersistentTypes() {
        return new FilteringIterator<JavaResourcePersistentType, JavaResourcePersistentType>(this.javaResourcePersistentTypes()){

            protected boolean accept(JavaResourcePersistentType persistentType) {
                return persistentType == null ? false : persistentType.isPersisted();
            }
        };
    }

    protected Iterator<JavaResourcePersistentType> javaResourcePersistentTypes() {
        return new CompositeIterator((Iterator)new TransformationIterator<JpaCompilationUnit, Iterator<JavaResourcePersistentType>>(this.jpaCompilationUnitResources()){

            protected Iterator<JavaResourcePersistentType> transform(JpaCompilationUnit next) {
                if (next.getPersistentType() == null) {
                    return EmptyIterator.instance();
                }
                return new CompositeIterator((Object)next.getPersistentType(), next.getPersistentType().nestedTypes());
            }
        });
    }

    public Iterator<JpaFile> javaJpaFiles() {
        return this.jpaFiles("JAVA_RESOURCE_TYPE");
    }

    protected Iterator<JpaCompilationUnit> jpaCompilationUnitResources() {
        return new TransformationIterator<JpaFile, JpaCompilationUnit>(this.javaJpaFiles()){

            protected JpaCompilationUnit transform(JpaFile jpaFile) {
                return ((JavaResourceModel)jpaFile.getResourceModel()).getJpaCompilationUnit();
            }
        };
    }

    @Override
    public JavaResourcePersistentType getJavaPersistentTypeResource(String typeName) {
        for (JpaCompilationUnit jpCompilationUnitResource : CollectionTools.iterable(this.jpaCompilationUnitResources())) {
            JavaResourcePersistentType jptr = jpCompilationUnitResource.getJavaPersistentTypeResource(typeName);
            if (jptr == null) continue;
            return jptr;
        }
        return null;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        Iterator<JpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            stream.next().javaElementChanged(event);
        }
    }

    @Override
    public Iterator<IMessage> validationMessages() {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.jpaPlatform.addToMessages(this, messages);
        return messages.iterator();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        this.addProjectLevelMessages(messages);
        this.getRootContext().addToMessages(messages);
    }

    protected void addProjectLevelMessages(List<IMessage> messages) {
        this.addConnectionMessages(messages);
        this.addMultiplePersistenceXmlMessage(messages);
    }

    protected void addConnectionMessages(List<IMessage> messages) {
        this.addNoConnectionMessage(messages);
        this.addInvalidConnectionMessage(messages);
        this.addInactiveConnectionMessage(messages);
    }

    protected void addNoConnectionMessage(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.getDataSource().getConnectionProfileName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_NO_CONNECTION", this));
            this.okToProceedForConnectionValidation = false;
        }
    }

    protected void addInvalidConnectionMessage(List<IMessage> messages) {
        if (this.okToProceedForConnectionValidation && !this.getDataSource().hasAConnection()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INVALID_CONNECTION", new String[]{this.getDataSource().getConnectionProfileName()}, this));
            this.okToProceedForConnectionValidation = false;
        }
    }

    protected void addInactiveConnectionMessage(List<IMessage> messages) {
        if (this.okToProceedForConnectionValidation && !this.getDataSource().connectionProfileIsActive()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PROJECT_INACTIVE_CONNECTION", new String[]{this.getDataSource().getConnectionProfileName()}, this));
        }
        this.okToProceedForConnectionValidation = true;
    }

    protected void addMultiplePersistenceXmlMessage(List<IMessage> messages) {
    }

    @Override
    public String getRootDeployLocation() {
        return this.isWebProject() ? WEB_PROJECT_ROOT_DEPLOY_LOCATION : "";
    }

    protected boolean isWebProject() {
        return JptCorePlugin.projectHasWebFacet(this.project);
    }

    @Override
    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        Iterator<JpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            this.removeJpaFile(stream.next());
        }
        this.dataSource.dispose();
    }

    @Override
    public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
        ResourceDeltaVisitor resourceDeltaVisitor = this.buildResourceDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
        if (resourceDeltaVisitor.jpaFilesChanged()) {
            for (JpaFile jpaFile : CollectionTools.iterable(this.jpaFiles())) {
                jpaFile.getResourceModel().resolveTypes();
            }
        }
    }

    protected boolean synchronizeJpaFiles(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                return this.addJpaFile(file);
            }
            case 2: {
                return this.removeJpaFile(file);
            }
        }
        return false;
    }

    protected CommandExecutor getThreadLocalModifySharedDocumentCommandExecutor() {
        CommandExecutor ce = this.threadLocalModifySharedDocumentCommandExecutor.get();
        return ce != null ? ce : CommandExecutor.Default.instance();
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(CommandExecutor commandExecutor) {
        this.threadLocalModifySharedDocumentCommandExecutor.set(commandExecutor);
    }

    @Override
    public CommandExecutorProvider getModifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    @Override
    public JpaProject.Updater getUpdater() {
        return this.updater;
    }

    @Override
    public void setUpdater(JpaProject.Updater updater) {
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.updater = updater;
        this.updater.start();
    }

    @Override
    public void update() {
        if (this.updater == null) {
            throw new IllegalStateException("updater is null, use setUpdater(Updater) after construction of GenericJpaProject");
        }
        this.updater.update();
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        try {
            this.getRootContext().update(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable ex) {
            JptCorePlugin.log(ex);
        }
        return Status.OK_STATUS;
    }

    protected class DefaultResourceModelListener
    implements ResourceModelListener {
        protected DefaultResourceModelListener() {
        }

        public void resourceModelChanged() {
            GenericJpaProject.this.update();
        }
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resource) throws CoreException {
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    GenericJpaProject.this.addJpaFileInternal((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected class ModifySharedDocumentCommandExecutorProvider
    implements CommandExecutorProvider {
        protected ModifySharedDocumentCommandExecutorProvider() {
        }

        public CommandExecutor getCommandExecutor() {
            return GenericJpaProject.this.getThreadLocalModifySharedDocumentCommandExecutor();
        }
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean jpaFilesChanged = false;

        protected ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    if (GenericJpaProject.this.synchronizeJpaFiles((IFile)res, delta.getKind())) {
                        this.jpaFilesChanged = true;
                    }
                    return false;
                }
            }
            return false;
        }

        protected boolean jpaFilesChanged() {
            return this.jpaFilesChanged;
        }
    }
}

