/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinTable
extends AbstractJavaTable
implements JavaJoinTable {
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();
    protected JavaJoinColumn defaultJoinColumn;
    protected final List<JavaJoinColumn> specifiedInverseJoinColumns = new ArrayList<JavaJoinColumn>();
    protected JavaJoinColumn defaultInverseJoinColumn;
    protected JavaResourcePersistentAttribute attributeResource;

    public GenericJavaJoinTable(JavaRelationshipMapping parent) {
        super(parent);
    }

    @Override
    public JavaRelationshipMapping getParent() {
        return (JavaRelationshipMapping)super.getParent();
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    protected String defaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationshipMapping());
    }

    @Override
    protected String defaultCatalog() {
        if (!this.getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return super.defaultCatalog();
    }

    @Override
    protected String defaultSchema() {
        if (!this.getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return super.defaultSchema();
    }

    @Override
    protected JoinTableAnnotation getTableResource() {
        return (JoinTableAnnotation)this.attributeResource.getNonNullAnnotation("javax.persistence.JoinTable");
    }

    protected JoinTableAnnotation getJoinTableResource() {
        return (JoinTableAnnotation)this.attributeResource.getAnnotation("javax.persistence.JoinTable");
    }

    protected void addJoinTableResource() {
        this.attributeResource.addAnnotation("javax.persistence.JoinTable");
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.containsSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn newJoinColumn) {
        JavaJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefaultJoinColumn = this.getDefaultJoinColumn();
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        if (this.getJoinTableResource() == null) {
            this.addJoinTableResource();
        }
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnResource = this.getTableResource().addJoinColumn(index);
        joinColumn.initializeFromResource(joinColumnResource);
        this.fireItemAdded("specifiedJoinColumnsList", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(this.getTableResource()));
        }
        this.getTableResource().removeJoinColumn(index);
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().moveJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaJoinColumn> inverseJoinColumns() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumns() : this.defaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.containsSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaJoinColumn newInverseJoinColumn) {
        JavaJoinColumn oldInverseJoinColumn = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = newInverseJoinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", oldInverseJoinColumn, newInverseJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultInverseJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedInverseJoinColumns() {
        return new CloneListIterator(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.specifiedInverseJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn oldDefaultInverseJoinColumn = this.getDefaultInverseJoinColumn();
        if (oldDefaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn = null;
        }
        if (this.getJoinTableResource() == null) {
            this.addJoinTableResource();
        }
        JavaJoinColumn inverseJoinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createInverseJoinColumnOwner());
        this.specifiedInverseJoinColumns.add(index, inverseJoinColumn);
        JoinColumnAnnotation joinColumnResource = this.getTableResource().addInverseJoinColumn(index);
        inverseJoinColumn.initializeFromResource(joinColumnResource);
        this.fireItemAdded("specifiedInverseJoinColumnsList", index, inverseJoinColumn);
        if (oldDefaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", oldDefaultInverseJoinColumn, null);
        }
        return inverseJoinColumn;
    }

    protected void addSpecifiedInverseJoinColumn(int index, JavaJoinColumn inverseJoinColumn) {
        this.addItemToList(index, inverseJoinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn inverseJoinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(inverseJoinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedInverseJoinColumns.remove(index);
        if (!this.containsSpecifiedInverseJoinColumns()) {
            this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumn(this.getTableResource()));
        }
        this.getTableResource().removeInverseJoinColumn(index);
        this.fireItemRemoved("specifiedInverseJoinColumnsList", index, removedJoinColumn);
        if (this.defaultInverseJoinColumn != null) {
            this.firePropertyChanged("defaultInverseJoinColumn", null, this.defaultInverseJoinColumn);
        }
    }

    protected void removeSpecifiedInverseJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumnsList");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedInverseJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getTableResource().moveInverseJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedInverseJoinColumnsList", targetIndex, sourceIndex);
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getParent();
    }

    @Override
    public boolean isSpecified() {
        return this.getJoinTableResource() != null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.inverseJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected JavaJoinColumn.Owner createInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute attributeResource) {
        this.attributeResource = attributeResource;
        JoinTableAnnotation joinTable = this.getTableResource();
        this.initializeFromResource(joinTable);
        this.initializeSpecifiedJoinColumns(joinTable);
        this.initializeDefaultJoinColumn(joinTable);
        this.initializeSpecifiedInverseJoinColumns(joinTable);
        this.initializeDefaultInverseJoinColumn(joinTable);
    }

    protected void initializeSpecifiedJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JoinColumnAnnotation> annotations = joinTableResource.joinColumns();
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns() && this.getRelationshipMapping().isRelationshipOwner();
    }

    protected void initializeDefaultJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumn(joinTable));
    }

    protected void initializeSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JoinColumnAnnotation> annotations = joinTableResource.inverseJoinColumns();
        while (annotations.hasNext()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultInverseJoinColumn() {
        return !this.containsSpecifiedInverseJoinColumns() && this.getRelationshipMapping().isRelationshipOwner();
    }

    protected void initializeDefaultInverseJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            return;
        }
        this.defaultInverseJoinColumn = this.buildInverseJoinColumn(new NullJoinColumn(joinTable));
    }

    @Override
    public void update(JavaResourcePersistentAttribute attributeResource) {
        this.attributeResource = attributeResource;
        JoinTableAnnotation joinTable = this.getTableResource();
        this.update(joinTable);
        this.updateSpecifiedJoinColumns(joinTable);
        this.updateDefaultJoinColumn(joinTable);
        this.updateSpecifiedInverseJoinColumns(joinTable);
        this.updateDefaultInverseJoinColumn(joinTable);
    }

    protected void updateSpecifiedJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<JoinColumnAnnotation> resourceJoinColumns = joinTableResource.joinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize(), this.buildJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumn(joinTable)));
        } else {
            this.defaultJoinColumn.update(new NullJoinColumn(joinTable));
        }
    }

    protected void updateSpecifiedInverseJoinColumns(JoinTableAnnotation joinTableResource) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedInverseJoinColumns();
        ListIterator<JoinColumnAnnotation> resourceJoinColumns = joinTableResource.inverseJoinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedInverseJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumnsSize(), this.buildInverseJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultInverseJoinColumn(JoinTableAnnotation joinTable) {
        if (!this.shouldBuildDefaultInverseJoinColumn()) {
            this.setDefaultInverseJoinColumn(null);
            return;
        }
        if (this.getDefaultInverseJoinColumn() == null) {
            this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(new NullJoinColumn(joinTable)));
        } else {
            this.defaultInverseJoinColumn.update(new NullJoinColumn(joinTable));
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initializeFromResource(joinColumnResource);
        return joinColumn;
    }

    protected JavaJoinColumn buildInverseJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createInverseJoinColumnOwner());
        joinColumn.initializeFromResource(joinColumnResource);
        return joinColumn;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        JavaJoinColumn joinColumn;
        super.addToMessages(messages, astRoot);
        boolean doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        if (doContinue && !this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
            doContinue = false;
        }
        ListIterator<JavaJoinColumn> stream = this.joinColumns();
        while (stream.hasNext()) {
            joinColumn = (JavaJoinColumn)stream.next();
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
        }
        stream = this.inverseJoinColumns();
        while (stream.hasNext()) {
            joinColumn = (JavaJoinColumn)stream.next();
            if (doContinue && !joinColumn.isResolved()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
        }
    }

    abstract class AbstractJoinColumnOwner
    implements JavaJoinColumn.Owner {
        AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericJavaJoinTable.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return false;
        }

        public boolean tableIsAllowed() {
            return false;
        }

        public Table getDbTable(String tableName) {
            if (GenericJavaJoinTable.this.getName() == null) {
                return null;
            }
            return GenericJavaJoinTable.this.getName().equals(tableName) ? GenericJavaJoinTable.this.getDbTable() : null;
        }

        public String getDefaultTableName() {
            return GenericJavaJoinTable.this.getName();
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinTable.this.getValidationTextRange(astRoot);
        }
    }

    class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getPersistentAttribute().getName();
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.inverseJoinColumnsSize();
        }
    }

    class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        public Entity getTargetEntity() {
            return GenericJavaJoinTable.this.getRelationshipMapping().getEntity();
        }

        public String getAttributeName() {
            Entity targetEntity = GenericJavaJoinTable.this.getRelationshipMapping().getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            String attributeName = GenericJavaJoinTable.this.getRelationshipMapping().getPersistentAttribute().getName();
            Iterator<PersistentAttribute> stream = targetEntity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                String mappedBy;
                PersistentAttribute attribute = stream.next();
                AttributeMapping mapping = attribute.getMapping();
                if (!(mapping instanceof NonOwningMapping) || (mappedBy = ((NonOwningMapping)mapping).getMappedBy()) == null || !mappedBy.equals(attributeName)) continue;
                return attribute.getName();
            }
            return null;
        }

        public Table getDbTable(String tableName) {
            Table dbTable = super.getDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.joinColumnsSize();
        }
    }
}

