/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.resource.java.NullPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaSecondaryTable
extends AbstractJavaTable
implements JavaSecondaryTable {
    protected final List<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected SecondaryTableAnnotation secondaryTableResource;

    public GenericJavaSecondaryTable(JavaEntity parent) {
        super(parent);
    }

    @Override
    public JavaEntity getParent() {
        return (JavaEntity)super.getParent();
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.SecondaryTable";
    }

    @Override
    protected SecondaryTableAnnotation getTableResource() {
        return this.secondaryTableResource;
    }

    @Override
    protected String defaultName() {
        return null;
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn newPkJoinColumn) {
        JavaPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    protected ListIterator<JavaPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = this.secondaryTableResource.addPkJoinColumn(index);
        primaryKeyJoinColumn.initializeFromResource(pkJoinColumnResource);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumnsList", index, primaryKeyJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return primaryKeyJoinColumn;
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn joinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(this.secondaryTableResource));
        }
        this.secondaryTableResource.removePkJoinColumn(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumnsList", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.secondaryTableResource.movePkJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    public JavaEntity getJavaEntity() {
        return this.getParent();
    }

    @Override
    public void initializeFromResource(SecondaryTableAnnotation secondaryTable) {
        super.initializeFromResource(secondaryTable);
        this.secondaryTableResource = secondaryTable;
        this.initializeSpecifiedPrimaryKeyJoinColumns(secondaryTable);
        this.initializeDefaultPrimaryKeyJoinColumn(secondaryTable);
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns(SecondaryTableAnnotation secondaryTable) {
        ListIterator<PrimaryKeyJoinColumnAnnotation> annotations = secondaryTable.pkJoinColumns();
        while (annotations.hasNext()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn(SecondaryTableAnnotation secondaryTable) {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(secondaryTable));
    }

    @Override
    public void update(SecondaryTableAnnotation secondaryTableResource) {
        this.secondaryTableResource = secondaryTableResource;
        super.update(secondaryTableResource);
        this.updateSpecifiedPrimaryKeyJoinColumns(secondaryTableResource);
        this.updateDefaultPrimaryKeyJoinColumn(secondaryTableResource);
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns(SecondaryTableAnnotation secondaryTableResource) {
        ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        ListIterator<PrimaryKeyJoinColumnAnnotation> resourcePrimaryKeyJoinColumns = secondaryTableResource.pkJoinColumns();
        while (primaryKeyJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update(resourcePrimaryKeyJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize(), this.buildPrimaryKeyJoinColumn(resourcePrimaryKeyJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumn(SecondaryTableAnnotation secondaryTableResource) {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(secondaryTableResource)));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(new NullPrimaryKeyJoinColumn(secondaryTableResource));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        primaryKeyJoinColumn.initializeFromResource(primaryKeyJoinColumnResource);
        return primaryKeyJoinColumn;
    }

    protected JavaBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        boolean doContinue = this.connectionProfileIsActive();
        String schema = this.getSchema();
        if (doContinue && !this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_SCHEMA", new String[]{schema, this.getName()}, this, this.getSchemaTextRange(astRoot)));
            doContinue = false;
        }
        if (doContinue && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaPrimaryKeyJoinColumn column : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    class PrimaryKeyJoinColumnOwner
    implements JavaBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaSecondaryTable.this.getValidationTextRange(astRoot);
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaSecondaryTable.this.getJavaEntity();
        }

        public Table getDbTable(String tableName) {
            return GenericJavaSecondaryTable.this.getDbTable();
        }

        public Table getDbReferencedColumnTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericJavaSecondaryTable.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaSecondaryTable.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericJavaSecondaryTable.this.getJavaEntity().getPrimaryKeyColumnName();
        }
    }
}

