/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistence
extends AbstractPersistenceJpaContextNode
implements Persistence {
    protected XmlPersistence xmlPersistence;
    protected PersistenceUnit persistenceUnit;

    public GenericPersistence(PersistenceXml parent, XmlPersistence xmlPersistence) {
        super(parent);
        this.initialize(xmlPersistence);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.persistence";
    }

    @Override
    public ListIterator<PersistenceUnit> persistenceUnits() {
        if (this.persistenceUnit == null) {
            return EmptyListIterator.instance();
        }
        return new SingleElementListIterator((Object)this.persistenceUnit);
    }

    @Override
    public int persistenceUnitsSize() {
        return this.persistenceUnit == null ? 0 : 1;
    }

    @Override
    public PersistenceUnit addPersistenceUnit() {
        return this.addPersistenceUnit(this.persistenceUnitsSize());
    }

    @Override
    public PersistenceUnit addPersistenceUnit(int index) {
        if (index > 0 || this.persistenceUnit != null) {
            throw new IllegalStateException("This implementation does not support multiple persistence units.");
        }
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        this.persistenceUnit = this.createPersistenceUnit(xmlPersistenceUnit);
        this.xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        this.fireItemAdded("persistenceUnits", index, this.persistenceUnit);
        return this.persistenceUnit;
    }

    @Override
    public void removePersistenceUnit(PersistenceUnit persistenceUnit) {
        this.removePersistenceUnit(0);
    }

    @Override
    public void removePersistenceUnit(int index) {
        if (index > 0) {
            throw new IllegalArgumentException(new Integer(index).toString());
        }
        PersistenceUnit oldPersistenceUnit = this.persistenceUnit;
        this.persistenceUnit.dispose();
        this.persistenceUnit = null;
        this.xmlPersistence.getPersistenceUnits().remove(index);
        this.fireItemRemoved("persistenceUnits", index, oldPersistenceUnit);
    }

    protected void addPersistenceUnit_(PersistenceUnit newPersistenceUnit) {
        this.persistenceUnit = newPersistenceUnit;
        this.fireItemAdded("persistenceUnits", 0, this.persistenceUnit);
    }

    protected void removePersistenceUnit_(PersistenceUnit oldPersistenceUnit) {
        this.persistenceUnit.dispose();
        this.persistenceUnit = null;
        this.fireItemRemoved("persistenceUnits", 0, oldPersistenceUnit);
    }

    protected void initialize(XmlPersistence xmlPersistence) {
        this.xmlPersistence = xmlPersistence;
        this.initializePersistenceUnits(xmlPersistence);
    }

    protected void initializePersistenceUnits(XmlPersistence persistence) {
        if (this.xmlPersistence.getPersistenceUnits().size() > 0) {
            this.persistenceUnit = this.createPersistenceUnit((XmlPersistenceUnit)persistence.getPersistenceUnits().get(0));
        }
    }

    @Override
    public void update(XmlPersistence persistence) {
        this.xmlPersistence = persistence;
        this.getJpaFile(this.xmlPersistence.getResource().getResourceModel()).addRootStructureNode(this, this);
        XmlPersistenceUnit xmlPersistenceUnit = null;
        if (persistence.getPersistenceUnits().size() > 0) {
            xmlPersistenceUnit = (XmlPersistenceUnit)persistence.getPersistenceUnits().get(0);
        }
        if (this.persistenceUnit != null) {
            if (xmlPersistenceUnit != null) {
                this.persistenceUnit.update(xmlPersistenceUnit);
            } else {
                this.removePersistenceUnit_(this.persistenceUnit);
            }
        } else if (xmlPersistenceUnit != null) {
            this.addPersistenceUnit_(this.createPersistenceUnit(xmlPersistenceUnit));
        }
    }

    protected PersistenceUnit createPersistenceUnit(XmlPersistenceUnit xmlPersistenceUnit) {
        return this.getJpaFactory().buildPersistenceUnit(this, xmlPersistenceUnit);
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        throw new UnsupportedOperationException("No PersistenceUnit in this context");
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (PersistenceUnit persistenceUnit : CollectionTools.iterable(this.persistenceUnits())) {
            if (!persistenceUnit.containsOffset(textOffset)) continue;
            return persistenceUnit.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlPersistence == null) {
            return false;
        }
        return this.xmlPersistence.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistence.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.xmlPersistence.getValidationTextRange();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addNoPersistenceUnitMessage(messages);
        this.addMultiplePersistenceUnitMessage(messages);
        if (this.persistenceUnit != null) {
            this.persistenceUnit.addToMessages(messages);
        }
    }

    protected void addNoPersistenceUnitMessage(List<IMessage> messages) {
        if (this.persistenceUnit == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_NO_PERSISTENCE_UNIT", this, this.getValidationTextRange()));
        }
    }

    protected void addMultiplePersistenceUnitMessage(List<IMessage> messages) {
        if (this.xmlPersistence.getPersistenceUnits().size() > 1) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", this, this.getValidationTextRange()));
        }
    }

    @Override
    public void dispose() {
        this.getJpaFile(this.xmlPersistence.getResource().getResourceModel()).removeRootStructureNode(this);
        for (PersistenceUnit persistenceUnit : CollectionTools.iterable(this.persistenceUnits())) {
            persistenceUnit.dispose();
        }
    }
}

