/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.internal.resource.java.AssociationOverrideImpl;
import org.eclipse.jpt.core.internal.resource.java.AssociationOverridesImpl;
import org.eclipse.jpt.core.internal.resource.java.AttributeOverrideImpl;
import org.eclipse.jpt.core.internal.resource.java.AttributeOverridesImpl;
import org.eclipse.jpt.core.internal.resource.java.BasicImpl;
import org.eclipse.jpt.core.internal.resource.java.ColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.DiscriminatorColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.DiscriminatorValueImpl;
import org.eclipse.jpt.core.internal.resource.java.EmbeddableImpl;
import org.eclipse.jpt.core.internal.resource.java.EmbeddedIdImpl;
import org.eclipse.jpt.core.internal.resource.java.EmbeddedImpl;
import org.eclipse.jpt.core.internal.resource.java.EntityImpl;
import org.eclipse.jpt.core.internal.resource.java.EnumeratedImpl;
import org.eclipse.jpt.core.internal.resource.java.GeneratedValueImpl;
import org.eclipse.jpt.core.internal.resource.java.IdClassImpl;
import org.eclipse.jpt.core.internal.resource.java.IdImpl;
import org.eclipse.jpt.core.internal.resource.java.InheritanceImpl;
import org.eclipse.jpt.core.internal.resource.java.JoinColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.JoinColumnsImpl;
import org.eclipse.jpt.core.internal.resource.java.JoinTableImpl;
import org.eclipse.jpt.core.internal.resource.java.LobImpl;
import org.eclipse.jpt.core.internal.resource.java.ManyToManyImpl;
import org.eclipse.jpt.core.internal.resource.java.ManyToOneImpl;
import org.eclipse.jpt.core.internal.resource.java.MapKeyImpl;
import org.eclipse.jpt.core.internal.resource.java.MappedSuperclassImpl;
import org.eclipse.jpt.core.internal.resource.java.NamedNativeQueriesImpl;
import org.eclipse.jpt.core.internal.resource.java.NamedNativeQueryImpl;
import org.eclipse.jpt.core.internal.resource.java.NamedQueriesImpl;
import org.eclipse.jpt.core.internal.resource.java.NamedQueryImpl;
import org.eclipse.jpt.core.internal.resource.java.OneToManyImpl;
import org.eclipse.jpt.core.internal.resource.java.OneToOneImpl;
import org.eclipse.jpt.core.internal.resource.java.OrderByImpl;
import org.eclipse.jpt.core.internal.resource.java.PrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.internal.resource.java.PrimaryKeyJoinColumnsImpl;
import org.eclipse.jpt.core.internal.resource.java.SecondaryTableImpl;
import org.eclipse.jpt.core.internal.resource.java.SecondaryTablesImpl;
import org.eclipse.jpt.core.internal.resource.java.SequenceGeneratorImpl;
import org.eclipse.jpt.core.internal.resource.java.TableGeneratorImpl;
import org.eclipse.jpt.core.internal.resource.java.TableImpl;
import org.eclipse.jpt.core.internal.resource.java.TemporalImpl;
import org.eclipse.jpt.core.internal.resource.java.TransientImpl;
import org.eclipse.jpt.core.internal.resource.java.VersionImpl;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaAnnotationProvider
implements JpaAnnotationProvider {
    private List<AnnotationDefinition> typeMappingAnnotationDefinitions;
    private Collection<AnnotationDefinition> typeAnnotationDefinitions;
    private List<AnnotationDefinition> attributeMappingAnnotationDefinitions;
    private Collection<AnnotationDefinition> attributeAnnotationDefinitions;

    protected GenericJpaAnnotationProvider() {
    }

    protected ListIterator<AnnotationDefinition> typeMappingAnnotationDefinitions() {
        if (this.typeMappingAnnotationDefinitions == null) {
            this.typeMappingAnnotationDefinitions = new ArrayList<AnnotationDefinition>();
            this.addTypeMappingAnnotationDefinitionsTo(this.typeMappingAnnotationDefinitions);
        }
        return new CloneListIterator(this.typeMappingAnnotationDefinitions);
    }

    protected void addTypeMappingAnnotationDefinitionsTo(List<AnnotationDefinition> definitions) {
        definitions.add(EmbeddableImpl.EmbeddableAnnotationDefinition.instance());
        definitions.add(EntityImpl.EntityAnnotationDefinition.instance());
        definitions.add(MappedSuperclassImpl.MappedSuperclassAnnotationDefinition.instance());
    }

    protected Iterator<AnnotationDefinition> typeAnnotationDefinitions() {
        if (this.typeAnnotationDefinitions == null) {
            this.typeAnnotationDefinitions = new ArrayList<AnnotationDefinition>();
            this.addTypeAnnotationDefinitionsTo(this.typeAnnotationDefinitions);
        }
        return new CloneIterator(this.typeAnnotationDefinitions);
    }

    protected void addTypeAnnotationDefinitionsTo(Collection<AnnotationDefinition> definitions) {
        definitions.add(AssociationOverrideImpl.AssociationOverrideAnnotationDefinition.instance());
        definitions.add(AssociationOverridesImpl.AssociationOverridesAnnotationDefinition.instance());
        definitions.add(AttributeOverrideImpl.AttributeOverrideAnnotationDefinition.instance());
        definitions.add(AttributeOverrideImpl.AttributeOverrideAnnotationDefinition.instance());
        definitions.add(AttributeOverridesImpl.AttributeOverridesAnnotationDefinition.instance());
        definitions.add(DiscriminatorColumnImpl.DiscriminatorColumnAnnotationDefinition.instance());
        definitions.add(DiscriminatorValueImpl.DiscriminatorValueAnnotationDefinition.instance());
        definitions.add(IdClassImpl.IdClassAnnotationDefinition.instance());
        definitions.add(InheritanceImpl.InheritanceAnnotationDefinition.instance());
        definitions.add(NamedQueryImpl.NamedQueryAnnotationDefinition.instance());
        definitions.add(NamedQueriesImpl.NamedQueriesAnnotationDefinition.instance());
        definitions.add(NamedNativeQueryImpl.NamedNativeQueryAnnotationDefinition.instance());
        definitions.add(NamedNativeQueriesImpl.NamedNativeQueriesAnnotationDefinition.instance());
        definitions.add(PrimaryKeyJoinColumnImpl.PrimaryKeyJoinColumnAnnotationDefinition.instance());
        definitions.add(PrimaryKeyJoinColumnsImpl.PrimaryKeyJoinColumnsAnnotationDefinition.instance());
        definitions.add(SecondaryTableImpl.SecondaryTableAnnotationDefinition.instance());
        definitions.add(SecondaryTablesImpl.SecondaryTablesAnnotationDefinition.instance());
        definitions.add(SequenceGeneratorImpl.SequenceGeneratorAnnotationDefinition.instance());
        definitions.add(TableImpl.TableAnnotationDefinition.instance());
        definitions.add(TableGeneratorImpl.TableGeneratorAnnotationDefinition.instance());
    }

    protected ListIterator<AnnotationDefinition> attributeMappingAnnotationDefinitions() {
        if (this.attributeMappingAnnotationDefinitions == null) {
            this.attributeMappingAnnotationDefinitions = new ArrayList<AnnotationDefinition>();
            this.addAttributeMappingAnnotationDefinitionsTo(this.attributeMappingAnnotationDefinitions);
        }
        return new CloneListIterator(this.attributeMappingAnnotationDefinitions);
    }

    protected void addAttributeMappingAnnotationDefinitionsTo(List<AnnotationDefinition> definitions) {
        definitions.add(BasicImpl.BasicAnnotationDefinition.instance());
        definitions.add(EmbeddedImpl.EmbeddedAnnotationDefinition.instance());
        definitions.add(EmbeddedIdImpl.EmbeddedIdAnnotationDefinition.instance());
        definitions.add(IdImpl.IdAnnotationDefinition.instance());
        definitions.add(ManyToManyImpl.ManyToManyAnnotationDefinition.instance());
        definitions.add(ManyToOneImpl.ManyToOneAnnotationDefinition.instance());
        definitions.add(OneToManyImpl.OneToManyAnnotationDefinition.instance());
        definitions.add(OneToOneImpl.OneToOneAnnotationDefinition.instance());
        definitions.add(TransientImpl.TransientAnnotationDefinition.instance());
        definitions.add(VersionImpl.VersionAnnotationDefinition.instance());
    }

    protected Iterator<AnnotationDefinition> attributeAnnotationDefinitions() {
        if (this.attributeAnnotationDefinitions == null) {
            this.attributeAnnotationDefinitions = new ArrayList<AnnotationDefinition>();
            this.addAttributeAnnotationDefinitionsTo(this.attributeAnnotationDefinitions);
        }
        return new CloneIterator(this.attributeAnnotationDefinitions);
    }

    protected void addAttributeAnnotationDefinitionsTo(Collection<AnnotationDefinition> definitions) {
        definitions.add(AssociationOverrideImpl.AssociationOverrideAnnotationDefinition.instance());
        definitions.add(AssociationOverridesImpl.AssociationOverridesAnnotationDefinition.instance());
        definitions.add(AttributeOverrideImpl.AttributeOverrideAnnotationDefinition.instance());
        definitions.add(AttributeOverridesImpl.AttributeOverridesAnnotationDefinition.instance());
        definitions.add(ColumnImpl.ColumnAnnotationDefinition.instance());
        definitions.add(EnumeratedImpl.EnumeratedAnnotationDefinition.instance());
        definitions.add(GeneratedValueImpl.GeneratedValueAnnotationDefinition.instance());
        definitions.add(JoinColumnImpl.JoinColumnAnnotationDefinition.instance());
        definitions.add(JoinColumnsImpl.JoinColumnsAnnotationDefinition.instance());
        definitions.add(JoinTableImpl.JoinTableAnnotationDefinition.instance());
        definitions.add(LobImpl.LobAnnotationDefinition.instance());
        definitions.add(MapKeyImpl.MapKeyAnnotationDefinition.instance());
        definitions.add(OrderByImpl.OrderByAnnotationDefinition.instance());
        definitions.add(PrimaryKeyJoinColumnImpl.PrimaryKeyJoinColumnAnnotationDefinition.instance());
        definitions.add(PrimaryKeyJoinColumnsImpl.PrimaryKeyJoinColumnsAnnotationDefinition.instance());
        definitions.add(SequenceGeneratorImpl.SequenceGeneratorAnnotationDefinition.instance());
        definitions.add(TableGeneratorImpl.TableGeneratorAnnotationDefinition.instance());
        definitions.add(TemporalImpl.TemporalAnnotationDefinition.instance());
    }

    @Override
    public Annotation buildTypeMappingAnnotation(JavaResourcePersistentType parent, Type type, String mappingAnnotationName) {
        AnnotationDefinition annotationDefinition = this.typeMappingAnnotationDefinition(mappingAnnotationName);
        return annotationDefinition.buildAnnotation(parent, type);
    }

    @Override
    public Annotation buildNullTypeMappingAnnotation(JavaResourcePersistentType parent, Type type, String mappingAnnotationName) {
        AnnotationDefinition annotationDefinition = this.typeMappingAnnotationDefinition(mappingAnnotationName);
        return annotationDefinition.buildNullAnnotation(parent, type);
    }

    @Override
    public Annotation buildTypeAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        AnnotationDefinition annotationDefinition = this.typeAnnotationDefinition(annotationName);
        return annotationDefinition.buildAnnotation(parent, type);
    }

    @Override
    public Annotation buildNullTypeAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        AnnotationDefinition annotationDefinition = this.typeAnnotationDefinition(annotationName);
        return annotationDefinition.buildNullAnnotation(parent, type);
    }

    @Override
    public ListIterator<String> typeMappingAnnotationNames() {
        return new TransformationListIterator<AnnotationDefinition, String>(this.typeMappingAnnotationDefinitions()){

            protected String transform(AnnotationDefinition next) {
                return next.getAnnotationName();
            }
        };
    }

    @Override
    public Iterator<String> typeAnnotationNames() {
        return new TransformationIterator<AnnotationDefinition, String>(this.typeAnnotationDefinitions()){

            protected String transform(AnnotationDefinition next) {
                return next.getAnnotationName();
            }
        };
    }

    @Override
    public Annotation buildAttributeMappingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String mappingAnnotationName) {
        AnnotationDefinition annotationDefinition = this.attributeMappingAnnotationDefinition(mappingAnnotationName);
        return annotationDefinition.buildAnnotation(parent, attribute);
    }

    @Override
    public Annotation buildNullAttributeMappingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        AnnotationDefinition annotationDefinition = this.attributeMappingAnnotationDefinition(annotationName);
        return annotationDefinition.buildNullAnnotation(parent, attribute);
    }

    @Override
    public Annotation buildAttributeAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        AnnotationDefinition annotationDefinition = this.attributeAnnotationDefinition(annotationName);
        return annotationDefinition.buildAnnotation(parent, attribute);
    }

    @Override
    public Annotation buildNullAttributeAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        AnnotationDefinition annotationDefinition = this.attributeAnnotationDefinition(annotationName);
        return annotationDefinition.buildNullAnnotation(parent, attribute);
    }

    @Override
    public ListIterator<String> attributeMappingAnnotationNames() {
        return new TransformationListIterator<AnnotationDefinition, String>(this.attributeMappingAnnotationDefinitions()){

            protected String transform(AnnotationDefinition next) {
                return next.getAnnotationName();
            }
        };
    }

    @Override
    public Iterator<String> attributeAnnotationNames() {
        return new TransformationIterator<AnnotationDefinition, String>(this.attributeAnnotationDefinitions()){

            protected String transform(AnnotationDefinition next) {
                return next.getAnnotationName();
            }
        };
    }

    private AnnotationDefinition typeMappingAnnotationDefinition(String mappingAnnotationName) {
        ListIterator<AnnotationDefinition> i = this.typeMappingAnnotationDefinitions();
        while (i.hasNext()) {
            AnnotationDefinition definition = i.next();
            if (!definition.getAnnotationName().equals(mappingAnnotationName)) continue;
            return definition;
        }
        throw new IllegalArgumentException(String.valueOf(mappingAnnotationName) + " is an unsupported type mapping annotation");
    }

    private AnnotationDefinition typeAnnotationDefinition(String annotationName) {
        Iterator<AnnotationDefinition> i = this.typeAnnotationDefinitions();
        while (i.hasNext()) {
            AnnotationDefinition definition = i.next();
            if (!definition.getAnnotationName().equals(annotationName)) continue;
            return definition;
        }
        throw new IllegalArgumentException(String.valueOf(annotationName) + " is an unsupported type annotation");
    }

    private AnnotationDefinition attributeMappingAnnotationDefinition(String mappingAnnotationName) {
        ListIterator<AnnotationDefinition> i = this.attributeMappingAnnotationDefinitions();
        while (i.hasNext()) {
            AnnotationDefinition definition = i.next();
            if (!definition.getAnnotationName().equals(mappingAnnotationName)) continue;
            return definition;
        }
        throw new IllegalArgumentException(String.valueOf(mappingAnnotationName) + " is an unsupported attribute mapping annotation");
    }

    private AnnotationDefinition attributeAnnotationDefinition(String annotationName) {
        Iterator<AnnotationDefinition> i = this.attributeAnnotationDefinitions();
        while (i.hasNext()) {
            AnnotationDefinition definition = i.next();
            if (!definition.getAnnotationName().equals(annotationName)) continue;
            return definition;
        }
        throw new IllegalArgumentException(String.valueOf(annotationName) + " is an unsupported attribute annotation");
    }
}

