/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceAnnotation<E extends Member>
extends AbstractJavaResourceNode
implements Annotation {
    private final E member;
    private final DeclarationAnnotationAdapter daa;
    private final AnnotationAdapter annotationAdapter;

    protected AbstractResourceAnnotation(JavaResourceNode parent, E member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.member = member;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    public E getMember() {
        return this.member;
    }

    protected AbstractResourceAnnotation(JavaResourceNode parent, E member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, new MemberAnnotationAdapter((Member)member, daa));
    }

    public AnnotationAdapter getAnnotationAdapter() {
        return this.annotationAdapter;
    }

    @Override
    public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
        return this.getAnnotationAdapter().getAnnotation(astRoot);
    }

    public DeclarationAnnotationAdapter getDeclarationAnnotationAdapter() {
        return this.daa;
    }

    @Override
    public void removeAnnotation() {
        this.getAnnotationAdapter().removeAnnotation();
    }

    @Override
    public void newAnnotation() {
        this.getAnnotationAdapter().newMarkerAnnotation();
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getAnnotationTextRange(astRoot);
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getAnnotation(astRoot));
    }

    protected org.eclipse.jdt.core.dom.Annotation getAnnotation(CompilationUnit astRoot) {
        return this.daa.getAnnotation(this.getMember().getModifiedDeclaration(astRoot));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.getMember().getModifiedDeclaration(astRoot));
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astRoot));
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean elementTouches(TextRange elementTextRange, int pos) {
        return elementTextRange != null && elementTextRange.touches(pos);
    }
}

