/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.AttributeOverrideImpl;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.AttributeOverridesAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAttributeOverride;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeOverridesImpl
extends AbstractResourceAnnotation<Member>
implements AttributeOverridesAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverrides");
    private final List<NestableAttributeOverride> attributesOverrides = new ArrayList<NestableAttributeOverride>();

    protected AttributeOverridesImpl(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AttributeOverrides";
    }

    @Override
    public String getNestableAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    @Override
    public ListIterator<NestableAttributeOverride> nestedAnnotations() {
        return new CloneListIterator(this.attributesOverrides);
    }

    @Override
    public int nestedAnnotationsSize() {
        return this.attributesOverrides.size();
    }

    @Override
    public NestableAttributeOverride addInternal(int index) {
        AttributeOverrideImpl attributeOverride = this.createAttributeOverride(index);
        this.attributesOverrides.add(index, attributeOverride);
        return attributeOverride;
    }

    @Override
    public NestableAttributeOverride add(int index) {
        AttributeOverrideImpl attributeOverride = this.createAttributeOverride(index);
        this.add(index, attributeOverride);
        return attributeOverride;
    }

    private void add(int index, NestableAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.attributesOverrides, "attributeOverridesList");
    }

    @Override
    public void remove(NestableAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.attributesOverrides, "attributeOverridesList");
    }

    @Override
    public void remove(int index) {
        this.removeItemFromList(index, this.attributesOverrides, "attributeOverridesList");
    }

    @Override
    public int indexOf(NestableAttributeOverride attributeOverride) {
        return this.attributesOverrides.indexOf(attributeOverride);
    }

    @Override
    public NestableAttributeOverride nestedAnnotationAt(int index) {
        return this.attributesOverrides.get(index);
    }

    @Override
    public NestableAttributeOverride nestedAnnotationFor(Annotation jdtAnnotation) {
        for (NestableAttributeOverride attributeOverride : this.attributesOverrides) {
            if (jdtAnnotation != attributeOverride.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
            return attributeOverride;
        }
        return null;
    }

    @Override
    public void move(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.attributesOverrides, "attributeOverridesList");
    }

    @Override
    public void moveInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.attributesOverrides, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public String getElementName() {
        return "value";
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this);
    }

    private AttributeOverrideImpl createAttributeOverride(int index) {
        return AttributeOverrideImpl.createNestedAttributeOverride(this, this.getMember(), index, this.getDeclarationAnnotationAdapter());
    }

    public static class AttributeOverridesAnnotationDefinition
    implements AnnotationDefinition {
        private static final AttributeOverridesAnnotationDefinition INSTANCE = new AttributeOverridesAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private AttributeOverridesAnnotationDefinition() {
        }

        public AttributeOverridesAnnotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new AttributeOverridesImpl(parent, member);
        }

        public AttributeOverridesAnnotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "javax.persistence.AttributeOverrides";
        }
    }
}

