/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.NullDiscriminatorValue;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscriminatorValueImpl
extends AbstractResourceAnnotation<Type>
implements DiscriminatorValueAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.DiscriminatorValue");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = DiscriminatorValueImpl.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    protected DiscriminatorValueImpl(JavaResourceNode parent, Type type) {
        super(parent, type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(type, VALUE_ADAPTER);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.value(astRoot);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.DiscriminatorValue";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setValue(this.value(astRoot));
    }

    protected String value(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "value");
    }

    public static class DiscriminatorValueAnnotationDefinition
    implements AnnotationDefinition {
        private static final DiscriminatorValueAnnotationDefinition INSTANCE = new DiscriminatorValueAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private DiscriminatorValueAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new DiscriminatorValueImpl(parent, (Type)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new NullDiscriminatorValue(parent);
        }

        public String getAnnotationName() {
            return "javax.persistence.DiscriminatorValue";
        }
    }
}

