/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHint;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHintImpl
extends AbstractResourceAnnotation<Type>
implements NestableQueryHint {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String name;
    private String value;

    public QueryHintImpl(JavaResourceNode parent, Type type, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, type, idaa, new MemberIndexedAnnotationAdapter((Member)type, idaa));
        this.nameDeclarationAdapter = this.nameAdapter(idaa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.valueDeclarationAdapter = this.valueAdapter(idaa);
        this.valueAdapter = this.buildAdapter(this.valueDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.value = this.value(astRoot);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "name");
    }

    protected DeclarationAnnotationElementAdapter<String> valueAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, "value");
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.QueryHint";
    }

    @Override
    public IndexedAnnotationAdapter getAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.attributeValueHasNotChanged(this.value, newValue)) {
            return;
        }
        String oldValue = this.value;
        this.value = newValue;
        this.valueAdapter.setValue(newValue);
        this.firePropertyChanged("valueProperty", oldValue, newValue);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setValue(this.value(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    protected String value(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        QueryHintAnnotation oldQueryHint = (QueryHintAnnotation)((Object)oldAnnotation);
        this.setName(oldQueryHint.getName());
        this.setValue(oldQueryHint.getValue());
    }

    static QueryHintImpl createNamedQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new QueryHintImpl(parent, type, QueryHintImpl.buildNamedQueryQueryHintAnnotationAdapter(namedQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }

    static QueryHintImpl createNamedNativeQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new QueryHintImpl(parent, type, QueryHintImpl.buildNamedNativeQueryQueryHintAnnotationAdapter(namedNativeQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedNativeQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }
}

