/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.java;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InheritanceType {
    SINGLE_TABLE,
    JOINED,
    TABLE_PER_CLASS;


    public static InheritanceType fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return null;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.SINGLE_TABLE")) {
            return SINGLE_TABLE;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.JOINED")) {
            return JOINED;
        }
        if (javaAnnotationValue.equals("javax.persistence.InheritanceType.TABLE_PER_CLASS")) {
            return TABLE_PER_CLASS;
        }
        return null;
    }

    public static String toJavaAnnotationValue(InheritanceType inheritanceType) {
        if (inheritanceType == null) {
            return null;
        }
        switch (inheritanceType) {
            case SINGLE_TABLE: {
                return "javax.persistence.InheritanceType.SINGLE_TABLE";
            }
            case JOINED: {
                return "javax.persistence.InheritanceType.JOINED";
            }
            case TABLE_PER_CLASS: {
                return "javax.persistence.InheritanceType.TABLE_PER_CLASS";
            }
        }
        throw new IllegalArgumentException("unknown inheritance type: " + (Object)((Object)inheritanceType));
    }
}

