/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.options;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.options.TargetDatabase;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOptions
extends EclipseLinkPersistenceUnitProperties
implements Options {
    private String sessionName;
    private String sessionsXml;
    private Boolean includeDescriptorQueries;
    private TargetDatabase targetDatabase;
    private String eventListener;

    public EclipseLinkOptions(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.sessionName = this.getStringValue("eclipselink.session-name");
        this.sessionsXml = this.getStringValue("eclipselink.sessions-xml");
        this.includeDescriptorQueries = this.getBooleanValue("eclipselink.session.include.descriptor.queries");
        this.targetDatabase = (TargetDatabase)this.getEnumValue("eclipselink.target-database", TargetDatabase.values());
        this.eventListener = this.getStringValue("eclipselink.session-event-listener");
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.session-name", "sessionNameProperty");
        propertyNames.put("eclipselink.sessions-xml", "sessionsXmlProperty");
        propertyNames.put("eclipselink.session.include.descriptor.queries", "includeDescriptorQueriesProperty");
        propertyNames.put("eclipselink.target-database", "targetDatabaseProperty");
        propertyNames.put("eclipselink.session-event-listener", "eventListenerProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("sessionNameProperty")) {
            this.sessionNameChanged(event);
        } else if (aspectName.equals("sessionsXmlProperty")) {
            this.sessionsXmlChanged(event);
        } else if (aspectName.equals("targetDatabaseProperty")) {
            this.targetDatabaseChanged(event);
        } else if (aspectName.equals("includeDescriptorQueriesProperty")) {
            this.includeDescriptorQueriesChanged(event);
        } else if (aspectName.equals("eventListenerProperty")) {
            this.eventListenerChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String newSessionName) {
        String old = this.sessionName;
        this.sessionName = newSessionName;
        this.putProperty("sessionNameProperty", newSessionName);
        this.firePropertyChanged("sessionNameProperty", old, newSessionName);
    }

    private void sessionNameChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.sessionName;
        this.sessionName = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultSessionName() {
        return "";
    }

    @Override
    public String getSessionsXml() {
        return this.sessionsXml;
    }

    @Override
    public void setSessionsXml(String newSessionsXml) {
        String old = this.sessionsXml;
        this.sessionsXml = newSessionsXml;
        this.putProperty("sessionsXmlProperty", newSessionsXml);
        this.firePropertyChanged("sessionsXmlProperty", old, newSessionsXml);
    }

    private void sessionsXmlChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.sessionsXml;
        this.sessionsXml = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultSessionsXml() {
        return "";
    }

    @Override
    public Boolean getIncludeDescriptorQueries() {
        return this.includeDescriptorQueries;
    }

    @Override
    public void setIncludeDescriptorQueries(Boolean newIncludeDescriptorQueries) {
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newIncludeDescriptorQueries;
        this.putProperty("includeDescriptorQueriesProperty", newIncludeDescriptorQueries);
        this.firePropertyChanged("includeDescriptorQueriesProperty", old, newIncludeDescriptorQueries);
    }

    private void includeDescriptorQueriesChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkOptions.getBooleanValueOf(stringValue);
        Boolean old = this.includeDescriptorQueries;
        this.includeDescriptorQueries = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultIncludeDescriptorQueries() {
        return DEFAULT_SESSION_INCLUDE_DESCRIPTOR_QUERIES;
    }

    @Override
    public TargetDatabase getTargetDatabase() {
        return this.targetDatabase;
    }

    @Override
    public void setTargetDatabase(TargetDatabase newTargetDatabase) {
        TargetDatabase old = this.targetDatabase;
        this.targetDatabase = newTargetDatabase;
        this.putProperty("targetDatabaseProperty", (Object)newTargetDatabase);
        this.firePropertyChanged("targetDatabaseProperty", (Object)old, (Object)newTargetDatabase);
    }

    private void targetDatabaseChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        TargetDatabase newValue = (TargetDatabase)EclipseLinkOptions.getEnumValueOf((String)stringValue, (Enum[])TargetDatabase.values());
        TargetDatabase old = this.targetDatabase;
        this.targetDatabase = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public TargetDatabase getDefaultTargetDatabase() {
        return DEFAULT_TARGET_DATABASE;
    }

    @Override
    public String getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setEventListener(String newEventListener) {
        String old = this.eventListener;
        this.eventListener = newEventListener;
        this.putProperty("eventListenerProperty", newEventListener);
        this.firePropertyChanged("eventListenerProperty", old, newEventListener);
    }

    private void eventListenerChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.eventListener;
        this.eventListener = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultEventListener() {
        return DEFAULT_SESSION_EVENT_LISTENER;
    }
}

