/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.types.TypeInfo;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;

public class TypeInfoCache
implements IElementChangedListener {
    private static TypeInfoCache instance = null;
    private final Map<IType, TypeInfo> cachedInfo = new HashMap<IType, TypeInfo>();
    private final Map<ITypeRoot, Set<IType>> cachedTypesByAffectingTypeRoot = new HashMap<ITypeRoot, Set<IType>>();
    private final Map<String, Set<IType>> cachedTypesByMissingSupertypename = new HashMap<String, Set<IType>>(10);

    public static synchronized TypeInfoCache getInstance() {
        if (instance == null) {
            instance = TypeInfoCache.createNewInstance();
        }
        return instance;
    }

    public static TypeInfoCache createNewInstance() {
        TypeInfoCache newCache = new TypeInfoCache();
        JavaCore.addElementChangedListener((IElementChangedListener)newCache, (int)1);
        return newCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeInstance(TypeInfoCache cache) {
        if (cache != null && cache != instance) {
            JavaCore.removeElementChangedListener((IElementChangedListener)cache);
            TypeInfoCache typeInfoCache = cache;
            synchronized (typeInfoCache) {
                if (cache.cachedInfo != null) {
                    cache.cachedInfo.clear();
                }
                if (cache.cachedTypesByAffectingTypeRoot != null) {
                    cache.cachedTypesByAffectingTypeRoot.clear();
                }
                if (cache.cachedTypesByMissingSupertypename != null) {
                    cache.cachedTypesByMissingSupertypename.clear();
                }
            }
        }
    }

    private TypeInfoCache() {
    }

    public void elementChanged(ElementChangedEvent event) {
        this.updateChangedJavaElement(event.getDelta());
    }

    protected TypeInfo getTypeInfo(IType type) {
        TypeInfo info = null;
        if (type != null) {
            info = this.cachedInfo.get(type);
        }
        return info;
    }

    public synchronized IBeanPropertySymbol[] getCachedPropertySymbols(IType beanType) {
        TypeInfo typeInfo;
        IBeanPropertySymbol[] props = null;
        if (beanType != null && (typeInfo = this.getTypeInfo(beanType)) != null) {
            props = typeInfo.getPropertySymbols();
        }
        return props;
    }

    public synchronized IBeanMethodSymbol[] getCachedMethodSymbols(IType beanType) {
        TypeInfo typeInfo;
        IBeanMethodSymbol[] methods = null;
        if (beanType != null && (typeInfo = this.getTypeInfo(beanType)) != null) {
            methods = typeInfo.getMethodSymbols();
        }
        return methods;
    }

    public synchronized IType[] getCachedSupertypes(IType type) {
        TypeInfo typeInfo;
        IType[] types = null;
        if (type != null && (typeInfo = this.getTypeInfo(type)) != null) {
            types = typeInfo.getSupertypes();
        }
        return types;
    }

    public synchronized IType[] getCachedInterfaceTypes(IType type) {
        TypeInfo typeInfo;
        IType[] types = null;
        if (type != null && (typeInfo = this.getTypeInfo(type)) != null) {
            types = typeInfo.getInterfaceTypes();
        }
        return types;
    }

    public synchronized void cacheMethodSymbols(IType beanType, IBeanMethodSymbol[] methods) {
        TypeInfo typeInfo;
        if (beanType != null && (typeInfo = this.getOrCreateTypeInfo(beanType)) != null) {
            typeInfo.setMethodSymbols(methods);
        }
    }

    public synchronized void cachePropertySymbols(IType beanType, IBeanPropertySymbol[] properties) {
        TypeInfo typeInfo;
        if (beanType != null && (typeInfo = this.getOrCreateTypeInfo(beanType)) != null) {
            typeInfo.setPropertySymbols(properties);
        }
    }

    public synchronized IType[] cacheSupertypesFor(IType type) {
        TypeInfo typeInfo;
        IType[] types = null;
        if (type != null && (typeInfo = this.getOrCreateTypeInfo(type)) != null) {
            types = typeInfo.getSupertypes();
        }
        return types;
    }

    public synchronized IType[] cacheInterfaceTypesFor(IType type) {
        TypeInfo typeInfo;
        IType[] types = null;
        if (type != null && (typeInfo = this.getOrCreateTypeInfo(type)) != null) {
            types = typeInfo.getInterfaceTypes();
        }
        return types;
    }

    protected TypeInfo getOrCreateTypeInfo(IType type) {
        TypeInfo typeInfo = this.getTypeInfo(type);
        if (typeInfo == null) {
            try {
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] supertypes = hierarchy.getAllSuperclasses(type);
                IType[] interfaceTypes = hierarchy.getAllInterfaces();
                IType[] rootClasses = hierarchy.getRootClasses();
                ArrayList<String> missingSupertypesList = null;
                int i = 0;
                while (i < rootClasses.length) {
                    String superclassName = rootClasses[i].getSuperclassName();
                    if (superclassName != null) {
                        if (missingSupertypesList == null) {
                            missingSupertypesList = new ArrayList<String>(1);
                        }
                        superclassName = this.shortTypename(superclassName);
                        missingSupertypesList.add(superclassName);
                    }
                    ++i;
                }
                String[] missingSupertypes = null;
                missingSupertypes = missingSupertypesList != null ? missingSupertypesList.toArray(new String[missingSupertypesList.size()]) : TypeInfo.NO_NAMES;
                typeInfo = new TypeInfo();
                typeInfo.setSupertypes(supertypes);
                typeInfo.setInterfaceTypes(interfaceTypes);
                typeInfo.setMissingSupertypeNames(missingSupertypes);
                this.cachedInfo.put(type, typeInfo);
                this.registerCachedType(type, typeInfo);
            }
            catch (JavaModelException e) {
                JSFCommonPlugin.log(e);
            }
        }
        return typeInfo;
    }

    private String shortTypename(String typename) {
        int pos = typename.lastIndexOf(46);
        if (pos >= 0) {
            typename = typename.substring(pos + 1);
        }
        return typename;
    }

    protected void registerCachedType(IType type, TypeInfo typeInfo) {
        this.registerTypeForTypeRoot(type, type.getTypeRoot());
        IType[] supertypes = typeInfo.getSupertypes();
        int i = 0;
        while (i < supertypes.length) {
            this.registerTypeForTypeRoot(type, supertypes[i].getTypeRoot());
            ++i;
        }
        String[] missingSupertypeNames = typeInfo.getMissingSupertypeNames();
        if (missingSupertypeNames != null) {
            int i2 = 0;
            while (i2 < missingSupertypeNames.length) {
                this.registerTypeForMissingSupertype(type, missingSupertypeNames[i2]);
                ++i2;
            }
        }
    }

    private void registerTypeForTypeRoot(IType type, ITypeRoot typeRoot) {
        Set<IType> dependentTypes = this.cachedTypesByAffectingTypeRoot.get(typeRoot);
        if (dependentTypes == null) {
            dependentTypes = new HashSet<IType>(5);
            this.cachedTypesByAffectingTypeRoot.put(typeRoot, dependentTypes);
        }
        dependentTypes.add(type);
    }

    private void registerTypeForMissingSupertype(IType type, String supertype) {
        Set<IType> dependentTypes = this.cachedTypesByMissingSupertypename.get(supertype);
        if (dependentTypes == null) {
            dependentTypes = new HashSet<IType>(5);
            this.cachedTypesByMissingSupertypename.put(supertype, dependentTypes);
        }
        dependentTypes.add(type);
    }

    protected void unregisterCachedType(IType type, TypeInfo typeInfo) {
        this.unregisterTypeForTypeRoot(type, type.getTypeRoot());
        IType[] supertypes = typeInfo.getSupertypes();
        int i = 0;
        while (i < supertypes.length) {
            this.unregisterTypeForTypeRoot(type, supertypes[i].getTypeRoot());
            ++i;
        }
        String[] missingSupertypeNames = typeInfo.getMissingSupertypeNames();
        if (missingSupertypeNames != null) {
            int i2 = 0;
            while (i2 < missingSupertypeNames.length) {
                this.unregisterTypeForMissingSupertype(type, missingSupertypeNames[i2]);
                ++i2;
            }
        }
    }

    private void unregisterTypeForTypeRoot(IType type, ITypeRoot typeRoot) {
        Set<IType> dependentTypes = this.cachedTypesByAffectingTypeRoot.get(typeRoot);
        if (dependentTypes != null) {
            dependentTypes.remove(type);
            if (dependentTypes.isEmpty()) {
                this.cachedTypesByAffectingTypeRoot.remove(typeRoot);
            }
        }
    }

    private void unregisterTypeForMissingSupertype(IType type, String supertype) {
        Set<IType> dependentTypes = this.cachedTypesByMissingSupertypename.get(supertype);
        if (dependentTypes != null) {
            dependentTypes.remove(type);
            if (dependentTypes.isEmpty()) {
                this.cachedTypesByMissingSupertypename.remove(supertype);
            }
        }
    }

    protected synchronized void uncacheAllTypes() {
        this.cachedInfo.clear();
        this.cachedTypesByAffectingTypeRoot.clear();
        this.cachedTypesByMissingSupertypename.clear();
    }

    protected synchronized void uncacheAffectedTypes(ITypeRoot typeRoot) {
        Collection affectedTypes = this.cachedTypesByAffectingTypeRoot.get(typeRoot);
        if (affectedTypes != null && !affectedTypes.isEmpty()) {
            ArrayList affectedTypesCopy = new ArrayList(affectedTypes);
            for (IType cachedType : affectedTypesCopy) {
                TypeInfo typeInfo = this.cachedInfo.remove(cachedType);
                this.unregisterCachedType(cachedType, typeInfo);
            }
        }
    }

    protected synchronized void uncacheTypesWithMissingSupertype(String supertypename) {
        Collection affectedTypes = this.cachedTypesByMissingSupertypename.get(this.shortTypename(supertypename));
        if (affectedTypes != null && !affectedTypes.isEmpty()) {
            ArrayList affectedTypesCopy = new ArrayList(affectedTypes);
            for (IType cachedType : affectedTypesCopy) {
                TypeInfo typeInfo = this.cachedInfo.remove(cachedType);
                this.unregisterCachedType(cachedType, typeInfo);
            }
        }
    }

    protected void updateChangedJavaElement(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.updateChangedJavaModel(delta, element);
                break;
            }
            case 2: {
                this.updateChangedJavaProject(delta, element);
                break;
            }
            case 3: {
                this.updateChangedPackageFragmentRoot(delta, element);
                break;
            }
            case 4: {
                this.updateChangedPackageFragment(delta, (IPackageFragment)element);
                break;
            }
            case 5: 
            case 6: {
                this.updateChangedOpenable(delta, element);
            }
        }
    }

    private void updateChangedChildren(IJavaElementDelta delta) {
        if ((delta.getFlags() & 8) > 0) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.updateChangedJavaElement(children[i]);
                ++i;
            }
        }
    }

    private void updateChangedJavaModel(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                this.uncacheAllTypes();
                break;
            }
            case 4: {
                this.updateChangedChildren(delta);
            }
        }
    }

    private void updateChangedJavaProject(IJavaElementDelta delta, IJavaElement element) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if ((flags & 0x200) != 0) {
            kind = 1;
        }
        if ((flags & 0x400) != 0) {
            kind = 2;
        }
        switch (kind) {
            case 1: 
            case 2: {
                this.uncacheAllTypes();
                break;
            }
            case 4: {
                this.updateChangedChildren(delta);
            }
        }
    }

    private void updateChangedPackageFragment(IJavaElementDelta delta, IPackageFragment element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                this.uncacheAllTypes();
                break;
            }
            case 4: {
                this.updateChangedChildren(delta);
            }
        }
    }

    private void updateChangedPackageFragmentRoot(IJavaElementDelta delta, IJavaElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                this.uncacheAllTypes();
                break;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 || (flags & 0x80) > 0) {
                    this.uncacheAllTypes();
                    break;
                }
                this.updateChangedChildren(delta);
            }
        }
    }

    protected void updateChangedOpenable(IJavaElementDelta delta, IJavaElement element) {
        if (element instanceof ITypeRoot) {
            ITypeRoot typeRoot = (ITypeRoot)element;
            this.uncacheAffectedTypes(typeRoot);
            if (delta.getKind() == 1) {
                if (typeRoot instanceof ICompilationUnit) {
                    ICompilationUnit cu = (ICompilationUnit)typeRoot;
                    try {
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.uncacheTypesWithMissingSupertype(types[i].getElementName());
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        JSFCommonPlugin.log(1, "Unable to get types for compilation unit " + cu, e);
                        this.uncacheAllTypes();
                    }
                } else if (typeRoot instanceof IClassFile) {
                    IClassFile cf = (IClassFile)typeRoot;
                    IType type = cf.getType();
                    this.uncacheTypesWithMissingSupertype(type.getElementName());
                }
            }
        }
    }
}

