/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;

public class DesignerStyleActionGroup {
    private static HashMap IMAGE_NAMES = new HashMap();
    private static final String VERTICAL = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.V");
    private static final String HORIZONTAL = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.H");
    private static final String DESIGN = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.D");
    private static final String SOURCE = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.S");
    private static final String VERTICAL_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.V.Tooltip");
    private static final String HORIZONTAL_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.H.Tooltip");
    private static final String DESIGN_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.D.Tooltip");
    private static final String SOURCE_TOOLTIP = ActionsMessages.getString("DesignerStyleActionGroup.CommandLabel.S.Tooltip");
    HTMLEditor _htmlEditor;
    ChangeDesignerStyleAction[] _actions = null;

    static {
        IMAGE_NAMES.put(VERTICAL, "PD_Toolbar_vsplit.gif");
        IMAGE_NAMES.put(HORIZONTAL, "PD_Toolbar_hsplit.gif");
        IMAGE_NAMES.put(DESIGN, "PD_Toolbar_designer.gif");
        IMAGE_NAMES.put(SOURCE, "PD_Toolbar_source.gif");
    }

    public DesignerStyleActionGroup() {
        ChangeDesignerStyleAction _verAction = new ChangeDesignerStyleAction(VERTICAL, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(VERTICAL)), 0);
        _verAction.setId("org.eclipse.jst.pagedesigner.vertical");
        _verAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.vertical");
        _verAction.setToolTipText(VERTICAL_TOOLTIP);
        ChangeDesignerStyleAction _horAction = new ChangeDesignerStyleAction(HORIZONTAL, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(HORIZONTAL)), 1);
        _horAction.setId("org.eclipse.jst.pagedesigner.horizotal");
        _horAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.horizotal");
        _horAction.setToolTipText(HORIZONTAL_TOOLTIP);
        ChangeDesignerStyleAction _designAction = new ChangeDesignerStyleAction(DESIGN, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(DESIGN)), 2);
        _designAction.setId("org.eclipse.jst.pagedesigner.design");
        _designAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.design");
        _designAction.setToolTipText(DESIGN_TOOLTIP);
        ChangeDesignerStyleAction _sourceAction = new ChangeDesignerStyleAction(SOURCE, PDPlugin.getDefault().getImageDescriptor((String)IMAGE_NAMES.get(SOURCE)), 3);
        _sourceAction.setId("org.eclipse.jst.pagedesigner.source");
        _sourceAction.setActionDefinitionId("org.eclipse.jst.pagedesigner.source");
        _sourceAction.setToolTipText(SOURCE_TOOLTIP);
        this._actions = new ChangeDesignerStyleAction[]{_verAction, _horAction, _designAction, _sourceAction};
    }

    private void updateActionBars() {
        if (this._htmlEditor == null) {
            int i = 0;
            while (i < this._actions.length) {
                this._actions[i].setEnabled(false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._actions.length) {
                this._actions[i].setEnabled(true);
                this._actions[i].setChecked(this._actions[i].getMode() == this._htmlEditor.getDesignerMode());
                ++i;
            }
        }
    }

    public void setHTMLEditor(HTMLEditor editor) {
        this._htmlEditor = editor;
        if (editor != null) {
            IKeyBindingService keyBindingService = editor.getSite().getKeyBindingService();
            int i = 0;
            while (i < this._actions.length) {
                keyBindingService.registerAction((IAction)this._actions[i]);
                ++i;
            }
        }
        this.updateActionBars();
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolbar = actionBars.getToolBarManager();
        int i = 0;
        while (i < this._actions.length) {
            toolbar.add((IAction)this._actions[i]);
            ++i;
        }
        toolbar.add((IContributionItem)new Separator());
    }

    public void dispose() {
        if (this._htmlEditor != null) {
            IKeyBindingService keyBindingService = this._htmlEditor.getSite().getKeyBindingService();
            int i = 0;
            while (i < this._actions.length) {
                keyBindingService.unregisterAction((IAction)this._actions[i]);
                ++i;
            }
        }
    }

    class ChangeDesignerStyleAction
    extends Action {
        int _mode;

        ChangeDesignerStyleAction(String text, ImageDescriptor image, int mode) {
            super(text, 8);
            this.setImageDescriptor(image);
            this._mode = mode;
        }

        public int getMode() {
            return this._mode;
        }

        public void run() {
            if (DesignerStyleActionGroup.this._htmlEditor != null) {
                DesignerStyleActionGroup.this._htmlEditor.setDesignerMode(this._mode);
                DesignerStyleActionGroup.this.updateActionBars();
            }
        }
    }
}

