/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSWidgetLayout;
import org.eclipse.jst.pagedesigner.css2.style.AbstractStyle;
import org.eclipse.jst.pagedesigner.css2.widget.HiddenProvider;
import org.eclipse.jst.pagedesigner.dtmanager.DTManager;
import org.eclipse.jst.pagedesigner.editpolicies.ElementMenuBar;
import org.eclipse.jst.pagedesigner.editpolicies.ElementResizableEditPolicy;
import org.eclipse.jst.pagedesigner.editpolicies.IEnhancedSelectionEditPolicy;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFactoryRegistry;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.figurehandler.FigureFactory;
import org.eclipse.jst.pagedesigner.figurehandler.IFigureHandler;
import org.eclipse.jst.pagedesigner.parts.EditProxyAdapter;
import org.eclipse.jst.pagedesigner.parts.NonVisualComponentEditPart;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.range.RangeUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementEditPart
extends SubNodeEditPart {
    private static Logger _log = PDPlugin.getLogger(ElementEditPart.class);
    private Element _elementNode;
    private ITagConverter _tagConverter;
    private ElementMenuBar _nonVisualElementBar;

    public void setModel(Object model) {
        super.setModel(model);
        this._elementNode = (Element)model;
        this._tagConverter = this.getTagConverter(this._elementNode);
        this._tagConverter.convertRefresh(null);
        this.adaptEditProxy();
    }

    public DragTracker getDragTracker(Request request) {
        EditPolicy policy = this.getEditPolicy("Selection Feedback");
        if ("selection.tracker.request".equals(request.getType()) || "selection".equals(request.getType())) {
            if (policy instanceof IEnhancedSelectionEditPolicy && request instanceof LocationRequest) {
                return ((IEnhancedSelectionEditPolicy)policy).getSelectionDragTracker((LocationRequest)request);
            }
            return null;
        }
        return new DragEditPartsTracker((EditPart)this);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        IElementEdit support = this.getElementEdit();
        if (support != null) {
            support.createEditPolicies(this);
        }
        if (this.getEditPolicy("Selection Feedback") == null) {
            this.installEditPolicy("Selection Feedback", (EditPolicy)new ElementResizableEditPolicy());
        }
    }

    public IElementEdit getElementEdit() {
        return ElementEditFactoryRegistry.getInstance().createElementEdit(this._elementNode);
    }

    public void addNotify() {
        if (this._tagConverter == null) {
            this._tagConverter = this.getTagConverter(this._elementNode);
            this._tagConverter.convertRefresh(null);
            this.adaptEditProxy();
        }
        super.addNotify();
    }

    private ITagConverter getTagConverter(Element node) {
        return DTManager.getInstance().getTagConverter(node, 0, this.getDestDocumentForDesign());
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected List getModelChildren() {
        ArrayList<ITagConverter> children_ = new ArrayList<ITagConverter>(this._tagConverter.getChildModeList());
        for (Element nonVisualChild : this._tagConverter.getNonVisualChildren()) {
            children_.add(DTManager.getInstance().getTagConverter(nonVisualChild, 0, this.getDestDocumentForDesign()));
        }
        return children_;
    }

    protected IFigure createFigure() {
        return new CSSFigure();
    }

    private HiddenProvider createHiddenProvider() {
        String localName;
        Element result = this._tagConverter.getHostElement();
        String appendString = localName = result.getLocalName();
        if (localName.equalsIgnoreCase("directive.taglib") && (appendString = ((IDOMElement)result).getAttribute("uri")) == null) {
            appendString = "";
        }
        Image image = this._tagConverter.getVisualImage();
        HiddenProvider provider = new HiddenProvider(image, this);
        ((CSSFigure)this.getFigure()).setCSSStyle(provider.getCSSStyle());
        provider.setLabel(appendString);
        return provider;
    }

    public void refreshModelChange(boolean recursive) {
        IElementEdit support = this.getElementEdit();
        if (support == null || !support.handleModelChange(this._elementNode, this, recursive)) {
            this.refresh(recursive);
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean recursive) {
        EditPart editPart;
        if (!this._tagConverter.isVisualByHTML()) {
            this._tagConverter.convertRefresh(null);
            ((CSSFigure)this.getFigure()).setFixedLayoutManager(new CSSWidgetLayout((CSSFigure)this.getFigure(), this.createHiddenProvider()));
            return;
        }
        HashMap<Object, EditPart> modelToEditPart = new HashMap<Object, EditPart>();
        List children1 = this.getChildren();
        int i = 0;
        int n = children1.size();
        while (i < n) {
            editPart = (EditPart)children1.get(i);
            modelToEditPart.put(editPart.getModel(), editPart);
            this.removeChildVisual(editPart);
            ++i;
        }
        Element oldEle = this._tagConverter.getResultElement();
        Node parent = oldEle.getParentNode();
        this._tagConverter.convertRefresh(null);
        if (parent != null) {
            parent.replaceChild(this._tagConverter.getResultElement(), oldEle);
        }
        this.adaptEditProxy();
        FigureFactory.updateDeepFigure(this._tagConverter.getResultElement(), oldEle, (CSSFigure)this.getFigure());
        List modelObjects = this.getModelChildren();
        if (!recursive) {
            int i2 = 0;
            int n2 = modelObjects.size();
            while (i2 < n2) {
                Object model = modelObjects.get(i2);
                editPart = (EditPart)modelToEditPart.remove(model);
                if (editPart != null) {
                    this.addChildVisual(editPart, i2);
                } else {
                    editPart = this.createChild(model);
                    this.addChild(editPart, i2);
                }
                ++i2;
            }
            for (EditPart part : modelToEditPart.values()) {
                this.removeChild(part);
            }
        } else {
            for (EditPart part : modelToEditPart.values()) {
                this.removeChild(part);
            }
            int i3 = 0;
            int n3 = modelObjects.size();
            while (i3 < n3) {
                Object model = modelObjects.get(i3);
                editPart = this.createChild(model);
                this.addChild(editPart, i3);
                ++i3;
            }
        }
    }

    private void adaptEditProxy() {
        Element resultEle = this._tagConverter.getResultElement();
        if (resultEle instanceof IDOMElement) {
            INodeAdapter adapter = ((IDOMElement)resultEle).getAdapterFor(EditProxyAdapter.class);
            if (adapter != null) {
                ((IDOMElement)resultEle).removeAdapter(adapter);
            }
            ((IDOMElement)resultEle).addAdapter((INodeAdapter)new EditProxyAdapter(this));
        }
    }

    public boolean isRangeSelected() {
        IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this.getViewer();
        if (viewer == null || !viewer.isInRangeMode()) {
            return false;
        }
        DesignRange range = viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            return false;
        }
        return RangeUtil.intersect(range, (EditPart)this);
    }

    public boolean isWidget() {
        return this._tagConverter.isWidget();
    }

    public boolean canHaveDirectTextChild() {
        return CMUtil.canHaveDirectTextChild((Element)this._elementNode);
    }

    public boolean isResizable() {
        if (!this._tagConverter.isVisualByHTML()) {
            return false;
        }
        IElementEdit edit = this.getElementEdit();
        if (edit != null) {
            return edit.isResizable(this._elementNode);
        }
        CMElementDeclaration decl = CMUtil.getElementDeclaration((Element)this._elementNode);
        if (decl != null) {
            return decl.getAttributes().getNamedItem("style") != null;
        }
        return true;
    }

    private IFigure getFigure(Node parent) {
        IFigureHandler handler;
        if (parent instanceof INodeNotifier && (handler = (IFigureHandler)((INodeNotifier)parent).getAdapterFor(IFigureHandler.class)) != null) {
            return handler.getFigure();
        }
        return null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        boolean figureAdded = false;
        if (childEditPart instanceof NonVisualComponentEditPart) {
            this.getNonVisualElementBar().addNonVisualChild((NonVisualComponentEditPart)childEditPart);
            figureAdded = true;
            return;
        }
        Node childNode = (Node)childEditPart.getModel();
        IFigure childFigure = ((GraphicalEditPart)childEditPart).getFigure();
        ConvertPosition position = this._tagConverter.getChildVisualPosition(childNode);
        if (position != null) {
            Node nodeForFigure;
            ICSSStyle childStyle;
            ICSSStyle parentStyle;
            Node parent = position.getParentNode();
            IFigure parentFigure = this.getFigure(parent);
            if (parentFigure != null) {
                parentFigure.add(childFigure, position.getIndex());
                figureAdded = true;
            }
            if (parent instanceof INodeNotifier && (parentStyle = (ICSSStyle)((INodeNotifier)parent).getAdapterFor(ICSSStyle.class)) != null && (childStyle = (ICSSStyle)((INodeNotifier)childNode).getAdapterFor(ICSSStyle.class)) instanceof AbstractStyle) {
                ((AbstractStyle)childStyle).setParentStyle(parentStyle);
            }
            if (childEditPart instanceof SubNodeEditPart && (nodeForFigure = ((SubNodeEditPart)childEditPart).getNodeForFigure()) != null) {
                parent.appendChild(nodeForFigure);
            }
        } else {
            _log.error("getChildVisualPosition() return null");
        }
        if (!figureAdded) {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure childFigure = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure parent = childFigure.getParent();
        if (parent != null) {
            parent.remove(childFigure);
        }
        if (childEditPart instanceof NonVisualComponentEditPart) {
            this._nonVisualElementBar.removeNonVisualChild((NonVisualComponentEditPart)childEditPart);
        } else {
            Node nodeForFigure;
            Node childNode = (Node)childEditPart.getModel();
            ICSSStyle childStyle = (ICSSStyle)((INodeNotifier)childNode).getAdapterFor(ICSSStyle.class);
            if (childStyle instanceof AbstractStyle) {
                ((AbstractStyle)childStyle).setParentStyle(null);
            }
            if (childEditPart instanceof SubNodeEditPart && (nodeForFigure = ((SubNodeEditPart)childEditPart).getNodeForFigure()) != null && nodeForFigure.getParentNode() != null) {
                nodeForFigure.getParentNode().removeChild(nodeForFigure);
            }
        }
    }

    public ITagConverter getTagConvert() {
        return this._tagConverter;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        this.refresh();
    }

    public Node getNodeForFigure() {
        return this._tagConverter.getResultElement();
    }

    public boolean haveNonWhitespaceTextChild() {
        List children1 = this.getChildren();
        int i = 0;
        int size = children1.size();
        while (i < size) {
            IDOMText xmltext;
            if (children1.get(i) instanceof TextEditPart && !(xmltext = (IDOMText)((TextEditPart)children1.get(i)).getIDOMNode()).isElementContentWhitespace()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ElementMenuBar getNonVisualElementBar() {
        if (this._nonVisualElementBar == null) {
            this._nonVisualElementBar = new ElementMenuBar(this);
        }
        return this._nonVisualElementBar;
    }

    public ElementMenuBar getElementMenuBar() {
        return this.getNonVisualElementBar();
    }

    public void deactivate() {
        super.deactivate();
        if (this._nonVisualElementBar != null) {
            this._nonVisualElementBar.dispose();
            this._nonVisualElementBar = null;
        }
        if (this._tagConverter != null) {
            this._tagConverter.dispose();
        }
    }

    public Cursor getCursor(Point mouseLocation) {
        EditPolicy editPolicy = this.getEditPolicy("Selection Feedback");
        if (editPolicy instanceof IEnhancedSelectionEditPolicy) {
            return ((IEnhancedSelectionEditPolicy)editPolicy).getSelectionToolCursor(mouseLocation);
        }
        return super.getCursor(mouseLocation);
    }
}

