/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.connection;

import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.Connection;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePropertiesComposite
extends AbstractPane<Connection> {
    public DataSourcePropertiesComposite(AbstractPane<Connection> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private WritablePropertyValueModel<String> buildJtaDataSourceHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"jtaDataSourceProperty"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getJtaDataSource();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setJtaDataSource(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildJTADataSourceHolder() {
        return new TransformationPropertyValueModel<PersistenceUnitTransactionType, Boolean>(this.buildTransactionTypeHolder()){

            protected Boolean transform(PersistenceUnitTransactionType value) {
                if (value != null && value != PersistenceUnitTransactionType.JTA) {
                    return false;
                }
                return true;
            }
        };
    }

    private WritablePropertyValueModel<String> buildNonJtaDataSourceHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"nonJtaDataSourceProperty"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getNonJtaDataSource();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setNonJtaDataSource(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildNonJTADataSourceHolder() {
        return new TransformationPropertyValueModel<PersistenceUnitTransactionType, Boolean>(this.buildTransactionTypeHolder()){

            protected Boolean transform(PersistenceUnitTransactionType value) {
                if (value == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
                    return true;
                }
                return false;
            }
        };
    }

    private PropertyValueModel<PersistenceUnitTransactionType> buildTransactionTypeHolder() {
        return new PropertyAspectAdapter<Connection, PersistenceUnitTransactionType>(this.getSubjectHolder(), new String[]{"transactionTypeProperty"}){

            protected PersistenceUnitTransactionType buildValue_() {
                return ((Connection)this.subject).getTransactionType();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.groupBoxMargin();
        container = this.buildSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        Text text = this.buildLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_jtaDataSourceLabel, this.buildJtaDataSourceHolder());
        this.installJTADataSourceControlEnabler(text);
        text = this.buildLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_nonJtaDataSourceLabel, this.buildNonJtaDataSourceHolder());
        this.installNonJTADataSourceControlEnabler(text);
    }

    private void installJTADataSourceControlEnabler(Text text) {
        new ControlEnabler(this.buildJTADataSourceHolder(), (Control)text);
    }

    private void installNonJTADataSourceControlEnabler(Text text) {
        new ControlEnabler(this.buildNonJTADataSourceHolder(), (Control)text);
    }
}

