/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.contentassist;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.FCContext;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;

class CompletionStringNode {
    private final String completionstring;
    private final String attributes;
    private Hashtable htAttributes = new Hashtable();
    static final String keyFollowClass = "fc";
    static final String keyIESupport = "iesupport";
    static final String keyNsSupport = "nssupport";
    static final String keyECMASupport = "ecmasupport";
    static final String keyShortGUIHelpText = "shortguihelptext";
    static final String keyWASJSPSupport = "wasjspsupport";
    static final String keyDisplayText = "displaytext";
    static final String keyAdditionalDisplayText = "additionaldisplaytext";
    static final String keyType = "type";
    private static final String JAVADOCAT_TYPE = "javadocat";
    private static final String HTMLTAG_TYPE = "htmltag";
    private static final String METHOD_TYPE = "method";

    public CompletionStringNode(String cs, String fc, String newAttributes) {
        this.completionstring = cs;
        this.attributes = null;
        String ns = "q";
        String ie = "q";
        String ecma = "q";
        if (newAttributes != null) {
            if (newAttributes.indexOf(";ns=y;") >= 0) {
                ns = "y";
            } else if (newAttributes.indexOf(";ns=n;") >= 0) {
                ns = "n";
            }
            if (newAttributes.indexOf(";ie=y;") >= 0) {
                ie = "y";
            } else if (newAttributes.indexOf(";ie=n;") >= 0) {
                ie = "n";
            }
            if (newAttributes.indexOf(";ecma=y;") >= 0) {
                ecma = "y";
            } else if (newAttributes.indexOf(";ecma=n;") >= 0) {
                ecma = "n";
            }
        }
        this.htAttributes.put(keyNsSupport, ns);
        this.htAttributes.put(keyIESupport, ie);
        this.htAttributes.put(keyECMASupport, ecma);
        this.htAttributes.put(keyFollowClass, fc);
    }

    public CompletionStringNode(String cs, Hashtable ht) {
        this.completionstring = cs;
        this.htAttributes = ht;
        this.attributes = null;
    }

    public Hashtable getAttributesH() {
        return this.htAttributes;
    }

    public String getAttributesS() {
        return this.attributes;
    }

    public String getCompletionString() {
        return this.completionstring;
    }

    public String getDefaultDisplayText() {
        String adt;
        String dt = (String)this.htAttributes.get(keyDisplayText);
        if (dt == null) {
            dt = this.completionstring;
        }
        if ((adt = (String)this.htAttributes.get(keyAdditionalDisplayText)) != null) {
            dt = String.valueOf(dt) + " " + adt;
        }
        return dt;
    }

    public String getFCName() {
        return (String)this.htAttributes.get(keyFollowClass);
    }

    public Image getImage(FCContext fcc) {
        String completype = (String)this.htAttributes.get(keyType);
        if (completype != null) {
            if (completype.equals(JAVADOCAT_TYPE)) {
                return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/jdoc_tag_obj.gif");
            }
            if (completype.equals(HTMLTAG_TYPE)) {
                return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/html_tag_obj.gif");
            }
            if (completype.equals(METHOD_TYPE)) {
                return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/methpub_obj.gif");
            }
        }
        return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/default.gif");
    }
}

