/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.TransportProviderRegistry;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLCommonElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPHeaderWrapperFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPTransportProvider;
import org.eclipse.wst.ws.internal.explorer.transport.MessageContext;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDNamedComponent;

public class WSDLOperationElement
extends WSDLCommonElement {
    public static final int OPERATION_TYPE_SOAP = 0;
    public static final int OPERATION_TYPE_HTTP_GET = 1;
    public static final int OPERATION_TYPE_HTTP_POST = 2;
    private int operationType_;
    private Operation operation_;
    private WSDLPartsToXSDTypeMapper wsdlPartsToXsdTypeMapper_;
    private XSDToFragmentController fragController_;
    private boolean isDocumentStyle_;
    private boolean isUseLiteral_;
    private String soapAction_;
    private String encodingStyle_;
    private String encodingNamespace_;
    private Map headerCache;
    private MessageContext messageContext = null;
    private ISOAPTransportProvider soapTransportProvider = null;

    private final void gatherSoapInformation(WSDLBindingElement bindingElement, SOAPBinding soapBinding) {
        this.isDocumentStyle_ = true;
        this.soapAction_ = "";
        this.isUseLiteral_ = true;
        this.encodingStyle_ = null;
        this.encodingNamespace_ = null;
        if (soapBinding != null) {
            this.isDocumentStyle_ = "document".equals(soapBinding.getStyle());
        }
        BindingOperation bindingOperation = this.getBindingOperation(bindingElement);
        SOAPOperation soapOperation = null;
        for (ExtensibilityElement e : bindingOperation.getExtensibilityElements()) {
            String style;
            if (!(e instanceof SOAPOperation)) continue;
            soapOperation = (SOAPOperation)e;
            this.soapAction_ = soapOperation.getSoapActionURI();
            if (this.soapAction_ == null) {
                this.soapAction_ = "";
            }
            if ((style = soapOperation.getStyle()) == null) break;
            this.isDocumentStyle_ = style.equals("document");
            break;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        SOAPBody soapBody = null;
        for (ExtensibilityElement e : bindingInput.getExtensibilityElements()) {
            Iterator j;
            if (!(e instanceof SOAPBody)) continue;
            soapBody = (SOAPBody)e;
            this.isUseLiteral_ = "literal".equals(soapBody.getUse());
            if (this.isUseLiteral_ || !(j = soapBody.getEncodingStyles().iterator()).hasNext()) break;
            this.encodingStyle_ = (String)j.next();
            this.encodingNamespace_ = soapBody.getNamespaceURI();
            break;
        }
    }

    public WSDLOperationElement(String name, WSDLBindingElement bindingElement, Operation operation) {
        super(name, bindingElement.getModel());
        this.setOperation(bindingElement, operation);
    }

    private Definition getDefinition(WSDLBindingElement bindingElement) {
        WSDLServiceElement serviceElement = (WSDLServiceElement)bindingElement.getParentElement();
        WSDLElement wsdlElement = (WSDLElement)serviceElement.getParentElement();
        return wsdlElement.getDefinition();
    }

    private void setMessageContext(WSDLBindingElement bindingElement) {
        this.messageContext = new MessageContext();
        this.messageContext.setDefinition(this.getDefinition(bindingElement));
        this.messageContext.setBindingOperation(this.getBindingOperation(bindingElement));
        this.messageContext.setBindingProtocol(bindingElement.getBindingExtensibilityElement());
        this.messageContext.setDocumentStyle(this.isDocumentStyle_);
    }

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    private void setSOAPTransportProvider(SOAPBinding soapBinding) {
        String namespaceURI = soapBinding.getElementType().getNamespaceURI();
        String transportURI = soapBinding.getTransportURI();
        this.soapTransportProvider = TransportProviderRegistry.getInstance().getSOAPTransportProvider(namespaceURI, transportURI);
    }

    public ISOAPTransportProvider getSOAPTransportProvider() {
        return this.soapTransportProvider;
    }

    public void setOperation(WSDLBindingElement bindingElement, Operation operation) {
        this.operation_ = operation;
        this.setDocumentation(operation.getDocumentationElement());
        this.fragController_ = null;
        this.wsdlPartsToXsdTypeMapper_ = null;
        this.operationType_ = bindingElement.getBindingType();
        ExtensibilityElement bindingExtensibilityElement = bindingElement.getBindingExtensibilityElement();
        switch (this.operationType_) {
            case 0: {
                this.gatherSoapInformation(bindingElement, (SOAPBinding)bindingExtensibilityElement);
                this.setMessageContext(bindingElement);
                this.setSOAPTransportProvider((SOAPBinding)bindingExtensibilityElement);
                this.headerCache = new Hashtable();
            }
        }
    }

    public Operation getOperation() {
        return this.operation_;
    }

    public BindingOperation getBindingOperation() {
        return this.getBindingOperation((WSDLBindingElement)this.getParentElement());
    }

    private BindingOperation getBindingOperation(WSDLBindingElement bindingElement) {
        BindingOperation bindingOperation;
        Binding binding = bindingElement.getBinding();
        String operationInputName = null;
        String operationOutputName = null;
        Input operationInput = this.operation_.getInput();
        Output operationOutput = this.operation_.getOutput();
        if (operationInput != null) {
            operationInputName = operationInput.getName();
        }
        if (operationOutput != null) {
            operationOutputName = operationOutput.getName();
        }
        if ((bindingOperation = binding.getBindingOperation(this.operation_.getName(), operationInputName, operationOutputName)) == null) {
            bindingOperation = binding.getBindingOperation(this.operation_.getName(), null, null);
        }
        return bindingOperation;
    }

    public List getSOAPHeaders() {
        return this.getSOAPHeaders(true);
    }

    public List getSOAPHeaders(boolean isInput) {
        Vector<ExtensibilityElement> headers = new Vector<ExtensibilityElement>();
        BindingOperation bindingOperation = this.getBindingOperation();
        List extensibilityElements = isInput ? bindingOperation.getBindingInput().getExtensibilityElements() : bindingOperation.getBindingOutput().getExtensibilityElements();
        for (ExtensibilityElement e : extensibilityElements) {
            if (!(e instanceof SOAPHeader) || headers.contains(e)) continue;
            headers.add(e);
        }
        return headers;
    }

    public List getOrderedBodyParts() {
        Vector parts = new Vector(this.operation_.getInput().getMessage().getOrderedParts(this.operation_.getParameterOrdering()));
        BindingOperation bindingOperation = this.getBindingOperation();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        for (ExtensibilityElement e : bindingInput.getExtensibilityElements()) {
            if (!(e instanceof SOAPBody)) continue;
            SOAPBody soapBody = (SOAPBody)e;
            List bodyParts = soapBody.getParts();
            if (bodyParts == null) break;
            int i = 0;
            while (i < parts.size()) {
                javax.wsdl.Part part = (javax.wsdl.Part)parts.get(i);
                if (!bodyParts.contains(part) && !bodyParts.contains(part.getName())) {
                    parts.remove(i);
                    --i;
                }
                ++i;
            }
            break block0;
        }
        return parts;
    }

    private XSDToFragmentController getXSDToFragmentController() {
        if (this.fragController_ == null) {
            this.fragController_ = new XSDToFragmentController();
            this.fragController_.setWSDLPartsToXSDTypeMapper(this.wsdlPartsToXsdTypeMapper_);
        }
        return this.fragController_;
    }

    private XSDNamedComponent getSchema(javax.wsdl.Part part, String id) {
        if (this.wsdlPartsToXsdTypeMapper_ == null) {
            this.wsdlPartsToXsdTypeMapper_ = new WSDLPartsToXSDTypeMapper();
            WSDLBindingElement bindingElement = (WSDLBindingElement)this.getParentElement();
            WSDLServiceElement serviceElement = (WSDLServiceElement)bindingElement.getParentElement();
            WSDLElement wsdlElement = (WSDLElement)serviceElement.getParentElement();
            this.wsdlPartsToXsdTypeMapper_.addSchemas(wsdlElement.getSchemaList());
        }
        return this.wsdlPartsToXsdTypeMapper_.getXSDType(part, id);
    }

    public IXSDFragment getHeaderFragment(SOAPHeader soapHeader) {
        return this.getHeaderFragment(soapHeader, true);
    }

    public IXSDFragment getHeaderFragment(SOAPHeader soapHeader, boolean isInput) {
        StringBuffer id = new StringBuffer();
        Part part = soapHeader.getEPart();
        if (isInput) {
            id.append("::input").append(soapHeader.getMessage()).append("^");
        } else {
            id.append("::output").append(soapHeader.getMessage()).append("^");
        }
        return this.getFragment((javax.wsdl.Part)part, id, true, isInput);
    }

    public IXSDFragment getFragment(javax.wsdl.Part part) {
        return this.getFragment(part, true);
    }

    public IXSDFragment getFragment(javax.wsdl.Part part, boolean isInput) {
        StringBuffer id = new StringBuffer();
        if (isInput) {
            id.append("::input");
        } else {
            id.append("::output");
        }
        return this.getFragment(part, id, false, false);
    }

    private IXSDFragment getFragment(javax.wsdl.Part part, StringBuffer id, boolean isHeader, boolean useSOAPHeaderWrapper) {
        String partName = part.getName();
        id.append(partName);
        XSDToFragmentConfiguration config = new XSDToFragmentConfiguration();
        config.setIsWSDLPart(true);
        config.setWSDLPartName(partName);
        config.setXSDComponent((XSDComponent)this.getSchema(part, id.toString()));
        if (this.isDocumentStyle() || isHeader) {
            config.setStyle(0);
        } else {
            config.setStyle(1);
        }
        if (this.operationType_ == 0) {
            if (!this.isUseLiteral_) {
                config.setPartEncoding(1);
            }
        } else {
            config.setPartEncoding(2);
        }
        IXSDFragment fragment = this.getXSDToFragmentController().getFragment(config, id.toString(), part.getName());
        if (useSOAPHeaderWrapper && !(fragment instanceof SOAPHeaderWrapperFragment)) {
            SOAPHeaderWrapperFragment wrapper = (SOAPHeaderWrapperFragment)this.headerCache.get(fragment.getID());
            if (wrapper == null) {
                wrapper = new SOAPHeaderWrapperFragment(fragment);
                this.headerCache.put(fragment.getID(), wrapper);
                this.getXSDToFragmentController().addToCache(wrapper.getID(), wrapper);
            }
            return wrapper;
        }
        return fragment;
    }

    public IXSDFragment getFragmentByID(String id) {
        return this.getXSDToFragmentController().getCachedFragment(id);
    }

    public void removeAllFragment() {
        this.getXSDToFragmentController().emptyCache();
    }

    public boolean isDocumentStyle() {
        return this.isDocumentStyle_;
    }

    public String getSoapAction() {
        return this.soapAction_;
    }

    public boolean isUseLiteral() {
        return this.isUseLiteral_;
    }

    public String getEncodingStyle() {
        return this.encodingStyle_;
    }

    public String getEncodingNamespace() {
        return this.encodingNamespace_;
    }

    public int getOperationType() {
        return this.operationType_;
    }
}

