/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.schema.generation;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.DdlGenerationType;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.OutputMode;
import org.eclipse.jpt.eclipselink.core.internal.context.schema.generation.SchemaGeneration;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkSchemaGeneration
extends EclipseLinkPersistenceUnitProperties
implements SchemaGeneration {
    private OutputMode outputMode;
    private DdlGenerationType ddlGenerationType;
    private String createFileName;
    private String dropFileName;
    private String applicationLocation;

    public EclipseLinkSchemaGeneration(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.outputMode = (OutputMode)this.getEnumValue("eclipselink.ddl-generation.output-mode", OutputMode.values());
        this.ddlGenerationType = (DdlGenerationType)this.getEnumValue("eclipselink.ddl-generation", DdlGenerationType.values());
        this.createFileName = this.getStringValue("eclipselink.create-ddl-jdbc-file-name");
        this.dropFileName = this.getStringValue("eclipselink.drop-ddl-jdbc-file-name");
        this.applicationLocation = this.getStringValue("eclipselink.application-location");
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.ddl-generation.output-mode", "outputModeProperty");
        propertyNames.put("eclipselink.ddl-generation", "ddlGenerationTypeProperty");
        propertyNames.put("eclipselink.create-ddl-jdbc-file-name", "createFileNameProperty");
        propertyNames.put("eclipselink.drop-ddl-jdbc-file-name", "dropFileNameProperty");
        propertyNames.put("eclipselink.application-location", "applicationLocationProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("outputModeProperty")) {
            this.outputModeChanged(event);
        } else if (aspectName.equals("ddlGenerationTypeProperty")) {
            this.ddlGenerationTypeChanged(event);
        } else if (aspectName.equals("createFileNameProperty")) {
            this.createFileNameChanged(event);
        } else if (aspectName.equals("dropFileNameProperty")) {
            this.dropFileNameChanged(event);
        } else if (aspectName.equals("applicationLocationProperty")) {
            this.applicationLocationChanged(event);
        } else {
            throw new IllegalArgumentException("Illegal event received - property not applicable: " + aspectName);
        }
    }

    @Override
    public DdlGenerationType getDdlGenerationType() {
        return this.ddlGenerationType;
    }

    @Override
    public void setDdlGenerationType(DdlGenerationType newDdlGenType) {
        DdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newDdlGenType;
        this.putProperty("ddlGenerationTypeProperty", (Object)newDdlGenType);
        this.firePropertyChanged("ddlGenerationTypeProperty", (Object)old, (Object)newDdlGenType);
    }

    private void ddlGenerationTypeChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        DdlGenerationType newValue = (DdlGenerationType)EclipseLinkSchemaGeneration.getEnumValueOf((String)stringValue, (Enum[])DdlGenerationType.values());
        DdlGenerationType old = this.ddlGenerationType;
        this.ddlGenerationType = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public DdlGenerationType getDefaultDdlGenerationType() {
        return DEFAULT_SCHEMA_GENERATION_DDL_GENERATION_TYPE;
    }

    @Override
    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    @Override
    public void setOutputMode(OutputMode newOutputMode) {
        OutputMode old = this.outputMode;
        this.outputMode = newOutputMode;
        this.putProperty("outputModeProperty", (Object)newOutputMode);
        this.firePropertyChanged("outputModeProperty", (Object)old, (Object)newOutputMode);
    }

    private void outputModeChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        OutputMode newValue = (OutputMode)EclipseLinkSchemaGeneration.getEnumValueOf((String)stringValue, (Enum[])OutputMode.values());
        OutputMode old = this.outputMode;
        this.outputMode = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public OutputMode getDefaultOutputMode() {
        return DEFAULT_SCHEMA_GENERATION_OUTPUT_MODE;
    }

    @Override
    public String getCreateFileName() {
        return this.createFileName;
    }

    @Override
    public void setCreateFileName(String newCreateFileName) {
        String old = this.createFileName;
        this.createFileName = newCreateFileName;
        this.putProperty("createFileNameProperty", newCreateFileName);
        this.firePropertyChanged("createFileNameProperty", old, newCreateFileName);
    }

    private void createFileNameChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.createFileName;
        this.createFileName = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultCreateFileName() {
        return "createDDL.jdbc";
    }

    @Override
    public String getDropFileName() {
        return this.dropFileName;
    }

    @Override
    public void setDropFileName(String newDropFileName) {
        String old = this.dropFileName;
        this.dropFileName = newDropFileName;
        this.putProperty("dropFileNameProperty", newDropFileName);
        this.firePropertyChanged("dropFileNameProperty", old, newDropFileName);
    }

    private void dropFileNameChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.dropFileName;
        this.dropFileName = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultDropFileName() {
        return "dropDDL.jdbc";
    }

    @Override
    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    @Override
    public void setApplicationLocation(String newApplicationLocation) {
        String old = this.applicationLocation;
        this.applicationLocation = newApplicationLocation;
        this.putProperty("applicationLocationProperty", newApplicationLocation);
        this.firePropertyChanged("applicationLocationProperty", old, newApplicationLocation);
    }

    private void applicationLocationChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.applicationLocation;
        this.applicationLocation = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultApplicationLocation() {
        return ".";
    }
}

