/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.ui.internal.contentassist.JSDTCompletionProposal;

public class JSDTProposalCollector
extends CompletionProposalCollector {
    private Comparator fComparator;
    private IJsTranslation fTranslation;

    static char[] getTypeTriggers() {
        return CompletionProposalCollector.TYPE_TRIGGERS;
    }

    public JSDTProposalCollector(IJsTranslation translation) {
        super(translation.getCompilationUnit());
        if (translation == null) {
            throw new IllegalArgumentException("JSPTranslation cannot be null");
        }
        this.fTranslation = translation;
    }

    private int calculatePositionAfter(CompletionProposal proposal, String completion, int currentCursorOffset) {
        int positionAfter = completion.length();
        int kind = proposal.getKind();
        if (kind == 1 || kind == 7 || kind == 11 || kind == 6) {
            String[] params = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
            if (completion.length() > 0 && params.length > 0) {
                --positionAfter;
            }
        }
        return positionAfter;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        JSDTCompletionProposal jspProposal = null;
        if (!proposal.isConstructor()) {
            jspProposal = this.createJspProposal(proposal);
        }
        return jspProposal;
    }

    private JSDTCompletionProposal createJspProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        int positionAfter = this.calculatePositionAfter(proposal, completion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        JSDTCompletionProposal jspProposal = new JSDTCompletionProposal(completion, offset, length, positionAfter, image, displayString, contextInformation, null, relevance, updateLengthOnValidate);
        jspProposal.setJavaCompletionProposal((ICompletionProposal)javaProposal);
        return jspProposal;
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new CompletionProposalComparator();
        }
        return this.fComparator;
    }

    public JSDTCompletionProposal[] getJSPCompletionProposals() {
        ArrayList<IJavaCompletionProposal> results = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] javaProposals = this.getJavaCompletionProposals();
        int i = 0;
        while (i < javaProposals.length) {
            if (javaProposals[i] instanceof JSDTCompletionProposal) {
                results.add(javaProposals[i]);
            }
            ++i;
        }
        Collections.sort(results, this.getComparator());
        return results.toArray(new JSDTCompletionProposal[results.size()]);
    }

    public IJsTranslation getTranslation() {
        return this.fTranslation;
    }
}

