/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ProgramElement;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;

class NaiveASTFlattener
extends ASTVisitor {
    private StringBuffer buffer = new StringBuffer();
    private int indent = 0;

    NaiveASTFlattener() {
    }

    public String getResult() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    void printIndent() {
        int i = 0;
        while (i < this.indent) {
            this.buffer.append("  ");
            ++i;
        }
    }

    void printModifiers(List ext) {
    }

    void printModifiers(int modifiers) {
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.buffer.append("{\n");
        ++this.indent;
        Iterator it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration b = (BodyDeclaration)it.next();
            b.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept(this);
        this.buffer.append("[");
        node.getIndex().accept(this);
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ArrayCreation node) {
        this.buffer.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept(this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.buffer.append("[");
            Expression e = (Expression)it.next();
            e.accept(this);
            this.buffer.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.buffer.append("[");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append("]");
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept(this);
        this.buffer.append("[]");
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.printIndent();
        this.buffer.append("assert ");
        node.getExpression().accept(this);
        if (node.getMessage() != null) {
            this.buffer.append(" : ");
            node.getMessage().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept(this);
        this.buffer.append(node.getOperator().toString());
        node.getRightHandSide().accept(this);
        return false;
    }

    public boolean visit(Block node) {
        this.buffer.append("{\n");
        ++this.indent;
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            ASTNode s = (ASTNode)it.next();
            s.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(BlockComment node) {
        this.printIndent();
        this.buffer.append("/* */");
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.buffer.append("true");
        } else {
            this.buffer.append("false");
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.printIndent();
        this.buffer.append("break");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(CastExpression node) {
        this.buffer.append("(");
        node.getType().accept(this);
        this.buffer.append(")");
        node.getExpression().accept(this);
        return false;
    }

    public boolean visit(FunctionExpression node) {
        node.getMethod().accept(this);
        return false;
    }

    public boolean visit(CatchClause node) {
        this.buffer.append("catch (");
        node.getException().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(RegularExpressionLiteral node) {
        this.buffer.append(node.getRegularExpression());
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("new ");
        node.getMember().accept(this);
        this.buffer.append("(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(JavaScriptUnit node) {
        ASTNode d;
        if (node.getPackage() != null) {
            node.getPackage().accept(this);
        }
        Iterator it = node.imports().iterator();
        while (it.hasNext()) {
            d = (ImportDeclaration)it.next();
            d.accept(this);
        }
        it = node.types().iterator();
        while (it.hasNext()) {
            d = (AbstractTypeDeclaration)it.next();
            d.accept(this);
        }
        it = node.statements().iterator();
        while (it.hasNext()) {
            d = (ProgramElement)it.next();
            d.accept(this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept(this);
        this.buffer.append(" ? ");
        node.getThenExpression().accept(this);
        this.buffer.append(" : ");
        node.getElseExpression().accept(this);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        Iterator it;
        this.printIndent();
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("this(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.printIndent();
        this.buffer.append("continue");
        if (node.getLabel() != null) {
            this.buffer.append(" ");
            node.getLabel().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(DoStatement node) {
        this.printIndent();
        this.buffer.append("do ");
        node.getBody().accept(this);
        this.buffer.append(" while (");
        node.getExpression().accept(this);
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.printIndent();
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        this.printIndent();
        this.buffer.append("for (");
        node.getParameter().accept(this);
        this.buffer.append(" : ");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        this.printIndent();
        node.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(ForStatement node) {
        Expression e;
        this.printIndent();
        this.buffer.append("for (");
        Iterator it = node.initializers().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
        }
        this.buffer.append("; ");
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(ForInStatement node) {
        this.printIndent();
        this.buffer.append("for (");
        if (node.getIterationVariable() != null) {
            node.getIterationVariable().accept(this);
        }
        this.buffer.append(" in ");
        if (node.getCollection() != null) {
            node.getCollection().accept(this);
        }
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.printIndent();
        this.buffer.append("if (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getThenStatement().accept(this);
        if (node.getElseStatement() != null) {
            this.buffer.append(" else ");
            node.getElseStatement().accept(this);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.printIndent();
        this.buffer.append("import ");
        if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
            this.buffer.append("static ");
        }
        node.getName().accept(this);
        if (node.isOnDemand()) {
            this.buffer.append(".*");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(' ');
        this.buffer.append(node.getOperator().toString());
        this.buffer.append(' ');
        node.getRightOperand().accept(this);
        List extendedOperands = node.extendedOperands();
        if (extendedOperands.size() != 0) {
            this.buffer.append(' ');
            Iterator it = extendedOperands.iterator();
            while (it.hasNext()) {
                this.buffer.append(node.getOperator().toString()).append(' ');
                Expression e = (Expression)it.next();
                e.accept(this);
            }
        }
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(" instanceof ");
        node.getRightOperand().accept(this);
        return false;
    }

    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(JSdoc node) {
        this.printIndent();
        this.buffer.append("/** ");
        Iterator it = node.tags().iterator();
        while (it.hasNext()) {
            ASTNode e = (ASTNode)it.next();
            e.accept(this);
        }
        this.buffer.append("\n */\n");
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.printIndent();
        node.getLabel().accept(this);
        this.buffer.append(": ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(LineComment node) {
        this.buffer.append("//\n");
        return false;
    }

    public boolean visit(ListExpression node) {
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        return false;
    }

    public boolean visit(MemberRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
        }
        this.buffer.append("#");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(FunctionRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
        }
        this.buffer.append("#");
        node.getName().accept(this);
        this.buffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            FunctionRefParameter e = (FunctionRefParameter)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(FunctionRefParameter node) {
        node.getType().accept(this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.buffer.append("...");
        }
        if (node.getName() != null) {
            this.buffer.append(" ");
            node.getName().accept(this);
        }
        return false;
    }

    public boolean visit(FunctionDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
            if (!node.typeParameters().isEmpty()) {
                this.buffer.append("<");
                Iterator it = node.typeParameters().iterator();
                while (it.hasNext()) {
                    TypeParameter t = (TypeParameter)it.next();
                    t.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(",");
                }
                this.buffer.append(">");
            }
        }
        this.buffer.append("function ");
        SimpleName name = node.getName();
        if (name != null) {
            name.accept(this);
        }
        this.buffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.buffer.append("[]");
            ++i;
        }
        if (!node.thrownExceptions().isEmpty()) {
            this.buffer.append(" throws ");
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(" ");
        }
        if (node.getBody() == null) {
            this.buffer.append(";\n");
        } else {
            node.getBody().accept(this);
        }
        return false;
    }

    public boolean visit(FunctionInvocation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            if (node.getName() != null) {
                this.buffer.append(".");
            }
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        if (node.getName() != null) {
            node.getName().accept(this);
        }
        this.buffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(Modifier node) {
        this.buffer.append(node.getKeyword().toString());
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.buffer.append("null");
        return false;
    }

    public boolean visit(UndefinedLiteral node) {
        this.buffer.append("undefined");
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.buffer.append(node.getToken());
        return false;
    }

    public boolean visit(ObjectLiteral node) {
        if (node.fields().isEmpty()) {
            this.buffer.append("{}");
        } else {
            this.buffer.append("{\n");
            Iterator it = node.fields().iterator();
            while (it.hasNext()) {
                ObjectLiteralField field = (ObjectLiteralField)it.next();
                field.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",\n");
            }
            this.buffer.append("\n}");
        }
        return false;
    }

    public boolean visit(ObjectLiteralField node) {
        node.getFieldName().accept(this);
        this.buffer.append(" : ");
        node.getInitializer().accept(this);
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3 && node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        this.printIndent();
        this.buffer.append("package ");
        node.getName().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(ParameterizedType node) {
        node.getType().accept(this);
        this.buffer.append("<");
        Iterator it = node.typeArguments().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(">");
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.buffer.append("(");
        node.getExpression().accept(this);
        this.buffer.append(")");
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept(this);
        this.buffer.append(node.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        this.buffer.append(node.getOperator().toString());
        node.getOperand().accept(this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.buffer.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName node) {
        node.getQualifier().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(QualifiedType node) {
        node.getQualifier().accept(this);
        this.buffer.append(".");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.printIndent();
        this.buffer.append("return");
        if (node.getExpression() != null) {
            this.buffer.append(" ");
            node.getExpression().accept(this);
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(SimpleName node) {
        this.buffer.append(node.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType node) {
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.buffer.append("...");
        }
        this.buffer.append(" ");
        node.getName().accept(this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        Iterator it;
        this.printIndent();
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.buffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append("super(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(");\n");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        node.getName().accept(this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        Iterator it;
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("super.");
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.buffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        node.getName().accept(this);
        this.buffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (node.isDefault()) {
            this.buffer.append("default :\n");
        } else {
            this.buffer.append("case ");
            node.getExpression().accept(this);
            this.buffer.append(":\n");
        }
        ++this.indent;
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.buffer.append("switch (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        this.buffer.append("{\n");
        ++this.indent;
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept(this);
            --this.indent;
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(TagElement node) {
        if (node.isNested()) {
            this.buffer.append("{");
        } else {
            this.buffer.append("\n * ");
        }
        boolean previousRequiresWhiteSpace = false;
        if (node.getTagName() != null) {
            this.buffer.append(node.getTagName());
            previousRequiresWhiteSpace = true;
        }
        boolean previousRequiresNewLine = false;
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            ASTNode e = (ASTNode)it.next();
            boolean currentIncludesWhiteSpace = e instanceof TextElement;
            if (previousRequiresNewLine && currentIncludesWhiteSpace) {
                this.buffer.append("\n * ");
            }
            previousRequiresNewLine = currentIncludesWhiteSpace;
            if (previousRequiresWhiteSpace && !currentIncludesWhiteSpace) {
                this.buffer.append(" ");
            }
            e.accept(this);
            boolean bl = previousRequiresWhiteSpace = !currentIncludesWhiteSpace && !(e instanceof TagElement);
        }
        if (node.isNested()) {
            this.buffer.append("}");
        }
        return false;
    }

    public boolean visit(TextElement node) {
        this.buffer.append(node.getText());
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.buffer.append(".");
        }
        this.buffer.append("this");
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.printIndent();
        this.buffer.append("throw ");
        node.getExpression().accept(this);
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(TryStatement node) {
        this.printIndent();
        this.buffer.append("try ");
        node.getBody().accept(this);
        this.buffer.append(" ");
        Iterator it = node.catchClauses().iterator();
        while (it.hasNext()) {
            CatchClause cc = (CatchClause)it.next();
            cc.accept(this);
        }
        if (node.getFinally() != null) {
            this.buffer.append(" finally ");
            node.getFinally().accept(this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        ASTNode t;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept(this);
        }
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.buffer.append(node.isInterface() ? "interface " : "class ");
        node.getName().accept(this);
        if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
            this.buffer.append("<");
            it = node.typeParameters().iterator();
            while (it.hasNext()) {
                t = (TypeParameter)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append(">");
        }
        this.buffer.append(" ");
        if (node.getAST().apiLevel() == 2) {
            if (node.internalGetSuperclass() != null) {
                this.buffer.append("extends ");
                node.internalGetSuperclass().accept(this);
                this.buffer.append(" ");
            }
            if (!node.internalSuperInterfaces().isEmpty()) {
                this.buffer.append(node.isInterface() ? "extends " : "implements ");
                it = node.internalSuperInterfaces().iterator();
                while (it.hasNext()) {
                    Name n = (Name)it.next();
                    n.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        if (node.getAST().apiLevel() >= 3) {
            if (node.getSuperclassType() != null) {
                this.buffer.append("extends ");
                node.getSuperclassType().accept(this);
                this.buffer.append(" ");
            }
            if (!node.superInterfaceTypes().isEmpty()) {
                this.buffer.append(node.isInterface() ? "extends " : "implements ");
                it = node.superInterfaceTypes().iterator();
                while (it.hasNext()) {
                    t = (Type)it.next();
                    t.accept(this);
                    if (!it.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("{\n");
        ++this.indent;
        it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration d = (BodyDeclaration)it.next();
            d.accept(this);
        }
        --this.indent;
        this.printIndent();
        this.buffer.append("}\n");
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            node.internalGetTypeDeclaration().accept(this);
        }
        if (node.getAST().apiLevel() >= 3) {
            node.getDeclaration().accept(this);
        }
        return false;
    }

    public boolean visit(TypeLiteral node) {
        node.getType().accept(this);
        this.buffer.append(".class");
        return false;
    }

    public boolean visit(TypeParameter node) {
        node.getName().accept(this);
        if (!node.typeBounds().isEmpty()) {
            this.buffer.append(" extends ");
            Iterator it = node.typeBounds().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept(this);
                if (!it.hasNext()) continue;
                this.buffer.append(" & ");
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept(this);
        this.buffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept(this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.buffer.append("=");
            node.getInitializer().accept(this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        this.printIndent();
        if (node.getAST().apiLevel() == 2) {
            this.printModifiers(node.getModifiers());
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.buffer.append("var ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(";\n");
        return false;
    }

    public boolean visit(WildcardType node) {
        this.buffer.append("?");
        Type bound = node.getBound();
        if (bound != null) {
            if (node.isUpperBound()) {
                this.buffer.append(" extends ");
            } else {
                this.buffer.append(" super ");
            }
            bound.accept(this);
        }
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.printIndent();
        this.buffer.append("while (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }

    public boolean visit(WithStatement node) {
        this.printIndent();
        this.buffer.append("with (");
        node.getExpression().accept(this);
        this.buffer.append(") ");
        node.getBody().accept(this);
        return false;
    }
}

