/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ThisReference
extends Reference
implements IThisReference {
    public static ThisReference implicitThis() {
        ThisReference implicitThis = new ThisReference(0, 0);
        implicitThis.bits |= 4;
        return implicitThis;
    }

    public ThisReference(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        return flowInfo;
    }

    public boolean checkAccess(MethodScope methodScope) {
        if (methodScope != null && methodScope.isConstructorCall) {
            methodScope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
            return false;
        }
        if (methodScope != null && methodScope.isStatic) {
            methodScope.problemReporter().errorThisSuperInStatic(this);
            return false;
        }
        return true;
    }

    public boolean isImplicitThis() {
        return (this.bits & 4) != 0;
    }

    public boolean isThis() {
        return true;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.isImplicitThis()) {
            return output;
        }
        return output.append("this");
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (!this.isImplicitThis() && !this.checkAccess(scope.methodScope())) {
            return null;
        }
        this.resolvedType = scope.enclosingReceiverType();
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor visitor, ClassScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 103;
    }
}

