/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.ClassFileInfo;
import org.eclipse.wst.jsdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClassFile
extends Openable
implements IClassFile,
SuffixConstants,
ICompilationUnit,
IVirtualParent {
    protected String name;
    protected IPath filePath;
    protected BinaryType binaryType = null;
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IFunction[] NO_METHODS = new IFunction[0];

    protected ClassFile(PackageFragment parent, String path) {
        super(parent);
        this.filePath = Path.fromOSString((String)path);
        if (this.filePath.getFileExtension() != null) {
            String lastSegment = this.filePath.lastSegment();
            this.name = lastSegment.substring(0, lastSegment.length() - (this.filePath.getFileExtension().length() + 1));
        } else {
            this.name = path;
        }
    }

    public IJavaScriptUnit becomeWorkingCopy(IProblemRequestor problemRequestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        ClassFileWorkingCopy workingCopy;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner), false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
            operation.runOperation(monitor);
            return workingCopy;
        }
        return perWorkingCopyInfo.workingCopy;
    }

    /*
     * Exception decompiling
     */
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 330->333)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaScriptModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaScriptModelException {
        String source = this.getSource();
        if (source != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, type.sourceFileName((IBinaryType)type.getElementInfo()), this.getJavaScriptProject());
            this.codeComplete(cu, cu, offset, requestor, owner);
        }
    }

    public IJavaScriptElement[] codeSelect(int offset, int length) throws JavaScriptModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IJavaScriptElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaScriptModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            PackageFragment packageFragment = (PackageFragment)this.getParent();
            String[] names = packageFragment.names;
            char[][] pkgNames = new char[names.length][];
            int i = 0;
            while (i < names.length) {
                pkgNames[i] = names[i].toCharArray();
                ++i;
            }
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, pkgNames, this.filePath.toOSString());
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaScriptElement[0];
    }

    protected Object createElementInfo() {
        return new ClassFileInfo();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassFile)) {
            return false;
        }
        ClassFile other = (ClassFile)o;
        return this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    public boolean exists() {
        return super.exists() && this.validateClassFile().isOK();
    }

    protected IJavaScriptElement findElement(IJavaScriptElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaScriptElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaScriptElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return elt;
    }

    public IType findPrimaryType() {
        IType primaryType = this.getType();
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaScriptModelException {
        return this.getType().getAttachedJavadoc(monitor);
    }

    public byte[] getBytes() throws JavaScriptModelException {
        JavaElement cfr_ignored_0 = (JavaElement)this.getParent();
        IFile file = (IFile)this.getResource();
        return Util.getResourceContentsAsByteArray(file);
    }

    public IBuffer getBuffer() throws JavaScriptModelException {
        IStatus status = this.validateClassFile();
        if (status.isOK()) {
            return super.getBuffer();
        }
        throw new JavaScriptModelException((IJavaScriptModelStatus)status);
    }

    public IClassFile getClassFile() {
        return this;
    }

    public ITypeRoot getTypeRoot() {
        return this;
    }

    public IResource getCorrespondingResource() throws JavaScriptModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaScriptElement getElementAt(int position) throws JavaScriptModelException {
        IJavaScriptElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        return this.findElement(this, position, mapper);
    }

    public IJavaScriptElement getElementAtConsideringSibling(int position) throws JavaScriptModelException {
        IPackageFragment fragment = (IPackageFragment)this.getParent();
        PackageFragmentRoot root = (PackageFragmentRoot)fragment.getAncestor(3);
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        int index = this.name.indexOf(36);
        int prefixLength = index < 0 ? this.name.length() : index;
        IType type = null;
        int start = -1;
        int end = Integer.MAX_VALUE;
        IJavaScriptElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            int childPrefixLength;
            String childName = children[i].getElementName();
            int childIndex = childName.indexOf(36);
            int n = childPrefixLength = childIndex < 0 ? childName.indexOf(46) : childIndex;
            if (prefixLength == childPrefixLength && this.name.regionMatches(0, childName, 0, prefixLength)) {
                IClassFile classFile = (IClassFile)children[i];
                classFile.getBuffer();
                SourceRange range = mapper.getSourceRange(classFile.getType());
                if (range != SourceMapper.UNKNOWN_RANGE) {
                    int newStart = range.offset;
                    int newEnd = newStart + range.length - 1;
                    if (newStart > start && newEnd < end && newStart <= position && newEnd >= position) {
                        type = classFile.getType();
                        start = newStart;
                        end = newEnd;
                    }
                }
            }
            ++i;
        }
        if (type != null) {
            return this.findElement(type, position, mapper);
        }
        return null;
    }

    public String getElementName() {
        if (this.name != null && this.name.toUpperCase().endsWith(".js".toUpperCase())) {
            return this.name;
        }
        return String.valueOf(this.name) + ".js";
    }

    public int getElementType() {
        return 6;
    }

    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '(';
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getPath().toPortableString());
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        Object me = JavaModel.getTarget((IContainer)workspace.getRoot(), this.getPath(), true);
        if (me != null) {
            return true;
        }
        me = JavaModel.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true);
        return me != null;
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive() || root instanceof LibraryFragmentRoot && root.getPath().lastSegment().equalsIgnoreCase(this.getElementName())) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!root.isResourceContainer()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public String getSource() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    public String getTopLevelTypeName() {
        String topLevelTypeName = this.getElementName();
        int firstDollar = topLevelTypeName.indexOf(36);
        topLevelTypeName = firstDollar != -1 ? topLevelTypeName.substring(0, firstDollar) : topLevelTypeName.substring(0, topLevelTypeName.length() - SUFFIX_JAVA.length);
        return topLevelTypeName;
    }

    public IType getType() {
        if (this.binaryType == null) {
            this.binaryType = new BinaryType(this, this.getTypeName());
        }
        return this.binaryType;
    }

    public String getTypeName() {
        int lastDollar = this.name.lastIndexOf(36);
        return lastDollar > -1 ? Util.localTypeName(this.name, lastDollar, this.name.length()) : this.name;
    }

    public IJavaScriptUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public int hashCode() {
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    public boolean isClass() throws JavaScriptModelException {
        return this.getType().isClass();
    }

    public boolean isInterface() throws JavaScriptModelException {
        return this.getType().isInterface();
    }

    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaScriptModelException e) {
            return e.getJavaScriptModelStatus();
        }
        IJavaScriptProject project = this.getJavaScriptProject();
        return JavaScriptConventions.validateClassFileName(this.getElementName(), project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true));
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaScriptModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper, info instanceof IBinaryType ? (IBinaryType)info : null);
        }
        return null;
    }

    private IBuffer mapSource(SourceMapper mapper, IBinaryType info) {
        char[] contents = null;
        try {
            contents = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(new File(this.filePath.toOSString()), null);
        }
        catch (IOException iOException) {}
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            return buffer;
        }
        IBuffer buffer = BufferManager.createNullBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    static String simpleName(char[] className) {
        if (className == null) {
            return null;
        }
        String simpleName = new String(ClassFile.unqualifiedName(className));
        int lastDollar = simpleName.lastIndexOf(36);
        if (lastDollar != -1) {
            return Util.localTypeName(simpleName, lastDollar, simpleName.length());
        }
        return simpleName;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        int i = 0;
        while (i < nameLength) {
            newName[i] = name[i] == '/' ? 46 : name[i];
            ++i;
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        int i = 0;
        while (i < length) {
            newNames[i] = ClassFile.translatedName(names[i]);
            ++i;
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        int i = className.length - 1;
        while (i > -1) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public IFunction[] getMethods() throws JavaScriptModelException {
        return this.getFunctions();
    }

    public IFunction[] getFunctions() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IFunction[] array = new IFunction[size];
        list.toArray(array);
        return array;
    }

    public IType[] getTypes() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public char[] getContents() {
        char[] chars = null;
        try {
            chars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(new File(this.filePath.toOSString()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chars;
    }

    public char[] getMainTypeName() {
        return this.name.toCharArray();
    }

    public char[][] getPackageName() {
        return new char[][]{this.getParent().getElementName().toCharArray()};
    }

    public char[] getFileName() {
        return this.filePath != null ? this.filePath.toString().toCharArray() : this.getElementName().toCharArray();
    }

    public String getDisplayName() {
        if (this.isVirtual()) {
            JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
            if (init == null) {
                return super.getDisplayName();
            }
            return init.getDescription((IPath)new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return super.getDisplayName();
    }

    public URI getHostPath() {
        JsGlobalScopeContainerInitializer init;
        if (this.isVirtual() && (init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer()) != null) {
            return init.getHostPath((IPath)new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return null;
    }

    public LibrarySuperType getCommonSuperType() {
        return null;
    }

    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
        return init;
    }

    public String getInferenceID() {
        JsGlobalScopeContainerInitializer containerInitializer = this.getContainerInitializer();
        if (containerInitializer != null) {
            return containerInitializer.getInferenceID();
        }
        return null;
    }

    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        SearchableEnvironment env = super.newSearchableNameEnvironment(owner);
        env.setCompilationUnit(this);
        return env;
    }
}

