/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataReader;
import org.eclipse.wst.jsdt.internal.oaametadata.MetadataSourceElementNotifier;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        block8: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.parser;
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaScriptCore.create(project), requestor);
            } else {
                parser.requestor = requestor;
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            String pkgName = ((JavaSearchDocument)this.document).getPackageName();
            Object packageName = null;
            if (pkgName != null) {
                packageName = new char[1][];
                packageName[0] = pkgName.toCharArray();
            }
            BasicCompilationUnit compilationUnit = new BasicCompilationUnit(source, (char[][])packageName, new String(name));
            try {
                parser.parseCompilationUnit(compilationUnit, true);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block8;
                e.printStackTrace();
            }
        }
    }

    public void indexMetadata() {
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
        String documentPath = this.document.getPath();
        char[] source = null;
        char[] name = null;
        try {
            source = this.document.getCharContents();
            name = documentPath.toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        String pkgName = ((JavaSearchDocument)this.document).getPackageName();
        Object packageName = null;
        if (pkgName != null) {
            packageName = new char[1][];
            packageName[0] = pkgName.toCharArray();
        }
        LibraryAPIs apis = MetadataReader.readAPIsFromString(new String(source));
        new MetadataSourceElementNotifier(apis, requestor).notifyRequestor();
    }
}

