/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.oaametadata;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.Ancestor;
import org.eclipse.wst.jsdt.internal.oaametadata.ClassData;
import org.eclipse.wst.jsdt.internal.oaametadata.DocumentedElement;
import org.eclipse.wst.jsdt.internal.oaametadata.Event;
import org.eclipse.wst.jsdt.internal.oaametadata.Exception;
import org.eclipse.wst.jsdt.internal.oaametadata.IOAAMetaDataConstants;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;
import org.eclipse.wst.jsdt.internal.oaametadata.Method;
import org.eclipse.wst.jsdt.internal.oaametadata.Mix;
import org.eclipse.wst.jsdt.internal.oaametadata.Parameter;
import org.eclipse.wst.jsdt.internal.oaametadata.Property;
import org.eclipse.wst.jsdt.internal.oaametadata.ReturnsData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataReader
extends DefaultHandler
implements IOAAMetaDataConstants {
    LibraryAPIs apis = new LibraryAPIs();
    Stack stack = new Stack();
    HashMap states = new HashMap();
    boolean collectText = false;
    boolean pendingEndElement = false;
    String collectTextElement;
    int currentState = 1;
    Object currentObject;
    StringBuffer text = new StringBuffer();
    HashMap collections;
    static final int STATE_API = 1;
    static final int STATE_CLASS = 3;
    static final int STATE_GLOBALS = 3;
    static final int STATE_METHOD = 4;
    static final int STATE_PROPERTY = 5;
    static final int STATE_PROPERTIES = 6;
    static final int STATE_ALAIS = 7;
    static final int STATE_ALAISES = 8;
    static final int STATE_ANCESTOR = 9;
    static final int STATE_ANCESTORS = 10;
    static final int STATE_AUTHOR = 11;
    static final int STATE_AUTHORS = 12;
    static final int STATE_CONSTRUCTOR = 13;
    static final int STATE_CONSTRUCTORS = 14;
    static final int STATE_DEPRECIATED = 15;
    static final int STATE_DESCRIPTION = 16;
    static final int STATE_EVENT = 17;
    static final int STATE_EVENTS = 18;
    static final int STATE_EXAMPLE = 19;
    static final int STATE_EXAMPLES = 20;
    static final int STATE_EXCEPTION = 21;
    static final int STATE_EXCEPTIONS = 22;
    static final int STATE_FIELD = 23;
    static final int STATE_FIELDS = 24;
    static final int STATE_INTERFACE = 26;
    static final int STATE_INTERFACES = 27;
    static final int STATE_METHODS = 29;
    static final int STATE_MIX = 30;
    static final int STATE_MIXES = 31;
    static final int STATE_MIXIN = 32;
    static final int STATE_MIXINS = 33;
    static final int STATE_NAMESPACE = 34;
    static final int STATE_OPTION = 35;
    static final int STATE_OPTIONS = 36;
    static final int STATE_PARAMETER = 37;
    static final int STATE_PARAMETERS = 38;
    static final int STATE_REMARKS = 41;
    static final int STATE_RETURNS = 42;
    static final int STATE_SEE = 43;
    static final int STATE_TOPIC = 44;
    static final int STATE_TOPICS = 45;
    static final int STATE_USERAGENT = 46;
    static final int STATE_USERAGENTS = 47;
    static final ArrayList EMPTY_LIST = new ArrayList();

    public MetadataReader() {
        this.states.put("api", new Integer(1));
        this.states.put("class", new Integer(3));
        this.states.put("globals", new Integer(3));
        this.states.put("method", new Integer(4));
        this.states.put("property", new Integer(5));
        this.states.put("properties", new Integer(6));
        this.states.put("alias", new Integer(7));
        this.states.put("aliases", new Integer(8));
        this.states.put("ancestors", new Integer(10));
        this.states.put("ancestor", new Integer(9));
        this.states.put("authors", new Integer(12));
        this.states.put("author", new Integer(11));
        this.states.put("constructors", new Integer(14));
        this.states.put("constructor", new Integer(13));
        this.states.put("deprecated", new Integer(15));
        this.states.put("description", new Integer(16));
        this.states.put("event", new Integer(17));
        this.states.put("events", new Integer(18));
        this.states.put("example", new Integer(19));
        this.states.put("examples", new Integer(20));
        this.states.put("exception", new Integer(21));
        this.states.put("exceptions", new Integer(22));
        this.states.put("field", new Integer(23));
        this.states.put("fields", new Integer(24));
        this.states.put("interface", new Integer(26));
        this.states.put("interfaces", new Integer(27));
        this.states.put("methods", new Integer(29));
        this.states.put("mix", new Integer(30));
        this.states.put("mixes", new Integer(31));
        this.states.put("mixin", new Integer(32));
        this.states.put("mixins", new Integer(33));
        this.states.put("namespace", new Integer(34));
        this.states.put("option", new Integer(35));
        this.states.put("options", new Integer(36));
        this.states.put("parameter", new Integer(37));
        this.states.put("parameters", new Integer(38));
        this.states.put("remarks", new Integer(41));
        this.states.put("returns", new Integer(42));
        this.states.put("see", new Integer(43));
        this.states.put("topic", new Integer(44));
        this.states.put("topics", new Integer(45));
        this.states.put("useragent", new Integer(46));
        this.states.put("useragents", new Integer(47));
    }

    public static LibraryAPIs readAPIsFromStream(InputSource inputSource) {
        MetadataReader handler = new MetadataReader();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            Util.log(e, "error reading oaametadata");
        }
        catch (IOException e) {
            Util.log(e, "error reading oaametadata");
        }
        catch (ParserConfigurationException e) {
            Util.log(e, "error reading oaametadata");
        }
        return handler.apis;
    }

    public static LibraryAPIs readAPIsFromString(String metadata) {
        return MetadataReader.readAPIsFromStream(new InputSource(new StringReader(metadata)));
    }

    public static LibraryAPIs readAPIsFromFile(String fileName) {
        try {
            FileInputStream file = new FileInputStream(fileName);
            LibraryAPIs apis = MetadataReader.readAPIsFromStream(new InputSource(file));
            apis.fileName = fileName;
            return apis;
        }
        catch (FileNotFoundException e) {
            Util.log(e, "error reading oaametadata");
            return null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectText) {
            if (this.pendingEndElement) {
                this.text.append("/>");
                this.pendingEndElement = false;
            }
            this.text.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.collectText) {
            if ("http://ns.openajax.org/api".equals(uri) && localName.equals(this.collectTextElement)) {
                switch (this.currentState) {
                    case 16: {
                        if (!(this.currentObject instanceof DocumentedElement)) break;
                        ((DocumentedElement)this.currentObject).description = this.text.toString();
                    }
                }
                this.popState();
                this.collectText = false;
                this.collectTextElement = null;
                this.text = new StringBuffer();
            } else if (this.pendingEndElement) {
                this.text.append("/>");
            } else {
                this.text.append("</").append(localName).append(">");
            }
            this.pendingEndElement = false;
        } else {
            switch (this.currentState) {
                case 1: {
                    ArrayList collection = this.getCollection("class");
                    this.apis.classes = collection.toArray(new ClassData[collection.size()]);
                    collection = this.getCollection("method");
                    this.apis.globalMethods = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("property");
                    this.apis.globalVars = collection.toArray(new Property[collection.size()]);
                    collection = this.getCollection("author");
                    this.apis.authors = collection.toArray(new String[collection.size()]);
                    break;
                }
                case 3: {
                    ClassData clazz = (ClassData)this.currentObject;
                    ArrayList collection = this.getCollection("ancestor");
                    clazz.ancestors = collection.toArray(new Ancestor[collection.size()]);
                    collection = this.getCollection("constructor");
                    clazz.constructors = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("event");
                    clazz.events = collection.toArray(new Event[collection.size()]);
                    collection = this.getCollection("property");
                    clazz.fields = collection.toArray(new Property[collection.size()]);
                    collection = this.getCollection("method");
                    clazz.methods = collection.toArray(new Method[collection.size()]);
                    collection = this.getCollection("author");
                    clazz.mixes = collection.toArray(new Mix[collection.size()]);
                    break;
                }
                case 4: 
                case 13: {
                    Method method = (Method)this.currentObject;
                    ArrayList collection = this.getCollection("exception");
                    method.exceptions = collection.toArray(new Exception[collection.size()]);
                    collection = this.getCollection("parameter");
                    method.parameters = collection.toArray(new Parameter[collection.size()]);
                }
            }
            this.popState();
        }
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.collectText) {
            this.text.append("<").append(localName);
            int nAttributes = attributes.getLength();
            int i = 0;
            while (i < nAttributes) {
                String qname = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.text.append(" ").append(qname).append("=\"").append(value).append("\"");
                ++i;
            }
            this.pendingEndElement = true;
        } else {
            Integer stateObj = null;
            if ("http://ns.openajax.org/api".equals(uri)) {
                this.pushState();
                stateObj = (Integer)this.states.get(localName);
                if (stateObj != null) {
                    int state = stateObj;
                    switch (state) {
                        case 1: {
                            this.apis.version = attributes.getValue("version");
                            this.apis.language = attributes.getValue("language");
                            this.apis.getterPattern = attributes.getValue("getterPattern");
                            this.apis.setterPattern = attributes.getValue("setterPattern");
                            this.collections = new HashMap();
                            break;
                        }
                        case 3: {
                            ClassData clazz = new ClassData();
                            this.currentObject = clazz;
                            this.addCollectionElement("class", clazz);
                            clazz.name = attributes.getValue("name");
                            clazz.type = attributes.getValue("type");
                            clazz.superclass = attributes.getValue("superclass");
                            clazz.visibility = attributes.getValue("visibility");
                            this.collections = new HashMap();
                            break;
                        }
                        case 4: {
                            Method method = new Method();
                            this.currentObject = method;
                            this.addCollectionElement("method", method);
                            method.name = attributes.getValue("name");
                            method.scope = attributes.getValue("scope");
                            this.collections = new HashMap();
                            break;
                        }
                        case 13: {
                            Method method = new Method();
                            this.currentObject = method;
                            this.addCollectionElement("constructor", method);
                            method.scope = attributes.getValue("scope");
                            method.visibility = attributes.getValue("visibility");
                            this.collections = new HashMap();
                            break;
                        }
                        case 37: {
                            Parameter parameter = new Parameter();
                            this.currentObject = parameter;
                            this.addCollectionElement("parameter", parameter);
                            parameter.name = attributes.getValue("name");
                            parameter.type = attributes.getValue("type");
                            parameter.usage = attributes.getValue("usage");
                            this.collections = new HashMap();
                            break;
                        }
                        case 5: 
                        case 23: {
                            Property property = new Property();
                            this.currentObject = property;
                            property.isField = 23 == state;
                            this.addCollectionElement("property", property);
                            property.name = attributes.getValue("name");
                            property.type = attributes.getValue("type");
                            property.usage = attributes.getValue("usage");
                            this.collections = new HashMap();
                            break;
                        }
                        case 42: {
                            ReturnsData returnData = new ReturnsData();
                            if (this.currentObject instanceof Method) {
                                ((Method)this.currentObject).returns = returnData;
                            }
                            this.currentObject = returnData;
                            returnData.type = attributes.getValue("type");
                            break;
                        }
                        case 16: {
                            this.startCollectingText(localName);
                        }
                    }
                    this.currentState = state;
                }
            }
        }
    }

    private void startCollectingText(String localName) {
        this.collectText = true;
        this.collectTextElement = localName;
        this.text = new StringBuffer();
    }

    private void addCollectionElement(String tagClass, Object element) {
        ArrayList<Object> list;
        if (this.collections == null) {
            this.collections = new HashMap();
        }
        if ((list = (ArrayList<Object>)this.collections.get(tagClass)) == null) {
            list = new ArrayList<Object>();
            this.collections.put(tagClass, list);
        }
        list.add(element);
    }

    private ArrayList getCollection(String tagClass) {
        ArrayList list = (ArrayList)this.collections.get(tagClass);
        if (list == null) {
            list = EMPTY_LIST;
        }
        return list;
    }

    private void popState() {
        StackElement stackElement = (StackElement)this.stack.pop();
        this.currentState = stackElement.state;
        this.collections = stackElement.collections;
        this.currentObject = stackElement.currentObject;
    }

    private void pushState() {
        StackElement newElement = new StackElement(this.currentState, this.currentObject, this.collections);
        this.stack.push(newElement);
    }

    static class StackElement {
        HashMap collections;
        Object currentObject;
        int state;

        StackElement(int st, Object obj, HashMap map) {
            this.collections = map;
            this.currentObject = obj;
            this.state = st;
        }
    }
}

