/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;

public class InitialSelectionProvider
extends ViewerSorter {
    public Object getInitialSelection(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return null;
        }
        if (obj[0] instanceof IRuntimeType) {
            int size = obj.length;
            IRuntimeType[] rt = new IRuntimeType[size];
            int i = 0;
            while (i < size) {
                rt[i] = (IRuntimeType)obj[i];
                ++i;
            }
            return this.getInitialSelection(rt);
        }
        if (obj[0] instanceof IServerType) {
            int size = obj.length;
            IServerType[] st = new IServerType[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServerType)obj[i];
                ++i;
            }
            return this.getInitialSelection(st);
        }
        if (obj[0] instanceof IServer) {
            int size = obj.length;
            IServer[] st = new IServer[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServer)obj[i];
                ++i;
            }
            return this.getInitialSelection(st);
        }
        return null;
    }

    public IServerType getInitialSelection(IServerType[] serverTypes) {
        if (serverTypes == null) {
            return null;
        }
        int size = serverTypes.length;
        int i = 0;
        while (i < size) {
            if (this.hasRuntime(serverTypes[i])) {
                return serverTypes[i];
            }
            ++i;
        }
        return this.getDefaultServerType(serverTypes);
    }

    public IServer getInitialSelection(IServer[] servers) {
        if (servers == null) {
            return null;
        }
        return servers[0];
    }

    public IRuntimeType getInitialSelection(IRuntimeType[] runtimeTypes) {
        if (runtimeTypes == null) {
            return null;
        }
        int size = runtimeTypes.length;
        int i = 0;
        while (i < size) {
            if (this.hasRuntime(runtimeTypes[i])) {
                return runtimeTypes[i];
            }
            ++i;
        }
        return this.getDefaultRuntimeType(runtimeTypes);
    }

    protected boolean hasRuntime(IServerType serverType) {
        return this.hasRuntime(serverType.getRuntimeType());
    }

    protected boolean hasRuntime(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        IRuntime[] runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        return runtimes != null && runtimes.length > 0;
    }

    protected IServerType getDefaultServerType(IServerType[] serverTypes) {
        if (serverTypes == null) {
            return null;
        }
        int size = serverTypes.length;
        if (size == 1) {
            return serverTypes[0];
        }
        IServerType first = serverTypes[0];
        int i = 1;
        while (i < size) {
            if (DefaultViewerSorter.compareServerTypes(first, serverTypes[i]) > 0) {
                first = serverTypes[i];
            }
            ++i;
        }
        return first;
    }

    protected IRuntimeType getDefaultRuntimeType(IRuntimeType[] runtimeTypes) {
        if (runtimeTypes == null) {
            return null;
        }
        int size = runtimeTypes.length;
        if (size == 1) {
            return runtimeTypes[0];
        }
        IRuntimeType first = runtimeTypes[0];
        int i = 1;
        while (i < size) {
            if (DefaultViewerSorter.compareRuntimeTypes(first, runtimeTypes[i]) > 0) {
                first = runtimeTypes[i];
            }
            ++i;
        }
        return first;
    }
}

