/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.formatter;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormattingConstraints;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormattingPreferences;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXMLPartitionFormatter {
    private static final String PRESERVE = "preserve";
    private static final String PRESERVE_QUOTED = "\"preserve\"";
    private static final String XML_SPACE = "xml:space";
    private static final String XSL_NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    private static final String XSL_ATTRIBUTE = "attribute";
    private static final String XSL_TEXT = "text";
    private static final String SPACE = " ";
    private static final String STRING = "string";
    private XMLFormattingPreferences fPreferences = null;
    private IProgressMonitor fProgressMonitor;
    static /* synthetic */ Class class$0;

    private int collapseSpaces(TextEdit textEdit, int spaceStartOffset, int availableLineWidth, String whitespaceRun) {
        DeleteEdit deleteEdit;
        int existingWhitespaceOffset = whitespaceRun.indexOf(32);
        if (existingWhitespaceOffset > -1) {
            if (existingWhitespaceOffset > 0) {
                deleteEdit = new DeleteEdit(spaceStartOffset, existingWhitespaceOffset);
                textEdit.addChild((TextEdit)deleteEdit);
            }
            if (existingWhitespaceOffset < whitespaceRun.length() - 1) {
                int nextOffset = existingWhitespaceOffset + 1;
                DeleteEdit deleteEdit2 = new DeleteEdit(spaceStartOffset + nextOffset, whitespaceRun.length() - nextOffset);
                textEdit.addChild((TextEdit)deleteEdit2);
            }
        } else {
            deleteEdit = new DeleteEdit(spaceStartOffset, whitespaceRun.length());
            textEdit.addChild((TextEdit)deleteEdit);
            InsertEdit insertEdit = new InsertEdit(spaceStartOffset, SPACE);
            textEdit.addChild((TextEdit)insertEdit);
        }
        return --availableLineWidth;
    }

    private void deleteTrailingSpaces(TextEdit textEdit, ITextRegion currentTextRegion, IStructuredDocumentRegion currentDocumentRegion) {
        int textEnd = currentTextRegion.getTextEnd();
        int textEndOffset = currentDocumentRegion.getStartOffset() + textEnd;
        int difference = currentTextRegion.getEnd() - textEnd;
        DeleteEdit deleteEdit = new DeleteEdit(textEndOffset, difference);
        textEdit.addChild((TextEdit)deleteEdit);
    }

    public TextEdit format(IDocument document, int start, int length) {
        return this.format(document, start, length, new XMLFormattingPreferences());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextEdit format(IDocument document, int start, int length, XMLFormattingPreferences preferences) {
        TextEdit edit = null;
        if (!(document instanceof IStructuredDocument)) return edit;
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
        if (model == null) return edit;
        try {
            edit = this.format(model, start, length, preferences);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        model.releaseFromEdit();
        return edit;
    }

    public TextEdit format(IStructuredModel model, int start, int length) {
        return this.format(model, start, length, new XMLFormattingPreferences());
    }

    public TextEdit format(IStructuredModel model, int start, int length, XMLFormattingPreferences preferences) {
        int startOffset;
        IndexedRegion currentIndexedRegion;
        this.setFormattingPreferences(preferences);
        MultiTextEdit edit = new MultiTextEdit();
        IStructuredDocument document = model.getStructuredDocument();
        IStructuredDocumentRegion currentRegion = document.getRegionAtCharacterOffset(start);
        if (currentRegion != null && (currentIndexedRegion = model.getIndexedRegion(startOffset = currentRegion.getStartOffset())) instanceof IDOMNode) {
            IDOMNode currentDOMNode = (IDOMNode)currentIndexedRegion;
            DOMRegion domRegion = new DOMRegion();
            domRegion.documentRegion = currentRegion;
            domRegion.domNode = currentDOMNode;
            XMLFormattingConstraints parentConstraints = this.getRegionConstraints(currentDOMNode);
            if (parentConstraints.getWhitespaceStrategy() == "DEFAULT") {
                parentConstraints.setWhitespaceStrategy(preferences.getElementWhitespaceStrategy());
            }
            int lineWidth = this.getFormattingPreferences().getMaxLineWidth();
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(startOffset);
                lineWidth -= startOffset - lineInfo.getOffset();
            }
            catch (BadLocationException e) {
                Logger.log(202, e.getMessage(), e);
            }
            parentConstraints.setAvailableLineWidth(lineWidth);
            Position formatRange = new Position(start, length);
            this.formatSiblings((TextEdit)edit, domRegion, parentConstraints, formatRange);
        }
        return edit;
    }

    private XMLFormattingConstraints getRegionConstraints(IDOMNode currentNode) {
        IDOMNode iterator = currentNode;
        XMLFormattingConstraints result = new XMLFormattingConstraints();
        DOMRegion region = new DOMRegion();
        XMLFormattingConstraints parentConstraints = new XMLFormattingConstraints();
        boolean parent = true;
        while (iterator != null && iterator.getNodeType() != 9) {
            region.domNode = iterator = (IDOMNode)iterator.getParentNode();
            region.documentRegion = iterator.getFirstStructuredDocumentRegion();
            this.updateFormattingConstraints(null, null, result, region);
            if (parent) {
                parentConstraints.copyConstraints(result);
                parent = false;
            }
            if ("PRESERVE" != result.getWhitespaceStrategy() && "DEFAULT" != result.getWhitespaceStrategy()) continue;
            return result;
        }
        return parentConstraints;
    }

    private void formatContent(TextEdit textEdit, Position formatRange, XMLFormattingConstraints parentConstraints, DOMRegion currentDOMRegion, IStructuredDocumentRegion previousRegion) {
        String previouRegionType;
        IStructuredDocumentRegion currentRegion = currentDOMRegion.documentRegion;
        String fullText = currentRegion.getFullText();
        String whitespaceMode = parentConstraints.getWhitespaceStrategy();
        if (whitespaceMode == "PRESERVE") {
            int availableLineWidth = parentConstraints.getAvailableLineWidth();
            availableLineWidth = this.updateLineWidthWithLastLine(fullText, availableLineWidth);
            parentConstraints.setAvailableLineWidth(availableLineWidth);
            return;
        }
        boolean isAllWhitespace = ((IDOMText)currentDOMRegion.domNode).isElementContentWhitespace();
        IStructuredDocumentRegion nextDocumentRegion = null;
        if (isAllWhitespace) {
            parentConstraints.setAvailableLineWidth(this.fPreferences.getMaxLineWidth());
            nextDocumentRegion = currentRegion.getNext();
            if (nextDocumentRegion != null) {
                return;
            }
        }
        if (whitespaceMode != "COLLAPSE" && previousRegion != null && ((previouRegionType = previousRegion.getType()) == "XML_ENTITY_REFERENCE" || previouRegionType == "XML_CDATA_TEXT")) {
            whitespaceMode = "COLLAPSE";
        }
        if (whitespaceMode != "COLLAPSE") {
            String nextRegionType;
            if (nextDocumentRegion == null) {
                nextDocumentRegion = currentRegion.getNext();
            }
            if (nextDocumentRegion != null && ((nextRegionType = nextDocumentRegion.getType()) == "XML_ENTITY_REFERENCE" || nextRegionType == "XML_CDATA_TEXT")) {
                whitespaceMode = "COLLAPSE";
            }
        }
        this.formatTextInContent(textEdit, parentConstraints, currentRegion, fullText, whitespaceMode);
    }

    private void formatEmptyStartTagWithNoAttr(TextEdit textEdit, XMLFormattingConstraints constraints, IStructuredDocumentRegion currentDocumentRegion, IStructuredDocumentRegion previousDocumentRegion, int availableLineWidth, String indentStrategy, String whitespaceStrategy, ITextRegion currentTextRegion) {
        int regionLength;
        int textLength;
        boolean thereAreSpaces;
        boolean oneSpaceInTagName = this.getFormattingPreferences().getSpaceBeforeEmptyCloseTag();
        int tagNameLineWidth = currentTextRegion.getTextLength() + 3;
        if (oneSpaceInTagName) {
            ++tagNameLineWidth;
        }
        availableLineWidth -= tagNameLineWidth;
        if (indentStrategy == "INLINE") {
            if (availableLineWidth < 0) {
                int lineWidth = this.indentIfPossible(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, whitespaceStrategy, indentStrategy, true);
                availableLineWidth = lineWidth > 0 ? lineWidth - tagNameLineWidth : (availableLineWidth -= tagNameLineWidth);
            } else if (previousDocumentRegion.getType() == "XML_CONTENT" && previousDocumentRegion.getFullText().trim().length() == 0) {
                availableLineWidth = this.collapseSpaces(textEdit, previousDocumentRegion.getStartOffset(), availableLineWidth, previousDocumentRegion.getFullText());
            }
        }
        boolean bl = thereAreSpaces = (textLength = currentTextRegion.getTextLength()) < (regionLength = currentTextRegion.getLength());
        if (!oneSpaceInTagName && thereAreSpaces) {
            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
        } else if (oneSpaceInTagName) {
            this.insertSpaceAndCollapse(textEdit, currentDocumentRegion, availableLineWidth, currentTextRegion);
        }
        constraints.setAvailableLineWidth(availableLineWidth);
    }

    private void formatEndTag(TextEdit textEdit, Position formatRange, XMLFormattingConstraints constraints, DOMRegion currentDOMRegion, IStructuredDocumentRegion previousDocumentRegion) {
        IStructuredDocumentRegion currentDocumentRegion = currentDOMRegion.documentRegion;
        String whitespaceStrategy = constraints.getWhitespaceStrategy();
        String indentStrategy = constraints.getIndentStrategy();
        if (whitespaceStrategy != "PRESERVE" && (indentStrategy == "INDENT" || indentStrategy == "NEW_LINE")) {
            int availableLineWidth = this.indentIfPossible(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, whitespaceStrategy, indentStrategy, false);
            constraints.setAvailableLineWidth(availableLineWidth);
        }
        this.formatWithinEndTag(textEdit, constraints, currentDocumentRegion, previousDocumentRegion);
    }

    private DOMRegion formatRegion(TextEdit edit, Position formatRange, XMLFormattingConstraints parentConstraints, DOMRegion domRegion, IStructuredDocumentRegion previousRegion) {
        IStructuredDocumentRegion currentRegion = domRegion.documentRegion;
        String regionType = currentRegion.getType();
        if (regionType == "XML_TAG_NAME") {
            ITextRegion textRegion = currentRegion.getFirstRegion();
            String textRegionType = textRegion.getType();
            if (textRegionType == "XML_TAG_OPEN") {
                domRegion = this.formatStartTag(edit, formatRange, parentConstraints, domRegion, previousRegion);
            } else if (textRegionType == "XML_END_TAG_OPEN") {
                this.formatEndTag(edit, formatRange, parentConstraints, domRegion, previousRegion);
            }
        } else if (regionType == "XML_CONTENT") {
            this.formatContent(edit, formatRange, parentConstraints, domRegion, previousRegion);
        } else if (regionType == "XML_COMMENT_TEXT") {
            this.formatComment(edit, formatRange, parentConstraints, domRegion, previousRegion);
        } else {
            String fullText = currentRegion.getFullText();
            int width = this.updateLineWidthWithLastLine(fullText, parentConstraints.getAvailableLineWidth());
            parentConstraints.setAvailableLineWidth(width);
        }
        return domRegion;
    }

    private void formatSiblings(TextEdit edit, DOMRegion domRegion, XMLFormattingConstraints parentConstraints, Position formatRange) {
        IStructuredDocumentRegion previousRegion = null;
        IStructuredDocumentRegion currentRegion = domRegion.documentRegion;
        IDOMNode currentDOMNode = domRegion.domNode;
        while (currentDOMNode != null && currentRegion != null && formatRange.overlapsWith(currentRegion.getStartOffset(), currentRegion.getLength()) && (this.fProgressMonitor == null || !this.fProgressMonitor.isCanceled())) {
            domRegion.documentRegion = currentRegion;
            domRegion.domNode = currentDOMNode;
            if (currentRegion == currentDOMNode.getFirstStructuredDocumentRegion()) {
                domRegion = this.formatRegion(edit, formatRange, parentConstraints, domRegion, previousRegion);
            }
            previousRegion = domRegion.documentRegion;
            currentDOMNode = domRegion.domNode != null ? (IDOMNode)domRegion.domNode.getNextSibling() : null;
            currentRegion = previousRegion.getNext();
        }
    }

    private DOMRegion formatStartTag(TextEdit textEdit, Position formatRange, XMLFormattingConstraints parentConstraints, DOMRegion currentDOMRegion, IStructuredDocumentRegion previousDocumentRegion) {
        boolean tagEnded;
        IStructuredDocumentRegion currentDocumentRegion = currentDOMRegion.documentRegion;
        IDOMNode currentDOMNode = currentDOMRegion.domNode;
        XMLFormattingConstraints thisConstraints = new XMLFormattingConstraints();
        XMLFormattingConstraints childrenConstraints = new XMLFormattingConstraints();
        this.updateFormattingConstraints(parentConstraints, thisConstraints, childrenConstraints, currentDOMRegion);
        if (childrenConstraints.getWhitespaceStrategy() == "DEFAULT") {
            childrenConstraints.setWhitespaceStrategy(new XMLFormattingPreferences().getElementWhitespaceStrategy());
        }
        String whitespaceStrategy = thisConstraints.getWhitespaceStrategy();
        String indentStrategy = thisConstraints.getIndentStrategy();
        int availableLineWidth = thisConstraints.getAvailableLineWidth();
        if (whitespaceStrategy != "PRESERVE" && (indentStrategy == "INDENT" || indentStrategy == "NEW_LINE") && (availableLineWidth = this.indentIfPossible(textEdit, thisConstraints, currentDocumentRegion, previousDocumentRegion, whitespaceStrategy, indentStrategy, true)) > 0) {
            thisConstraints.setAvailableLineWidth(availableLineWidth);
        }
        if (!(tagEnded = this.formatWithinTag(textEdit, thisConstraints, currentDocumentRegion, previousDocumentRegion))) {
            childrenConstraints.setIndentLevel(thisConstraints.getIndentLevel());
            childrenConstraints.setAvailableLineWidth(thisConstraints.getAvailableLineWidth());
            previousDocumentRegion = currentDocumentRegion;
            IDOMNode childDOMNode = (IDOMNode)currentDOMNode.getFirstChild();
            IStructuredDocumentRegion nextRegion = currentDocumentRegion.getNext();
            boolean passedFormatRange = false;
            if (childDOMNode != null && nextRegion != null) {
                while (!(childDOMNode == null || nextRegion == null || passedFormatRange || this.fProgressMonitor != null && this.fProgressMonitor.isCanceled())) {
                    DOMRegion childDOMRegion = new DOMRegion();
                    childDOMRegion.documentRegion = nextRegion;
                    childDOMRegion.domNode = childDOMNode;
                    if (nextRegion == childDOMNode.getFirstStructuredDocumentRegion()) {
                        childDOMRegion = this.formatRegion(textEdit, formatRange, childrenConstraints, childDOMRegion, previousDocumentRegion);
                    }
                    childDOMNode = childDOMRegion.domNode != null ? (IDOMNode)childDOMRegion.domNode.getNextSibling() : null;
                    previousDocumentRegion = childDOMRegion.documentRegion;
                    nextRegion = previousDocumentRegion.getNext();
                    if (nextRegion == null) continue;
                    boolean bl = passedFormatRange = !formatRange.overlapsWith(nextRegion.getStartOffset(), nextRegion.getLength());
                }
            } else {
                childrenConstraints.setWhitespaceStrategy("COLLAPSE");
                childrenConstraints.setIndentStrategy("INLINE");
            }
            if (!passedFormatRange) {
                String tagName;
                ITextRegion r;
                ITextRegionList rs;
                currentDOMRegion.documentRegion = nextRegion;
                currentDOMRegion.domNode = currentDOMNode;
                childrenConstraints.setIndentLevel(thisConstraints.getIndentLevel());
                boolean formatEndTag = false;
                if (nextRegion != null && currentDOMNode != null && (rs = nextRegion.getRegions()).size() > 1 && (r = rs.get(0)) != null && r.getType() == "XML_END_TAG_OPEN" && (r = rs.get(1)) != null && r.getType() == "XML_TAG_NAME" && (tagName = nextRegion.getText(r)) != null && tagName.equals(currentDOMNode.getNodeName())) {
                    formatEndTag = true;
                }
                if (formatEndTag) {
                    this.formatEndTag(textEdit, formatRange, childrenConstraints, currentDOMRegion, previousDocumentRegion);
                } else {
                    currentDOMRegion.documentRegion = previousDocumentRegion;
                }
            } else {
                currentDOMRegion.documentRegion = nextRegion;
                currentDOMRegion.domNode = childDOMNode;
            }
            parentConstraints.setAvailableLineWidth(childrenConstraints.getAvailableLineWidth());
        } else {
            parentConstraints.setAvailableLineWidth(thisConstraints.getAvailableLineWidth());
        }
        return currentDOMRegion;
    }

    private void formatStartTagWithNoAttr(TextEdit textEdit, XMLFormattingConstraints constraints, IStructuredDocumentRegion currentDocumentRegion, IStructuredDocumentRegion previousDocumentRegion, int availableLineWidth, String indentStrategy, String whitespaceStrategy, ITextRegion currentTextRegion) {
        int tagNameLineWidth = currentTextRegion.getTextLength() + 2;
        availableLineWidth -= tagNameLineWidth;
        if (indentStrategy == "INLINE") {
            String previousDocumentRegionText;
            if (availableLineWidth < 0) {
                int lineWidth = this.indentIfPossible(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, whitespaceStrategy, indentStrategy, true);
                availableLineWidth = lineWidth > 0 ? lineWidth - tagNameLineWidth : (availableLineWidth -= tagNameLineWidth);
            } else if (previousDocumentRegion != null && previousDocumentRegion.getType() == "XML_CONTENT" && (previousDocumentRegionText = previousDocumentRegion.getFullText()).trim().length() == 0) {
                availableLineWidth = this.collapseSpaces(textEdit, previousDocumentRegion.getStartOffset(), availableLineWidth, previousDocumentRegionText);
            }
        }
        if (currentTextRegion.getTextLength() < currentTextRegion.getLength()) {
            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
        }
        constraints.setAvailableLineWidth(availableLineWidth);
    }

    private void formatTextInContent(TextEdit textEdit, XMLFormattingConstraints parentConstraints, IStructuredDocumentRegion currentRegion, String fullText, String whitespaceMode) {
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        boolean forceInitialIndent = false;
        int indentLevel = parentConstraints.getIndentLevel() + 1;
        String indentMode = parentConstraints.getIndentStrategy();
        if (indentMode == "INDENT") {
            forceInitialIndent = true;
        }
        if (indentMode == "NEW_LINE") {
            indentLevel = parentConstraints.getIndentLevel();
            forceInitialIndent = true;
        }
        int fullTextOffset = 0;
        char[] fullTextArray = fullText.toCharArray();
        while (fullTextOffset < fullTextArray.length) {
            String whitespaceRun = this.getCharacterRun(fullTextArray, fullTextOffset, true);
            if (whitespaceRun.length() > 0) {
                int whitespaceStart = fullTextOffset;
                String characterRun = this.getCharacterRun(fullTextArray, fullTextOffset += whitespaceRun.length(), false);
                int characterRunLength = characterRun.length();
                if (characterRunLength > 0) {
                    int startOffset = currentRegion.getStartOffset() + whitespaceStart;
                    if (forceInitialIndent || (availableLineWidth -= characterRunLength) <= 0) {
                        availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentRegion, indentLevel, startOffset, whitespaceRun);
                        availableLineWidth -= characterRunLength;
                        forceInitialIndent = false;
                    } else {
                        availableLineWidth = this.collapseSpaces(textEdit, startOffset, availableLineWidth, whitespaceRun);
                    }
                    fullTextOffset += characterRunLength;
                    continue;
                }
                int whitespaceOffset = currentRegion.getStartOffset() + whitespaceStart;
                if (whitespaceMode == "IGNORE") {
                    DeleteEdit deleteTrailing = new DeleteEdit(whitespaceOffset, whitespaceRun.length());
                    textEdit.addChild((TextEdit)deleteTrailing);
                    continue;
                }
                availableLineWidth = this.collapseSpaces(textEdit, whitespaceOffset, availableLineWidth, whitespaceRun);
                continue;
            }
            String characterRun = this.getCharacterRun(fullTextArray, fullTextOffset, false);
            int characterRunLength = characterRun.length();
            if (characterRunLength <= 0) continue;
            if (whitespaceMode == "IGNORE" && (forceInitialIndent || (availableLineWidth -= characterRunLength) <= 0)) {
                availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentRegion, indentLevel, currentRegion.getStartOffset(), whitespaceRun);
                availableLineWidth -= characterRunLength;
                forceInitialIndent = false;
            } else {
                availableLineWidth -= characterRunLength;
            }
            fullTextOffset += characterRunLength;
        }
        parentConstraints.setAvailableLineWidth(availableLineWidth);
    }

    private void formatWithinEndTag(TextEdit textEdit, XMLFormattingConstraints constraints, IStructuredDocumentRegion currentDocumentRegion, IStructuredDocumentRegion previousDocumentRegion) {
        ITextRegion nextTextRegion;
        String nextType;
        int currentTextRegionIndex;
        String indentStrategy = constraints.getIndentStrategy();
        String whitespaceStrategy = constraints.getWhitespaceStrategy();
        int availableLineWidth = constraints.getAvailableLineWidth();
        ITextRegionList textRegions = currentDocumentRegion.getRegions();
        ITextRegion currentTextRegion = textRegions.get(currentTextRegionIndex = 1);
        String currentType = currentTextRegion.getType();
        if (currentType == "XML_TAG_NAME" && (nextType = (nextTextRegion = textRegions.get(currentTextRegionIndex + 1)).getType()) == "XML_TAG_CLOSE") {
            int tagNameLineWidth = currentTextRegion.getTextLength() + 3;
            availableLineWidth -= tagNameLineWidth;
            if (indentStrategy == "INLINE") {
                String previousDocumentRegionText;
                if (availableLineWidth < 0) {
                    int lineWidth = this.indentIfPossible(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, whitespaceStrategy, indentStrategy, false);
                    if (lineWidth > 0) {
                        availableLineWidth = lineWidth - tagNameLineWidth;
                    }
                } else if (previousDocumentRegion != null && previousDocumentRegion.getType() == "XML_CONTENT" && (previousDocumentRegionText = previousDocumentRegion.getFullText()).trim().length() == 0) {
                    availableLineWidth = this.collapseSpaces(textEdit, previousDocumentRegion.getStartOffset(), availableLineWidth, previousDocumentRegionText);
                }
            }
            if (currentTextRegion.getTextLength() < currentTextRegion.getLength()) {
                this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
            }
        }
        constraints.setAvailableLineWidth(availableLineWidth);
    }

    private boolean formatWithinTag(TextEdit textEdit, XMLFormattingConstraints constraints, IStructuredDocumentRegion currentDocumentRegion, IStructuredDocumentRegion previousDocumentRegion) {
        int currentTextRegionIndex;
        int availableLineWidth = constraints.getAvailableLineWidth();
        String indentStrategy = constraints.getIndentStrategy();
        String whitespaceStrategy = constraints.getWhitespaceStrategy();
        int indentLevel = constraints.getIndentLevel();
        ITextRegionList textRegions = currentDocumentRegion.getRegions();
        ITextRegion currentTextRegion = textRegions.get(currentTextRegionIndex = 1);
        String currentType = currentTextRegion.getType();
        if (currentType == "XML_TAG_NAME") {
            String nextType;
            ITextRegion nextTextRegion = textRegions.get(currentTextRegionIndex + 1);
            String string = nextType = nextTextRegion != null ? nextTextRegion.getType() : null;
            if (nextType == "XML_TAG_CLOSE") {
                this.formatStartTagWithNoAttr(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, availableLineWidth, indentStrategy, whitespaceStrategy, currentTextRegion);
                return false;
            }
            if (nextType == "XML_EMPTY_TAG_CLOSE") {
                this.formatEmptyStartTagWithNoAttr(textEdit, constraints, currentDocumentRegion, previousDocumentRegion, availableLineWidth, indentStrategy, whitespaceStrategy, currentTextRegion);
                return true;
            }
            availableLineWidth -= currentTextRegion.getTextLength() + 2;
            boolean alignFinalBracket = this.getFormattingPreferences().getAlignFinalBracket();
            boolean oneSpaceInTagName = this.getFormattingPreferences().getSpaceBeforeEmptyCloseTag();
            boolean indentMultipleAttribute = this.getFormattingPreferences().getIndentMultipleAttributes();
            boolean spanMoreThan1Line = false;
            boolean indentAllAttributes = false;
            if (indentMultipleAttribute) {
                int attributesCount = 0;
                int i = 2;
                while (i < textRegions.size() && attributesCount < 2) {
                    if (textRegions.get(i).getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
                    ++attributesCount;
                }
                indentAllAttributes = attributesCount > 1;
            }
            while (currentTextRegionIndex + 1 < textRegions.size()) {
                nextTextRegion = textRegions.get(currentTextRegionIndex + 1);
                nextType = nextTextRegion.getType();
                if (nextType == "XML_TAG_ATTRIBUTE_NAME") {
                    boolean indentAttribute = indentAllAttributes;
                    if (!indentAttribute) {
                        indentAttribute = this.shouldIndentBeforeAttribute(constraints, textRegions, availableLineWidth, currentTextRegionIndex, currentTextRegion, nextTextRegion);
                    }
                    if (indentAttribute) {
                        availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, indentLevel + 1, currentDocumentRegion, currentTextRegion);
                        spanMoreThan1Line = true;
                    } else {
                        this.insertSpaceAndCollapse(textEdit, currentDocumentRegion, availableLineWidth, currentTextRegion);
                        availableLineWidth -= currentTextRegion.getTextLength() + 1;
                    }
                } else {
                    if (nextType == "XML_TAG_CLOSE") {
                        if (alignFinalBracket && spanMoreThan1Line) {
                            availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, indentLevel, currentDocumentRegion, currentTextRegion);
                            --availableLineWidth;
                        } else if (currentTextRegion.getTextLength() < currentTextRegion.getLength()) {
                            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
                            availableLineWidth -= currentTextRegion.getTextLength() + 1;
                        }
                        constraints.setAvailableLineWidth(availableLineWidth);
                        return false;
                    }
                    if (nextType == "XML_EMPTY_TAG_CLOSE") {
                        int regionLength;
                        boolean thereAreSpaces;
                        int textLength = currentTextRegion.getTextLength();
                        boolean bl = thereAreSpaces = textLength < (regionLength = currentTextRegion.getLength());
                        if (!oneSpaceInTagName && thereAreSpaces) {
                            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
                            availableLineWidth -= currentTextRegion.getTextLength() + 2;
                        } else if (oneSpaceInTagName) {
                            this.insertSpaceAndCollapse(textEdit, currentDocumentRegion, availableLineWidth, currentTextRegion);
                            availableLineWidth -= currentTextRegion.getTextLength() + 3;
                        }
                        constraints.setAvailableLineWidth(availableLineWidth);
                        return true;
                    }
                    if (currentType == "XML_TAG_ATTRIBUTE_NAME" && nextType == "XML_TAG_ATTRIBUTE_EQUALS") {
                        if (currentTextRegion.getTextLength() < currentTextRegion.getLength()) {
                            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
                        }
                        availableLineWidth -= currentTextRegion.getTextLength();
                    } else if (currentType == "XML_TAG_ATTRIBUTE_EQUALS" && nextType == "XML_TAG_ATTRIBUTE_VALUE") {
                        if (currentTextRegion.getTextLength() < currentTextRegion.getLength()) {
                            this.deleteTrailingSpaces(textEdit, currentTextRegion, currentDocumentRegion);
                        }
                        availableLineWidth -= currentTextRegion.getTextLength();
                    } else {
                        this.insertSpaceAndCollapse(textEdit, currentDocumentRegion, availableLineWidth, currentTextRegion);
                        availableLineWidth -= currentTextRegion.getTextLength() + 1;
                    }
                }
                currentTextRegion = nextTextRegion;
                currentType = nextType;
                ++currentTextRegionIndex;
            }
        }
        constraints.setAvailableLineWidth(availableLineWidth);
        return false;
    }

    private void formatComment(TextEdit textEdit, Position formatRange, XMLFormattingConstraints parentConstraints, DOMRegion currentDOMRegion, IStructuredDocumentRegion previousRegion) {
        IStructuredDocumentRegion currentRegion = currentDOMRegion.documentRegion;
        int lineWidth = parentConstraints.getAvailableLineWidth() - currentRegion.getFullText().length();
        if (currentRegion == null || lineWidth >= 0 || parentConstraints.getWhitespaceStrategy() == "PRESERVE") {
            parentConstraints.setAvailableLineWidth(lineWidth);
            return;
        }
        Iterator it = currentRegion.getRegions().iterator();
        while (it.hasNext()) {
            ITextRegion text = (ITextRegion)it.next();
            this.formatCommentTag(textEdit, parentConstraints, currentRegion, text);
        }
    }

    private void formatCommentTag(TextEdit textEdit, XMLFormattingConstraints parentConstraints, IStructuredDocumentRegion currentRegion, ITextRegion region) {
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int indentLevel = parentConstraints.getIndentLevel() + 1;
        boolean initialIndent = false;
        if (region.getType() == "XML_COMMENT_TEXT") {
            ++indentLevel;
            initialIndent = true;
        }
        int fullTextOffset = 0;
        char[] fullTextArray = currentRegion.getFullText(region).toCharArray();
        while (fullTextOffset < fullTextArray.length) {
            String whitespaceRun = null;
            whitespaceRun = region.getType() == "XML_COMMENT_OPEN" && currentRegion.getPrevious() != null ? this.getCharacterRun(currentRegion.getPrevious().getFullText().toCharArray(), 0, true) : this.getCharacterRun(fullTextArray, fullTextOffset, true);
            if (whitespaceRun.length() > 0) {
                String characterRun;
                int characterRunLength;
                int whitespaceStart = fullTextOffset;
                if (region.getType() != "XML_COMMENT_OPEN") {
                    fullTextOffset += whitespaceRun.length();
                }
                if ((characterRunLength = (characterRun = this.getCharacterRun(fullTextArray, fullTextOffset, false)).length()) > 0) {
                    int startOffset = 0;
                    startOffset = region.getType() == "XML_COMMENT_OPEN" && currentRegion.getPrevious() != null ? currentRegion.getPrevious().getStartOffset() : currentRegion.getStartOffset(region) + whitespaceStart;
                    if (region.getType() == "XML_COMMENT_OPEN" || initialIndent || (availableLineWidth -= characterRunLength) <= 0) {
                        availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentRegion, indentLevel, startOffset, whitespaceRun);
                        availableLineWidth -= characterRunLength;
                        if (initialIndent) {
                            initialIndent = false;
                        }
                    } else {
                        availableLineWidth = this.collapseSpaces(textEdit, startOffset, availableLineWidth, whitespaceRun);
                    }
                    fullTextOffset += characterRunLength;
                    continue;
                }
                int whitespaceOffset = currentRegion.getStartOffset(region) + whitespaceStart;
                DeleteEdit deleteTrailing = new DeleteEdit(whitespaceOffset, whitespaceRun.length());
                textEdit.addChild((TextEdit)deleteTrailing);
                continue;
            }
            String characterRun = this.getCharacterRun(fullTextArray, fullTextOffset, false);
            int characterRunLength = characterRun.length();
            if (characterRunLength <= 0) continue;
            if (region.getType() == "XML_COMMENT_CLOSE" || region.getType() == "XML_COMMENT_OPEN" || initialIndent || region.getType() == "XML_COMMENT_TEXT" && (availableLineWidth -= characterRunLength) <= 0) {
                availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentRegion, indentLevel, currentRegion.getStartOffset(region), whitespaceRun);
                availableLineWidth -= characterRunLength;
                if (initialIndent) {
                    initialIndent = false;
                }
            } else {
                availableLineWidth -= characterRunLength;
            }
            fullTextOffset += characterRunLength;
        }
        parentConstraints.setAvailableLineWidth(availableLineWidth);
    }

    private String getCharacterRun(char[] fullTextArray, int textOffset, boolean forWhitespace) {
        StringBuffer characterRun = new StringBuffer();
        boolean nonCharacterFound = false;
        while (textOffset < fullTextArray.length && !nonCharacterFound) {
            char c = fullTextArray[textOffset];
            boolean isWhitespace = Character.isWhitespace(c);
            if (forWhitespace && isWhitespace || !forWhitespace && !isWhitespace) {
                characterRun.append(c);
            } else {
                nonCharacterFound = true;
            }
            ++textOffset;
        }
        return characterRun.toString();
    }

    private String getIndentString(int indentLevel) {
        StringBuffer indentString = new StringBuffer();
        String indent = this.getFormattingPreferences().getOneIndent();
        int i = 0;
        while (i < indentLevel) {
            indentString.append(indent);
            ++i;
        }
        return indentString.toString();
    }

    protected XMLFormattingPreferences getFormattingPreferences() {
        if (this.fPreferences == null) {
            this.fPreferences = new XMLFormattingPreferences();
        }
        return this.fPreferences;
    }

    protected void setFormattingPreferences(XMLFormattingPreferences preferences) {
        this.fPreferences = preferences;
    }

    private int indentIfNotAlreadyIndented(TextEdit textEdit, IStructuredDocumentRegion currentRegion, int indentLevel, int indentStartOffset, String whitespaceRun) {
        int maxAvailableLineWidth = this.getFormattingPreferences().getMaxLineWidth();
        String indentString = this.getIndentString(indentLevel);
        String newLineAndIndent = String.valueOf(this.getLineDelimiter(currentRegion)) + indentString;
        if (!newLineAndIndent.equals(whitespaceRun)) {
            if (whitespaceRun != null) {
                ReplaceEdit replaceEdit = new ReplaceEdit(indentStartOffset, whitespaceRun.length(), newLineAndIndent);
                textEdit.addChild((TextEdit)replaceEdit);
            } else {
                InsertEdit insertEdit = new InsertEdit(indentStartOffset, newLineAndIndent);
                textEdit.addChild((TextEdit)insertEdit);
            }
        }
        int availableLineWidth = maxAvailableLineWidth - indentString.length();
        return availableLineWidth;
    }

    private int indentIfNotAlreadyIndented(TextEdit textEdit, int indentLevel, IStructuredDocumentRegion currentDocumentRegion, ITextRegion currentTextRegion) {
        int textLength = currentTextRegion.getTextLength();
        int regionLength = currentTextRegion.getLength();
        int indentStartOffset = currentDocumentRegion.getTextEndOffset(currentTextRegion);
        String fullText = currentDocumentRegion.getFullText(currentTextRegion);
        String whitespaceRun = fullText.substring(textLength, regionLength);
        int availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentDocumentRegion, indentLevel, indentStartOffset, whitespaceRun);
        return availableLineWidth;
    }

    private int indentIfPossible(TextEdit textEdit, XMLFormattingConstraints thisConstraints, IStructuredDocumentRegion currentDocumentRegion, IStructuredDocumentRegion previousDocumentRegion, String whitespaceStrategy, String indentStrategy, boolean addIndent) {
        int length;
        int availableLineWidth = -1;
        if (previousDocumentRegion == null) {
            return availableLineWidth;
        }
        boolean canIndent = false;
        String previousRegionFullText = null;
        String previousRegionType = null;
        if (whitespaceStrategy == "IGNORE") {
            previousRegionType = previousDocumentRegion.getType();
            canIndent = previousRegionType != "XML_CDATA_TEXT";
        } else if (whitespaceStrategy == "COLLAPSE" && (previousRegionType = previousDocumentRegion.getType()) == "XML_CONTENT" && (length = (previousRegionFullText = previousDocumentRegion.getFullText()).length()) > 1) {
            canIndent = Character.isWhitespace(previousRegionFullText.charAt(length - 1));
        }
        if (canIndent) {
            int indentStartOffset = currentDocumentRegion.getStartOffset();
            String whitespaceRun = null;
            if (previousRegionType == null) {
                previousRegionType = previousDocumentRegion.getType();
            }
            if (previousRegionFullText == null && previousRegionType == "XML_CONTENT") {
                previousRegionFullText = previousDocumentRegion.getFullText();
            }
            if (previousRegionFullText != null && previousRegionFullText.trim().length() == 0) {
                indentStartOffset = previousDocumentRegion.getStartOffset();
                whitespaceRun = previousRegionFullText;
            }
            int indentLevel = thisConstraints.getIndentLevel();
            if (addIndent && indentStrategy == "INDENT") {
                thisConstraints.setIndentLevel(++indentLevel);
            }
            availableLineWidth = this.indentIfNotAlreadyIndented(textEdit, currentDocumentRegion, indentLevel, indentStartOffset, whitespaceRun);
        }
        return availableLineWidth;
    }

    private void insertSpaceAndCollapse(TextEdit textEdit, IStructuredDocumentRegion currentDocumentRegion, int availableLineWidth, ITextRegion currentTextRegion) {
        int regionLength;
        int textLength = currentTextRegion.getTextLength();
        boolean thereAreSpaces = textLength < (regionLength = currentTextRegion.getLength());
        int spacesStartOffset = currentDocumentRegion.getStartOffset(currentTextRegion) + textLength;
        if (thereAreSpaces) {
            String fullTagName = currentDocumentRegion.getFullText(currentTextRegion);
            String whitespaceRun = fullTagName.substring(textLength, regionLength);
            this.collapseSpaces(textEdit, spacesStartOffset, availableLineWidth, whitespaceRun);
        } else {
            InsertEdit insertEdit = new InsertEdit(spacesStartOffset, SPACE);
            textEdit.addChild((TextEdit)insertEdit);
        }
    }

    private boolean shouldIndentBeforeAttribute(XMLFormattingConstraints constraints, ITextRegionList textRegions, int availableLineWidth, int currentTextRegionIndex, ITextRegion currentTextRegion, ITextRegion nextTextRegion) {
        ITextRegion textRegion;
        boolean indentAttribute = false;
        int currentWidth = currentTextRegion.getTextLength() + nextTextRegion.getTextLength() + 1;
        if (currentWidth > availableLineWidth) {
            indentAttribute = true;
        } else if (currentTextRegionIndex + 2 < textRegions.size() && (textRegion = textRegions.get(currentTextRegionIndex + 2)).getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
            if (++currentWidth > availableLineWidth) {
                indentAttribute = true;
            } else if (currentTextRegionIndex + 3 < textRegions.size() && (textRegion = textRegions.get(currentTextRegionIndex + 3)).getType() == "XML_TAG_ATTRIBUTE_VALUE" && (currentWidth = textRegion.getTextLength()) > availableLineWidth) {
                indentAttribute = true;
            }
        }
        return indentAttribute;
    }

    protected void updateFormattingConstraints(XMLFormattingConstraints parentConstraints, XMLFormattingConstraints thisConstraints, XMLFormattingConstraints childConstraints, DOMRegion currentDOMRegion) {
        Node parentNode;
        IStructuredDocumentRegion currentRegion = currentDOMRegion.documentRegion;
        IDOMNode currentNode = currentDOMRegion.domNode;
        if (parentConstraints != null) {
            if (thisConstraints != null) {
                thisConstraints.copyConstraints(parentConstraints);
            }
            if (childConstraints != null) {
                childConstraints.copyConstraints(parentConstraints);
                if (parentConstraints.isWhitespaceStrategyAHint()) {
                    childConstraints.setWhitespaceStrategy(null);
                }
            }
        }
        if ((parentNode = currentNode.getParentNode()) != null && parentNode.getNodeType() == 9) {
            if (thisConstraints != null) {
                thisConstraints.setWhitespaceStrategy("IGNORE");
                thisConstraints.setIndentStrategy("NEW_LINE");
                thisConstraints.setIndentLevel(0);
            }
            if (childConstraints != null) {
                childConstraints.setWhitespaceStrategy(null);
                childConstraints.setIndentStrategy(null);
                childConstraints.setIndentLevel(0);
            }
        }
        if (childConstraints != null) {
            XMLFormattingPreferences preferences = this.getFormattingPreferences();
            if (currentNode.getNodeType() == 9) {
                childConstraints.setWhitespaceStrategy("IGNORE");
                childConstraints.setIndentStrategy("NEW_LINE");
                childConstraints.setIndentLevel(0);
            } else {
                String nodeNamespaceURI = currentNode.getNamespaceURI();
                if (XSL_NAMESPACE.equals(nodeNamespaceURI)) {
                    String nodeName = ((Element)((Object)currentNode)).getLocalName();
                    if (XSL_ATTRIBUTE.equals(nodeName) || XSL_TEXT.equals(nodeName)) {
                        childConstraints.setWhitespaceStrategy("PRESERVE");
                    }
                } else {
                    ITextRegionList textRegions = currentRegion.getRegions();
                    int i = 0;
                    boolean xmlSpaceFound = false;
                    boolean preserveFound = false;
                    while (i < textRegions.size() && !xmlSpaceFound) {
                        String regionText;
                        ITextRegion textRegion = textRegions.get(i);
                        if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" && XML_SPACE.equals(regionText = currentRegion.getText(textRegion))) {
                            if (i + 1 < textRegions.size() && (textRegion = textRegions.get(++i)).getType() == "XML_TAG_ATTRIBUTE_EQUALS" && i + 1 < textRegions.size() && (PRESERVE.equals(regionText = currentRegion.getText(textRegion = textRegions.get(++i))) || PRESERVE_QUOTED.equals(regionText))) {
                                preserveFound = true;
                            }
                            xmlSpaceFound = true;
                        }
                        ++i;
                    }
                    if (xmlSpaceFound) {
                        if (preserveFound) {
                            childConstraints.setWhitespaceStrategy("PRESERVE");
                        } else {
                            childConstraints.setWhitespaceStrategy("DEFAULT");
                        }
                    } else {
                        ModelQueryAdapter adapter;
                        CMElementDeclaration elementDeclaration;
                        NodeList nodeList = currentNode.getChildNodes();
                        int length = nodeList.getLength();
                        int index = 0;
                        boolean textNodeFound = false;
                        while (index < length && !textNodeFound && parentConstraints != null && !"PRESERVE".equals(parentConstraints.getWhitespaceStrategy())) {
                            Node childNode = nodeList.item(index);
                            if (childNode.getNodeType() == 3) {
                                textNodeFound = !((IDOMText)childNode).isElementContentWhitespace();
                            }
                            ++index;
                        }
                        if (textNodeFound) {
                            if (length > 1) {
                                childConstraints.setWhitespaceStrategy(preferences.getMixedWhitespaceStrategy());
                                childConstraints.setIndentStrategy(preferences.getMixedIndentStrategy());
                            } else {
                                childConstraints.setWhitespaceStrategy(preferences.getTextWhitespaceStrategy());
                                childConstraints.setIndentStrategy(preferences.getTextIndentStrategy());
                            }
                            childConstraints.setIsWhitespaceStrategyAHint(true);
                            childConstraints.setIsIndentStrategyAHint(true);
                        }
                        IDOMDocument iDOMDocument = (IDOMDocument)currentNode.getOwnerDocument();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((elementDeclaration = (CMElementDeclaration)(adapter = (ModelQueryAdapter)iDOMDocument.getAdapterFor(clazz)).getModelQuery().getCMNode(currentNode)) != null) {
                            int contentType = elementDeclaration.getContentType();
                            if (contentType == 4 && parentConstraints != null && !"PRESERVE".equals(parentConstraints.getWhitespaceStrategy())) {
                                childConstraints.setWhitespaceStrategy(preferences.getPCDataWhitespaceStrategy());
                            } else if (contentType == 2 && parentConstraints != null && !"PRESERVE".equals(parentConstraints.getWhitespaceStrategy())) {
                                childConstraints.setWhitespaceStrategy("IGNORE");
                                childConstraints.setIndentStrategy("INDENT");
                                childConstraints.setIsWhitespaceStrategyAHint(true);
                                childConstraints.setIsIndentStrategyAHint(true);
                            } else {
                                CMDataType dataType = elementDeclaration.getDataType();
                                if (dataType != null && STRING.equals(dataType.getDataTypeName())) {
                                    childConstraints.setWhitespaceStrategy("PRESERVE");
                                } else {
                                    CMNamedNodeMap cmAttributes = elementDeclaration.getAttributes();
                                    CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl(cmAttributes);
                                    List nodes = ModelQueryUtil.getModelQuery(currentNode.getOwnerDocument()).getAvailableContent((Element)((Object)currentNode), elementDeclaration, 1);
                                    int k = 0;
                                    while (k < nodes.size()) {
                                        CMNode cmnode = (CMNode)nodes.get(k);
                                        if (cmnode.getNodeType() == 2) {
                                            allAttributes.put(cmnode);
                                        }
                                        ++k;
                                    }
                                    cmAttributes = allAttributes;
                                    CMAttributeDeclaration attributeDeclaration = (CMAttributeDeclaration)cmAttributes.getNamedItem(XML_SPACE);
                                    if (attributeDeclaration != null) {
                                        String defaultValue = null;
                                        CMDataType attrType = attributeDeclaration.getAttrType();
                                        if (attrType != null) {
                                            if (attrType.getImpliedValueKind() != 1 && attrType.getImpliedValue() != null) {
                                                defaultValue = attrType.getImpliedValue();
                                            } else if (attrType.getEnumeratedValues() != null && attrType.getEnumeratedValues().length > 0) {
                                                defaultValue = attrType.getEnumeratedValues()[0];
                                            }
                                        }
                                        if (PRESERVE.equals(defaultValue)) {
                                            childConstraints.setWhitespaceStrategy("PRESERVE");
                                        } else {
                                            childConstraints.setWhitespaceStrategy("DEFAULT");
                                        }
                                    } else if (parentConstraints != null) {
                                        childConstraints.setWhitespaceStrategy(parentConstraints.getWhitespaceStrategy());
                                    } else {
                                        childConstraints.setWhitespaceStrategy(null);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (childConstraints.getWhitespaceStrategy() == null) {
                childConstraints.setWhitespaceStrategy(preferences.getElementWhitespaceStrategy());
            }
            if (childConstraints.getIndentStrategy() == null) {
                childConstraints.setIndentStrategy(preferences.getElementIndentStrategy());
            }
        }
    }

    private int updateLineWidthWithLastLine(String fullText, int availableLineWidth) {
        int maxAvailableLineWidth = this.getFormattingPreferences().getMaxLineWidth();
        int lineWidth = availableLineWidth;
        if (fullText != null) {
            int textLength = fullText.length();
            int lastLFOffset = fullText.lastIndexOf(10);
            int lastCROffset = fullText.lastIndexOf(13);
            if (lastLFOffset == -1 && lastCROffset == -1) {
                lineWidth -= fullText.length();
            } else {
                int lastNewLine = Math.max(lastLFOffset, lastCROffset);
                lineWidth = maxAvailableLineWidth - (textLength - lastNewLine);
            }
        }
        return lineWidth;
    }

    private String getLineDelimiter(IStructuredDocumentRegion currentRegion) {
        IStructuredDocument doc = currentRegion.getParentDocument();
        int line = doc.getLineOfOffset(currentRegion.getStartOffset());
        String lineDelimiter = doc.getLineDelimiter();
        try {
            if (line > 0) {
                lineDelimiter = doc.getLineDelimiter(line - 1);
            }
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        if (lineDelimiter == null) {
            lineDelimiter = doc.getLineDelimiter();
        }
        return lineDelimiter;
    }

    void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected class DOMRegion {
        public IDOMNode domNode;
        public IStructuredDocumentRegion documentRegion;

        protected DOMRegion() {
        }
    }
}

