/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.command.SetDebugModeCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.SetSaveSeparateContextFilesCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.SetSecureCommand;
import org.eclipse.jst.server.tomcat.core.internal.command.SetServeModulesWithoutPublishCommand;
import org.eclipse.jst.server.tomcat.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerGeneralEditorSection
extends ServerEditorSection {
    protected TomcatServer tomcatServer;
    protected Button secure;
    protected Button debug;
    protected Button noPublish;
    protected Button separateContextFiles;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected boolean noPublishChanged;
    protected boolean separateContextFilesChanged;
    static /* synthetic */ Class class$0;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                if ("secure".equals(event.getPropertyName())) {
                    Boolean b = (Boolean)event.getNewValue();
                    ServerGeneralEditorSection.this.secure.setSelection(b.booleanValue());
                } else if ("debug".equals(event.getPropertyName())) {
                    Boolean b = (Boolean)event.getNewValue();
                    ServerGeneralEditorSection.this.debug.setSelection(b.booleanValue());
                } else if ("serveModulesWithoutPublish".equals(event.getPropertyName())) {
                    Boolean b = (Boolean)event.getNewValue();
                    ServerGeneralEditorSection.this.noPublish.setSelection(b.booleanValue());
                    ServerGeneralEditorSection.this.noPublishChanged = true;
                } else if ("saveSeparateContextFiles".equals(event.getPropertyName())) {
                    Boolean b = (Boolean)event.getNewValue();
                    ServerGeneralEditorSection.this.separateContextFiles.setSelection(b.booleanValue());
                    ServerGeneralEditorSection.this.separateContextFilesChanged = true;
                }
                ServerGeneralEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText(Messages.serverEditorGeneralSection);
        section.setDescription(Messages.serverEditorGeneralDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.jst.server.tomcat.ui.teig0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.noPublish = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorNoPublish, (Object)""), 32);
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.noPublish.setLayoutData((Object)data);
        this.noPublish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetServeModulesWithoutPublishCommand((ITomcatServerWorkingCopy)ServerGeneralEditorSection.this.tomcatServer, ServerGeneralEditorSection.this.noPublish.getSelection()));
                ServerGeneralEditorSection.this.noPublishChanged = true;
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        this.separateContextFiles = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorSeparateContextFiles, (Object)""), 32);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.separateContextFiles.setLayoutData((Object)data);
        this.separateContextFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetSaveSeparateContextFilesCommand((ITomcatServerWorkingCopy)ServerGeneralEditorSection.this.tomcatServer, ServerGeneralEditorSection.this.separateContextFiles.getSelection()));
                ServerGeneralEditorSection.this.separateContextFilesChanged = true;
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        this.secure = toolkit.createButton(composite, Messages.serverEditorSecure, 32);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.secure.setLayoutData((Object)data);
        this.secure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetSecureCommand((ITomcatServerWorkingCopy)ServerGeneralEditorSection.this.tomcatServer, ServerGeneralEditorSection.this.secure.getSelection()));
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        whs.setHelp((Control)this.secure, "org.eclipse.jst.server.tomcat.ui.teig0004");
        this.debug = toolkit.createButton(composite, NLS.bind((String)Messages.serverEditorDebugMode, (Object)""), 32);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.debug.setLayoutData((Object)data);
        this.debug.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (ServerGeneralEditorSection.this.updating) {
                    return;
                }
                ServerGeneralEditorSection.this.updating = true;
                ServerGeneralEditorSection.this.execute((IUndoableOperation)new SetDebugModeCommand((ITomcatServerWorkingCopy)ServerGeneralEditorSection.this.tomcatServer, ServerGeneralEditorSection.this.debug.getSelection()));
                ServerGeneralEditorSection.this.updating = false;
            }
        });
        whs.setHelp((Control)this.debug, "org.eclipse.jst.server.tomcat.ui.teig0006");
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tomcatServer = (TomcatServer)this.server.loadAdapter((Class)clazz, null);
            this.addChangeListener();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.secure == null || this.tomcatServer == null) {
            return;
        }
        this.updating = true;
        ITomcatVersionHandler tvh = this.tomcatServer.getTomcatVersionHandler();
        boolean supported = tvh.supportsServeModulesWithoutPublish();
        String label = NLS.bind((String)Messages.serverEditorNoPublish, (Object)(supported ? "" : Messages.serverEditorNotSupported));
        this.noPublish.setText(label);
        this.noPublish.setSelection(this.tomcatServer.isServeModulesWithoutPublish());
        if (this.readOnly || !supported) {
            this.noPublish.setEnabled(false);
        } else {
            this.noPublish.setEnabled(true);
        }
        supported = tvh.supportsSeparateContextFiles();
        label = NLS.bind((String)Messages.serverEditorSeparateContextFiles, (Object)(supported ? "" : Messages.serverEditorNotSupported));
        this.separateContextFiles.setText(label);
        this.separateContextFiles.setSelection(this.tomcatServer.isSaveSeparateContextFiles());
        if (this.readOnly || !supported) {
            this.separateContextFiles.setEnabled(false);
        } else {
            this.separateContextFiles.setEnabled(true);
        }
        this.secure.setSelection(this.tomcatServer.isSecure());
        supported = tvh.supportsDebugArgument();
        label = NLS.bind((String)Messages.serverEditorDebugMode, (Object)(supported ? "" : Messages.serverEditorNotSupported));
        this.debug.setText(label);
        if (this.readOnly || !supported) {
            this.debug.setEnabled(false);
        } else {
            this.debug.setEnabled(true);
            this.debug.setSelection(this.tomcatServer.isDebug());
        }
        if (this.readOnly) {
            this.secure.setEnabled(false);
        } else {
            this.secure.setEnabled(true);
        }
        this.updating = false;
    }

    public IStatus[] getSaveStatus() {
        if (this.noPublishChanged) {
            if (this.tomcatServer.getServer().getServerState() != 4) {
                return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", NLS.bind((String)Messages.errorServerMustBeStopped, (Object)NLS.bind((String)Messages.serverEditorNoPublish, (Object)"").trim()))};
            }
            this.tomcatServer.getServer().publish(4, null, null, null);
            this.noPublishChanged = false;
        }
        if (this.separateContextFilesChanged && this.tomcatServer.getServer().getServerState() != 4) {
            return new IStatus[]{new Status(4, "org.eclipse.jst.server.tomcat.ui", NLS.bind((String)Messages.errorServerMustBeStopped, (Object)NLS.bind((String)Messages.serverEditorSeparateContextFiles, (Object)"").trim()))};
        }
        return super.getSaveStatus();
    }
}

