/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.CommonDirectivesSection;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDIncludeImpl;
import org.eclipse.xsd.impl.XSDRedefineImpl;
import org.w3c.dom.Element;

public class SchemaLocationSection
extends CommonDirectivesSection {
    IWorkbenchPart part;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        schemaLocationLabel.setLayoutData((Object)data);
        this.schemaLocationText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.schemaLocationText.setEditable(true);
        this.applyAllListeners((Control)this.schemaLocationText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.schemaLocationText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaLocationText, "org.eclipse.wst.xsd.ui.xsdup0360");
        this.wizardButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.wizardButton.setLayoutData((Object)data);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
    }

    public void doWidgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            ResourceFilter filter;
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = null;
            IEditorInput editorInput = this.getActiveEditor().getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                currentIFile = ((IFileEditorInput)editorInput).getFile();
                filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{currentIFile}, null);
            } else {
                filter = new ResourceFilter(new String[]{".xsd"}, null, null);
            }
            XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(this.xsdSchema, true, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)this.getSelection());
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            String value = this.schemaLocationText.getText();
            if (result == 0) {
                this.errorText.setText("");
                IFile selectedIFile = fileSelectWizard.getResultFile();
                String schemaFileString = value;
                schemaFileString = selectedIFile != null && currentIFile != null ? URIHelper.getRelativeURI((IPath)selectedIFile.getLocation(), (IPath)currentIFile.getLocation()) : (selectedIFile != null && currentIFile == null ? selectedIFile.getLocationURI().toString() : fileSelectWizard.getURL());
                this.handleSchemaLocationChange(schemaFileString, fileSelectWizard.getNamespace(), null);
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Element element = null;
        if (this.input instanceof XSDInclude) {
            element = ((XSDIncludeImpl)this.input).getElement();
        } else if (this.input instanceof XSDRedefine) {
            element = ((XSDRedefineImpl)this.input).getElement();
        }
        if (element != null) {
            String location = "";
            location = element.getAttribute("schemaLocation");
            if (location == null) {
                location = "";
            }
            this.schemaLocationText.setText(location);
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void handleSchemaLocationChange(String schemaFileString, String namespace, XSDSchema externalSchema) {
        if (this.input instanceof XSDInclude) {
            Element element = ((XSDIncludeImpl)this.input).getElement();
            element.setAttribute("schemaLocation", schemaFileString);
        } else if (this.input instanceof XSDRedefine) {
            Element element = ((XSDRedefineImpl)this.input).getElement();
            element.setAttribute("schemaLocation", schemaFileString);
        }
    }
}

